# How to Setup SQLC CRUD API with Golang and Gin Gonic

This article will teach you how to set up a SQLC API project with Golang, standard Database/SQL package, Gin Gonic, PostgreSQL, Golang-migrate, and Docker-compose. You will also learn how to generate Golang database CRUD functions and Structs with the SQLC compiler. The SQLC Golang API will use a PostgreSQL database and run on the Gin Gonic HTTP server. We will use the Golang-migrate package to push the SQL schema to the database.

![How to Setup SQLC CRUD API with Golang and Gin Gonic](https://codevoweb.com/wp-content/uploads/2022/06/How-to-Setup-SQLC-CRUD-API-with-Golang-and-Gin-Gonic.webp)

## Topics Covered

- How to Setup Golang with PostgreSQL
- How to Run Database Migration in Golang
- Generate Golang CRUD Functions and Structs with SQLC
- Initialize the Golang Project
- Connect the Golang App to PostgreSQL
- How to Hash Passwords in Golang
- Create a Route Handler to Register User
- Setup Routing
- Configure the Main Server File
- Testing the Golang Gin API

Read the entire article here: [https://codevoweb.com/api-golang-postgresql-sqlc-gin-gonic-project-setup](https://codevoweb.com/api-golang-postgresql-sqlc-gin-gonic-project-setup)

Articles in this series:

### 1. How to Setup SQLC CRUD API with Golang and Gin Gonic
[How to Setup SQLC CRUD API with Golang and Gin Gonic](https://codevoweb.com/api-golang-postgresql-sqlc-gin-gonic-project-setup)

### 2. Build Golang & PostgreSQL API: JWT Access and Refresh Tokens
[Build Golang & PostgreSQL API: JWT Access and Refresh Tokens](https://codevoweb.com/golang-postgresql-api-access-and-refresh-tokens)

### 3. Golang CRUD RESTful API with SQLC and PostgreSQL
[Golang CRUD RESTful API with SQLC and PostgreSQL](https://codevoweb.com/golang-crud-restful-api-with-sqlc-and-postgresql)
