# Using React Query with Supabase in Next.js App Router

In this article, you will learn how to use Supabase with React Query in the new Next.js app directory, focusing on both client and server components. Additionally, you will learn how to leverage the Supabase CLI for performing database migrations and seeding data with dummy content for testing.

![Using React Query with Supabase in Next.js App Router](https://codevoweb.com/wp-content/uploads/2024/01/Using-React-Query-with-Supabase-in-Next.js-App-Router.webp)

### Topics Covered

- Bootstrap the Next.js 14+ Project
- Install the Necessary Dependencies
- Create a Project on Supabase
- Setup Supabase in the Next.js App Router
  - Initialize and Perform Migrations with the Supabase CLI
  - Generate the Database Types with the Supabase CLI
- Set Up React Query in the Next.js App Router
- Create the Supabase Client
- Create a Hook to Fetch Data
- Create a Hook to Mutate Data
- Using Supabase and React Query on the Client
  - Fetching Data in a Client Component
  - Mutating Data in a Client Component
  - Render the Components in a Page File
- Using Supabase and React Query on the Server
  - Create the Supabase Server Client
  - Prefetch Data on the Server
- Conclusion


Read the entire article here: [https://codevoweb.com/using-react-query-with-supabase-in-next-js-app-router/](https://codevoweb.com/using-react-query-with-supabase-in-next-js-app-router/)
