# Next.js, GraphQL-CodeGen, & React Query: JWT Authentication

This article will teach you how to add access and refresh token functionalities to your Next.js app using React Query, graphql-request, GraphQL CodeGen, React-Hook-Form,  and Zod.

![Next.js, GraphQL-CodeGen, & React Query: JWT Authentication](https://codevoweb.com/wp-content/uploads/2022/07/Next.js-GraphQL-CodeGen-React-Query-JWT-Authentication.webp)

## Topics Covered

- Next.js, React Query & GraphQL-CodeGen Overview
- Setup React Query & GraphQL CodeGen in Next.js
    - Install and Setup React Query
    - Install GraphQL and GraphQL-Request
    - GraphQL-CodeGen Manual Setup
- Create the GraphQL Mutations and Queries
    - Sign-up User Mutation
    - Sign-in User Mutation
    - Get Authenticated User Query
    - Refresh Access Token Query
    - Logout User Query
- Generating the Typescript Types & React Query Hooks
- Setup tailwindCss in Next.js
- Creating React Query, Axios & GraphQL Clients
    - GraphQL Request Client
    - Axios GraphQL Request Client
- State Management with Zustand
- Creating React Components with TailwindCSS
    - Creating a Loading Spinner
    - Creating the Header Component
    - Creating a Full-Screen Loader
    - Creating a Loading Button
    - Creating an InputField Component with React-Hook-Form
    - Creating a FileUpload with Cloudinary and React
- React Query & GraphQL Request: Sign-up User
- React Query & GraphQL Request: Login User
- React Query & GraphQL Request: Middleware Guard
- Creaeting the Profile and Home Pages
    - Home Page
    - Profile Page
- Update the App File

Read the entire article here: [https://codevoweb.com/nextjs-graphql-codegen-react-query-jwt-authentication](https://codevoweb.com/nextjs-graphql-codegen-react-query-jwt-authentication)

Articles in this series::

1. [GraphQL API with Next.js & MongoDB: Access & Refresh Tokens](https://codevoweb.com/graphql-api-next-mongodb-access-and-refresh-tokens)
2. [Next.js, GraphQL-CodeGen, & React Query: JWT Authentication](https://codevoweb.com/nextjs-graphql-codegen-react-query-jwt-authentication)
3. [GraphQL CRUD API with Next.js, MongoDB, and TypeGraphQL](https://codevoweb.com/graphql-crud-api-nextjs-mongodb-typegraphql)
4. [Next.js Full-Stack App with React Query, and GraphQL-CodeGen](https://codevoweb.com/nextjs-full-stack-app-with-react-query-and-graphql-codegen)

