# API with Node.js, Prisma & PostgreSQL: Forget/Reset Password

In this article, you'll learn how to implement forget/reset passwords with Node.js, Prisma, PostgreSQL, Nodemailer, Redis, Docker-compose, and Pug. Also, you will learn how to dynamically generate HTML Email templates with Pug and send them via SMTP to the user's Email inbox.

![API with Node.js, Prisma & PostgreSQL: Forget/Reset Password](https://codevoweb.com/wp-content/uploads/2022/05/API-with-Node.js-Prisma-PostgreSQL-Forget-Reset-Password.webp)

## Topics Covered

- Forget/Reset Password Flow in Node.js
- Update the Prisma User Model
- Run the Prisma Migration Command to Update the Database
- Update the Zod User Schema
- Create Services to Query and Mutate the Database
- Create a Utility Class to Send Emails
- Create Controllers
    - Forgot Password Controller
    - Create the Password Reset Controller
- Add the Routes to the Middleware Pipeline

Read the entire article here: [https://codevoweb.com/crud-api-node-prisma-postgresql-reset-password](https://codevoweb.com/crud-api-node-prisma-postgresql-reset-password)

Articles in this series:

### 1. Setup Node.js API with Prisma, TypeScript, and PostgreSQL

[Setup Node.js API with Prisma, TypeScript, and PostgreSQL](https://codevoweb.com/api-node-typescript-prisma-postgresql-project-setup)

### 2. Node.js + Prisma + PostgreSQL: Access & Refresh Tokens

[API Node.js, TypeScript, Prisma, PostgreSQL: Project Setup](https://codevoweb.com/node-prisma-postgresql-access-refresh-tokens)

### 3. CRUD API with Node.js and PostgreSQL: Send HTML Emails

[CRUD API with Node.js and PostgreSQL: Send HTML Emails](https://codevoweb.com/crud-api-node-js-and-postgresql-send-html-emails)

### 4. API with Node.js, Prisma & PostgreSQL: Forget/Reset Password

[API with Node.js, Prisma & PostgreSQL: Forget/Reset Password](https://codevoweb.com/crud-api-node-prisma-postgresql-reset-password)
