/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.ide.common.blame.SourceFilePosition;
import com.android.manifmerger.ActionRecorder;
import com.android.manifmerger.Actions;
import com.android.manifmerger.DeepLink;
import com.android.manifmerger.ManifestModel;
import com.android.manifmerger.MergingReport;
import com.android.manifmerger.NavigationXmlDocument;
import com.android.manifmerger.XmlAttribute;
import com.android.manifmerger.XmlDocument;
import com.android.manifmerger.XmlElement;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003+,-B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u000b\u001a\u00020\fJ,\u0010\u0004\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J4\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\t2\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J8\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0011\u001a\u00020\t2\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016Jr\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\t2\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u00182\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u000e\b\u0002\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u000e\b\u0002\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\t0\u001a2\u000e\b\u0002\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\u001eH\u0002J \u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"H\u0002J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\t0\u00132\u0006\u0010 \u001a\u00020\u0014H\u0002J \u0010%\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010&\u001a\u00020'H\u0002J \u0010(\u001a\u00020\r2\u0006\u0010)\u001a\u00020*2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010&\u001a\u00020'H\u0002\u00a8\u0006."}, d2={"Lcom/android/manifmerger/NavGraphExpander;", "", "<init>", "()V", "expandNavGraphs", "Lcom/android/manifmerger/XmlDocument;", "xmlDocument", "loadedNavigationMap", "", "", "Lcom/android/manifmerger/NavigationXmlDocument;", "mergingReportBuilder", "Lcom/android/manifmerger/MergingReport$Builder;", "", "xmlElement", "Lcom/android/manifmerger/XmlElement;", "expandNavGraph", "navigationXmlId", "findDeepLinks", "", "Lcom/android/manifmerger/DeepLink;", "sourceFilePosition", "Lcom/android/ide/common/blame/SourceFilePosition;", "deepLinkList", "", "deepLinkComparisonObjects", "", "Lcom/android/manifmerger/NavGraphExpander$DeepLinkComparisonObject;", "visitedNavigationFiles", "navigationFileAncestors", "Ljava/util/TreeSet;", "getDeepLinkUriBody", "deepLink", "includeQuery", "", "includeFragment", "getDeepLinkUris", "recordXmlElementAddition", "actionRecorder", "Lcom/android/manifmerger/ActionRecorder;", "recordXmlAttributeAddition", "xmlAttribute", "Lcom/android/manifmerger/XmlAttribute;", "DeepLinkComparisonObject", "ChildElementData", "NavGraphException", "unnamed"})
@SourceDebugExtension(value={"SMAP\nNavGraphExpander.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavGraphExpander.kt\ncom/android/manifmerger/NavGraphExpander\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,387:1\n1485#2:388\n1510#2,3:389\n1513#2,3:399\n1368#2:402\n1454#2,5:403\n1863#2,2:408\n381#3,7:392\n*S KotlinDebug\n*F\n+ 1 NavGraphExpander.kt\ncom/android/manifmerger/NavGraphExpander\n*L\n149#1:388\n149#1:389,3\n149#1:399,3\n171#1:402\n171#1:403,5\n194#1:408,2\n149#1:392,7\n*E\n"})
public final class NavGraphExpander {
    @NotNull
    public static final NavGraphExpander INSTANCE = new NavGraphExpander();

    private NavGraphExpander() {
    }

    @NotNull
    public final XmlDocument expandNavGraphs(@NotNull XmlDocument xmlDocument, @NotNull Map<String, NavigationXmlDocument> loadedNavigationMap, @NotNull MergingReport.Builder mergingReportBuilder) {
        Intrinsics.checkNotNullParameter((Object)xmlDocument, (String)"xmlDocument");
        Intrinsics.checkNotNullParameter(loadedNavigationMap, (String)"loadedNavigationMap");
        Intrinsics.checkNotNullParameter((Object)mergingReportBuilder, (String)"mergingReportBuilder");
        XmlElement xmlElement = xmlDocument.getRootNode();
        Intrinsics.checkNotNullExpressionValue((Object)xmlElement, (String)"getRootNode(...)");
        this.expandNavGraphs(xmlElement, loadedNavigationMap, mergingReportBuilder);
        return xmlDocument;
    }

    private final void expandNavGraphs(XmlElement xmlElement, Map<String, NavigationXmlDocument> loadedNavigationMap, MergingReport.Builder mergingReportBuilder) {
        XmlElement navGraph;
        UnmodifiableIterator unmodifiableIterator = xmlElement.getMergeableElements().iterator();
        Intrinsics.checkNotNullExpressionValue((Object)unmodifiableIterator, (String)"iterator(...)");
        UnmodifiableIterator unmodifiableIterator2 = unmodifiableIterator;
        while (unmodifiableIterator2.hasNext()) {
            XmlElement childElement = (XmlElement)unmodifiableIterator2.next();
            Intrinsics.checkNotNull((Object)childElement);
            this.expandNavGraphs(childElement, loadedNavigationMap, mergingReportBuilder);
        }
        if (!Intrinsics.areEqual((Object)xmlElement.getTagName(), (Object)"activity")) {
            return;
        }
        ImmutableList<XmlElement> immutableList = xmlElement.getAllNodesByType(ManifestModel.NodeTypes.NAV_GRAPH);
        Intrinsics.checkNotNullExpressionValue(immutableList, (String)"getAllNodesByType(...)");
        ImmutableList<XmlElement> navGraphs = immutableList;
        if (navGraphs.isEmpty()) {
            return;
        }
        UnmodifiableIterator unmodifiableIterator3 = navGraphs.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)unmodifiableIterator3, (String)"iterator(...)");
        UnmodifiableIterator unmodifiableIterator4 = unmodifiableIterator3;
        while (unmodifiableIterator4.hasNext()) {
            String navigationXmlId;
            String string;
            String graphValue;
            navGraph = (XmlElement)unmodifiableIterator4.next();
            String string2 = graphValue = navGraph.getAttributeValue("http://schemas.android.com/apk/res/android", "value");
            boolean bl = string2 != null ? StringsKt.startsWith$default((String)string2, (String)"@navigation/", (boolean)false, (int)2, null) : false;
            if (bl) {
                String string3 = graphValue.substring(12);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            } else {
                string = navigationXmlId = null;
            }
            if (navigationXmlId == null) {
                String string4 = navGraph.lookupNamespacePrefix("http://schemas.android.com/apk/res/android", false);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"lookupNamespacePrefix(...)");
                String nsUriPrefix = string4;
                String graphName = nsUriPrefix + ":value";
                mergingReportBuilder.addMessage(new SourceFilePosition(xmlElement.getDocument().getSourceFile(), xmlElement.getPosition()), MergingReport.Record.Severity.ERROR, "Missing or malformed attribute in <nav-graph> element. Android manifest <nav-graph> element must contain a " + graphName + " attribute with a value beginning with \"@navigation/\".");
                return;
            }
            this.expandNavGraph(xmlElement, navigationXmlId, loadedNavigationMap, mergingReportBuilder);
        }
        UnmodifiableIterator unmodifiableIterator5 = navGraphs.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)unmodifiableIterator5, (String)"iterator(...)");
        unmodifiableIterator4 = unmodifiableIterator5;
        while (unmodifiableIterator4.hasNext()) {
            navGraph = (XmlElement)unmodifiableIterator4.next();
            xmlElement.removeChild(navGraph);
            mergingReportBuilder.getActionRecorder().recordNodeAction(navGraph, Actions.ActionType.CONVERTED);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void expandNavGraph(XmlElement xmlElement, String navigationXmlId, Map<String, NavigationXmlDocument> loadedNavigationMap, MergingReport.Builder mergingReportBuilder) {
        void $this$groupByTo$iv$iv;
        List<DeepLink> list;
        SourceFilePosition sourceFilePosition = new SourceFilePosition(xmlElement.getDocument().getSourceFile(), xmlElement.getPosition());
        try {
            list = this.findDeepLinks(navigationXmlId, loadedNavigationMap, mergingReportBuilder, sourceFilePosition);
        }
        catch (NavGraphException e) {
            String string = e.getMessage();
            if (string == null) {
                string = "Error finding deep links.";
            }
            mergingReportBuilder.addMessage(sourceFilePosition, MergingReport.Record.Severity.ERROR, string);
            return;
        }
        List<DeepLink> deepLinks2 = list;
        ActionRecorder actionRecorder = mergingReportBuilder.getActionRecorder();
        Intrinsics.checkNotNullExpressionValue((Object)actionRecorder, (String)"getActionRecorder(...)");
        ActionRecorder actionRecorder2 = actionRecorder;
        Iterable $this$groupBy$iv = deepLinks2;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            DeepLink it = (DeepLink)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = INSTANCE.getDeepLinkUriBody(it, false, false);
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map deepLinkGroups = destination$iv$iv;
        for (List deepLinkGroup : deepLinkGroups.values()) {
            void $this$flatMapTo$iv$iv;
            XmlElement intentFilterXmlElement;
            DeepLink deepLink = (DeepLink)CollectionsKt.first((List)deepLinkGroup);
            Intrinsics.checkNotNullExpressionValue((Object)xmlElement.addChildElement("intent-filter"), (String)"addChildElement(...)");
            if (deepLink.isAutoVerify()) {
                intentFilterXmlElement.addAttribute("http://schemas.android.com/apk/res/android", "autoVerify", "true");
            }
            List childElementDataList = new ArrayList();
            if (!StringsKt.isBlank((CharSequence)deepLink.getAction())) {
                childElementDataList.add(new ChildElementData("action", "name", deepLink.getAction()));
            }
            childElementDataList.add(new ChildElementData("category", "name", "android.intent.category.DEFAULT"));
            childElementDataList.add(new ChildElementData("category", "name", "android.intent.category.BROWSABLE"));
            Iterable $this$flatMap$iv = deepLinkGroup;
            boolean $i$f$flatMap = false;
            Iterable bl = $this$flatMap$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                DeepLink it = (DeepLink)element$iv$iv;
                boolean bl3 = false;
                Iterable list$iv$iv = it.getSchemes();
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            for (String scheme : CollectionsKt.toSet((Iterable)((List)destination$iv$iv2))) {
                childElementDataList.add(new ChildElementData("data", "scheme", scheme));
            }
            if (deepLink.getHost() != null) {
                childElementDataList.add(new ChildElementData("data", "host", deepLink.getHost()));
            }
            if (deepLink.getPort() != -1) {
                childElementDataList.add(new ChildElementData("data", "port", String.valueOf(deepLink.getPort())));
            }
            String path = deepLink.getPath();
            boolean bl4 = StringsKt.substringBefore$default((String)path, (String)".*", null, (int)2, null).length() == path.length() - 2 ? childElementDataList.add(new ChildElementData("data", "pathPrefix", StringsKt.substringBefore$default((String)path, (String)".*", null, (int)2, null))) : (StringsKt.contains$default((CharSequence)path, (CharSequence)".*", (boolean)false, (int)2, null) ? childElementDataList.add(new ChildElementData("data", "pathPattern", path)) : childElementDataList.add(new ChildElementData("data", "path", path)));
            if (deepLink.getMimeType() != null) {
                childElementDataList.add(new ChildElementData("data", "mimeType", deepLink.getMimeType()));
            }
            Iterable $this$forEach$iv = childElementDataList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ChildElementData it = (ChildElementData)element$iv;
                boolean bl5 = false;
                intentFilterXmlElement.addChildElementWithSingleAttribute(it.getTagName(), "http://schemas.android.com/apk/res/android", it.getAttrName(), it.getAttrValue());
            }
            for (DeepLink dl : deepLinkGroup) {
                this.recordXmlElementAddition(intentFilterXmlElement, dl.getSourceFilePosition(), actionRecorder2);
            }
        }
    }

    @NotNull
    public final List<DeepLink> findDeepLinks(@NotNull String navigationXmlId, @NotNull Map<String, NavigationXmlDocument> loadedNavigationMap, @NotNull MergingReport.Builder mergingReportBuilder, @NotNull SourceFilePosition sourceFilePosition) throws NavGraphException {
        Intrinsics.checkNotNullParameter((Object)navigationXmlId, (String)"navigationXmlId");
        Intrinsics.checkNotNullParameter(loadedNavigationMap, (String)"loadedNavigationMap");
        Intrinsics.checkNotNullParameter((Object)mergingReportBuilder, (String)"mergingReportBuilder");
        Intrinsics.checkNotNullParameter((Object)sourceFilePosition, (String)"sourceFilePosition");
        List deepLinkList = new ArrayList();
        NavGraphExpander.findDeepLinks$default(this, navigationXmlId, loadedNavigationMap, deepLinkList, mergingReportBuilder, sourceFilePosition, null, null, null, 224, null);
        ImmutableList immutableList = ImmutableList.copyOf((Collection)deepLinkList);
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"copyOf(...)");
        return (List)immutableList;
    }

    private final void findDeepLinks(String navigationXmlId, Map<String, NavigationXmlDocument> loadedNavigationMap, List<DeepLink> deepLinkList, MergingReport.Builder mergingReportBuilder, SourceFilePosition sourceFilePosition, Set<DeepLinkComparisonObject> deepLinkComparisonObjects, Set<String> visitedNavigationFiles, TreeSet<String> navigationFileAncestors) throws NavGraphException {
        if (!navigationFileAncestors.add(navigationXmlId)) {
            throw new NavGraphException("Illegal circular reference among navigation files when traversing navigation file references: " + CollectionsKt.joinToString$default((Iterable)navigationFileAncestors, (CharSequence)" > ", null, null, (int)0, null, null, (int)62, null) + " > " + navigationXmlId + ".");
        }
        if (!visitedNavigationFiles.add(navigationXmlId)) {
            mergingReportBuilder.addMessage(sourceFilePosition, MergingReport.Record.Severity.WARNING, "The navigation file with ID \"" + navigationXmlId + "\" is included multiple times in the navigation graph, but only deep links on the first instance will be triggered at runtime. Consider consolidating these instances into a single <include> at a higher level of your navigation graph hierarchy.");
            navigationFileAncestors.remove(navigationXmlId);
            return;
        }
        NavigationXmlDocument navigationXmlDocument = loadedNavigationMap.get(navigationXmlId);
        if (navigationXmlDocument == null) {
            throw new NavGraphException("Referenced navigation file with navigationXmlId = " + navigationXmlId + " not found");
        }
        for (DeepLink deepLink : navigationXmlDocument.getDeepLinks()) {
            for (String deepLinkUri : this.getDeepLinkUris(deepLink)) {
                DeepLinkComparisonObject deepLinkComparisonObject = new DeepLinkComparisonObject(deepLinkUri, deepLink.getAction(), deepLink.getMimeType());
                if (deepLinkComparisonObjects.contains(deepLinkComparisonObject)) {
                    StringBuilder comparisonString = new StringBuilder("uri:" + deepLinkUri);
                    if (!StringsKt.isBlank((CharSequence)deepLink.getAction())) {
                        comparisonString.append(", action:" + deepLink.getAction());
                    }
                    if (deepLink.getMimeType() != null) {
                        comparisonString.append(", mimeType:" + deepLink.getMimeType());
                    }
                    throw new NavGraphException("Multiple destinations found with a deep link containing " + comparisonString + ".");
                }
                deepLinkComparisonObjects.add(deepLinkComparisonObject);
            }
            deepLinkList.add(deepLink);
        }
        for (String otherNavigationXmlId : navigationXmlDocument.getNavigationXmlIds()) {
            this.findDeepLinks(otherNavigationXmlId, loadedNavigationMap, deepLinkList, mergingReportBuilder, sourceFilePosition, deepLinkComparisonObjects, visitedNavigationFiles, navigationFileAncestors);
        }
        navigationFileAncestors.remove(navigationXmlId);
    }

    static /* synthetic */ void findDeepLinks$default(NavGraphExpander navGraphExpander, String string, Map map, List list, MergingReport.Builder builder, SourceFilePosition sourceFilePosition, Set set, Set set2, TreeSet treeSet, int n, Object object) throws NavGraphException {
        if ((n & 0x20) != 0) {
            set = new LinkedHashSet();
        }
        if ((n & 0x40) != 0) {
            set2 = new LinkedHashSet();
        }
        if ((n & 0x80) != 0) {
            treeSet = SetsKt.sortedSetOf((Object[])new String[0]);
        }
        navGraphExpander.findDeepLinks(string, map, list, builder, sourceFilePosition, set, set2, treeSet);
    }

    private final String getDeepLinkUriBody(DeepLink deepLink, boolean includeQuery, boolean includeFragment) {
        String hostString = deepLink.getHost() == null ? "//" : "//" + deepLink.getHost();
        String portString = deepLink.getPort() == -1 ? "" : ":" + deepLink.getPort();
        String queryString = deepLink.getQuery() == null || !includeQuery ? "" : "?" + deepLink.getQuery();
        String fragmentString = deepLink.getFragment() == null || !includeFragment ? "" : "#" + deepLink.getFragment();
        return hostString + portString + deepLink.getPath() + queryString + fragmentString;
    }

    private final List<String> getDeepLinkUris(DeepLink deepLink) {
        ImmutableList.Builder builder = ImmutableList.builder();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder(...)");
        ImmutableList.Builder builder2 = builder;
        String body = this.getDeepLinkUriBody(deepLink, true, true);
        for (String scheme : deepLink.getSchemes()) {
            builder2.add((Object)(scheme + ":" + body));
        }
        ImmutableList immutableList = builder2.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"build(...)");
        return (List)immutableList;
    }

    private final void recordXmlElementAddition(XmlElement xmlElement, SourceFilePosition sourceFilePosition, ActionRecorder actionRecorder) {
        Actions.NodeRecord nodeRecord = new Actions.NodeRecord(Actions.ActionType.ADDED, sourceFilePosition, xmlElement.getId(), null, xmlElement.getOperationType());
        actionRecorder.recordNodeAction(xmlElement, nodeRecord);
        for (XmlAttribute xmlAttribute : xmlElement.getAttributes()) {
            Intrinsics.checkNotNull((Object)xmlAttribute);
            this.recordXmlAttributeAddition(xmlAttribute, sourceFilePosition, actionRecorder);
        }
        UnmodifiableIterator unmodifiableIterator = xmlElement.getMergeableElements().iterator();
        Intrinsics.checkNotNullExpressionValue((Object)unmodifiableIterator, (String)"iterator(...)");
        UnmodifiableIterator unmodifiableIterator2 = unmodifiableIterator;
        while (unmodifiableIterator2.hasNext()) {
            XmlElement childXmlElement = (XmlElement)unmodifiableIterator2.next();
            Intrinsics.checkNotNull((Object)childXmlElement);
            this.recordXmlElementAddition(childXmlElement, sourceFilePosition, actionRecorder);
        }
    }

    private final void recordXmlAttributeAddition(XmlAttribute xmlAttribute, SourceFilePosition sourceFilePosition, ActionRecorder actionRecorder) {
        Actions.AttributeRecord attributeRecord = new Actions.AttributeRecord(Actions.ActionType.ADDED, sourceFilePosition, xmlAttribute.getId(), null, null);
        actionRecorder.recordAttributeAction(xmlAttribute, attributeRecord);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0016"}, d2={"Lcom/android/manifmerger/NavGraphExpander$ChildElementData;", "", "tagName", "", "attrName", "attrValue", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getTagName", "()Ljava/lang/String;", "getAttrName", "getAttrValue", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "unnamed"})
    private static final class ChildElementData {
        @NotNull
        private final String tagName;
        @NotNull
        private final String attrName;
        @NotNull
        private final String attrValue;

        public ChildElementData(@NotNull String tagName, @NotNull String attrName, @NotNull String attrValue) {
            Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
            Intrinsics.checkNotNullParameter((Object)attrName, (String)"attrName");
            Intrinsics.checkNotNullParameter((Object)attrValue, (String)"attrValue");
            this.tagName = tagName;
            this.attrName = attrName;
            this.attrValue = attrValue;
        }

        @NotNull
        public final String getTagName() {
            return this.tagName;
        }

        @NotNull
        public final String getAttrName() {
            return this.attrName;
        }

        @NotNull
        public final String getAttrValue() {
            return this.attrValue;
        }

        @NotNull
        public final String component1() {
            return this.tagName;
        }

        @NotNull
        public final String component2() {
            return this.attrName;
        }

        @NotNull
        public final String component3() {
            return this.attrValue;
        }

        @NotNull
        public final ChildElementData copy(@NotNull String tagName, @NotNull String attrName, @NotNull String attrValue) {
            Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
            Intrinsics.checkNotNullParameter((Object)attrName, (String)"attrName");
            Intrinsics.checkNotNullParameter((Object)attrValue, (String)"attrValue");
            return new ChildElementData(tagName, attrName, attrValue);
        }

        public static /* synthetic */ ChildElementData copy$default(ChildElementData childElementData, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = childElementData.tagName;
            }
            if ((n & 2) != 0) {
                string2 = childElementData.attrName;
            }
            if ((n & 4) != 0) {
                string3 = childElementData.attrValue;
            }
            return childElementData.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "ChildElementData(tagName=" + this.tagName + ", attrName=" + this.attrName + ", attrValue=" + this.attrValue + ")";
        }

        public int hashCode() {
            int result = this.tagName.hashCode();
            result = result * 31 + this.attrName.hashCode();
            result = result * 31 + this.attrValue.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ChildElementData)) {
                return false;
            }
            ChildElementData childElementData = (ChildElementData)other;
            if (!Intrinsics.areEqual((Object)this.tagName, (Object)childElementData.tagName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.attrName, (Object)childElementData.attrName)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.attrValue, (Object)childElementData.attrValue);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\b\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\t\u001a\u00020\u0003H\u00c2\u0003J\u000b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u00c2\u0003J)\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/manifmerger/NavGraphExpander$DeepLinkComparisonObject;", "", "uri", "", "action", "mimeType", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "unnamed"})
    private static final class DeepLinkComparisonObject {
        @NotNull
        private final String uri;
        @NotNull
        private final String action;
        @Nullable
        private final String mimeType;

        public DeepLinkComparisonObject(@NotNull String uri, @NotNull String action, @Nullable String mimeType) {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            this.uri = uri;
            this.action = action;
            this.mimeType = mimeType;
        }

        private final String component1() {
            return this.uri;
        }

        private final String component2() {
            return this.action;
        }

        private final String component3() {
            return this.mimeType;
        }

        @NotNull
        public final DeepLinkComparisonObject copy(@NotNull String uri, @NotNull String action, @Nullable String mimeType) {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            return new DeepLinkComparisonObject(uri, action, mimeType);
        }

        public static /* synthetic */ DeepLinkComparisonObject copy$default(DeepLinkComparisonObject deepLinkComparisonObject, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = deepLinkComparisonObject.uri;
            }
            if ((n & 2) != 0) {
                string2 = deepLinkComparisonObject.action;
            }
            if ((n & 4) != 0) {
                string3 = deepLinkComparisonObject.mimeType;
            }
            return deepLinkComparisonObject.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "DeepLinkComparisonObject(uri=" + this.uri + ", action=" + this.action + ", mimeType=" + this.mimeType + ")";
        }

        public int hashCode() {
            int result = this.uri.hashCode();
            result = result * 31 + this.action.hashCode();
            result = result * 31 + (this.mimeType == null ? 0 : this.mimeType.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DeepLinkComparisonObject)) {
                return false;
            }
            DeepLinkComparisonObject deepLinkComparisonObject = (DeepLinkComparisonObject)other;
            if (!Intrinsics.areEqual((Object)this.uri, (Object)deepLinkComparisonObject.uri)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.action, (Object)deepLinkComparisonObject.action)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.mimeType, (Object)deepLinkComparisonObject.mimeType);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00060\u0001j\u0002`\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/manifmerger/NavGraphExpander$NavGraphException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "s", "", "<init>", "(Ljava/lang/String;)V", "unnamed"})
    public static final class NavGraphException
    extends RuntimeException {
        public NavGraphException(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            super(s);
        }
    }
}

