/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.pagealign;

import com.android.ide.common.pagealign.AlignmentProblems;
import com.android.ide.common.pagealign.PageAlignUtilsKt;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\n\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n\u001a\u0013\u0010\f\u001a\u0004\u0018\u00010\u0004*\u00020\nH\u0002\u00a2\u0006\u0002\u0010\r\u001a\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u0006*\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u000f\u001a \u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u00112\u0006\u0010\t\u001a\u00020\u0015\u001a \u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u00112\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u0006H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"ELF_64BIT", "", "ELF_LITTLE_ENDIAN", "ELF_PT_LOAD", "", "PAGE_ALIGNMENT_16K", "", "hasElfMagicNumber", "", "input", "Ljava/io/InputStream;", "readElfMinimumLoadSectionAlignment", "readShortLittleEndian", "(Ljava/io/InputStream;)Ljava/lang/Short;", "readLongLittleEndian", "(Ljava/io/InputStream;)Ljava/lang/Long;", "findElfFile16kAlignmentProblems", "", "", "", "Lcom/android/ide/common/pagealign/AlignmentProblems;", "Lorg/apache/commons/compress/archivers/zip/ZipArchiveInputStream;", "file", "Ljava/io/File;", "is16kAligned", "value", "sdk-common"})
public final class PageAlignUtilsKt {
    private static final byte ELF_64BIT = 2;
    private static final byte ELF_LITTLE_ENDIAN = 1;
    private static final short ELF_PT_LOAD = 1;
    public static final long PAGE_ALIGNMENT_16K = 16384L;

    public static final boolean hasElfMagicNumber(@NotNull InputStream input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        byte[] ident = new byte[4];
        int read2 = input.read(ident);
        if (read2 != ident.length) {
            return false;
        }
        return ident[0] == 127 && ident[1] == 69 && ident[2] == 76 && ident[3] == 70;
    }

    public static final long readElfMinimumLoadSectionAlignment(@NotNull InputStream input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        byte[] ident = new byte[2];
        int read2 = input.read(ident);
        if (read2 != ident.length) {
            return -1L;
        }
        if (ident[0] != 2) {
            return -1L;
        }
        if (ident[1] != 1) {
            return -1L;
        }
        input.skip(26L);
        Long l = PageAlignUtilsKt.readLongLittleEndian(input);
        if (l == null) {
            return -1L;
        }
        long phoff = l;
        input.skip(12L);
        Short s = PageAlignUtilsKt.readShortLittleEndian(input);
        if (s == null) {
            return -1L;
        }
        short ehsize = s;
        input.skip(2L);
        Short s2 = PageAlignUtilsKt.readShortLittleEndian(input);
        if (s2 == null) {
            return -1L;
        }
        int phnum = s2.shortValue();
        input.skip(6L);
        if (phoff < (long)ehsize) {
            return -1L;
        }
        input.skip(phoff - (long)ehsize);
        Long minAlign = null;
        int n = phnum;
        for (int j = 0; j < n; ++j) {
            int it = j;
            boolean bl = false;
            Short s3 = PageAlignUtilsKt.readShortLittleEndian(input);
            if (s3 == null) {
                return -1L;
            }
            short type = s3;
            input.skip(46L);
            Long l2 = PageAlignUtilsKt.readLongLittleEndian(input);
            if (l2 == null) {
                return -1L;
            }
            long align = l2;
            if (type != 1) continue;
            Long l3 = minAlign;
            minAlign = l3 != null ? Long.valueOf(RangesKt.coerceAtMost((long)l3, (long)align)) : Long.valueOf(align);
        }
        Long l4 = minAlign;
        return l4 != null ? l4 : -1L;
    }

    private static final Short readShortLittleEndian(InputStream $this$readShortLittleEndian) {
        byte[] bytes = new byte[2];
        int bytesRead = $this$readShortLittleEndian.read(bytes);
        if (bytesRead != 2) {
            return null;
        }
        return (short)(bytes[0] & 0xFF | (bytes[1] & 0xFF) << 8);
    }

    private static final Long readLongLittleEndian(InputStream $this$readLongLittleEndian) {
        byte[] bytes = new byte[8];
        int bytesRead = $this$readLongLittleEndian.read(bytes);
        if (bytesRead != 8) {
            return null;
        }
        return (long)bytes[0] & 0xFFL | ((long)bytes[1] & 0xFFL) << 8 | ((long)bytes[2] & 0xFFL) << 16 | ((long)bytes[3] & 0xFFL) << 24 | ((long)bytes[4] & 0xFFL) << 32 | ((long)bytes[5] & 0xFFL) << 40 | ((long)bytes[6] & 0xFFL) << 48 | ((long)bytes[7] & 0xFFL) << 56;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Map<String, Set<AlignmentProblems>> findElfFile16kAlignmentProblems(@NotNull ZipArchiveInputStream input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Map problems = new LinkedHashMap();
        ZipArchiveEntry entry = input.getNextZipEntry();
        while (entry != null) {
            try {
                long minimumLoadSectionAlignment;
                boolean currentEntryAlignedAt16kbBoundaryInZip = PageAlignUtilsKt.is16kAligned(input.getBytesRead());
                if (!PageAlignUtilsKt.hasElfMagicNumber((InputStream)input) || (minimumLoadSectionAlignment = PageAlignUtilsKt.readElfMinimumLoadSectionAlignment((InputStream)input)) == -1L) continue;
                if (!PageAlignUtilsKt.is16kAligned(minimumLoadSectionAlignment)) {
                    String string = entry.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    PageAlignUtilsKt.findElfFile16kAlignmentProblems$addProblem(problems, string, AlignmentProblems.ElfLoadSectionsNot16kAligned);
                }
                if (entry.getMethod() != 0 || currentEntryAlignedAt16kbBoundaryInZip) continue;
                String string = entry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                PageAlignUtilsKt.findElfFile16kAlignmentProblems$addProblem(problems, string, AlignmentProblems.ElfNot16kAlignedInZip);
            }
            finally {
                entry = input.getNextZipEntry();
            }
        }
        return problems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Map<String, Set<AlignmentProblems>> findElfFile16kAlignmentProblems(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Closeable closeable = new FileInputStream(file);
        Throwable throwable = null;
        try {
            Map<String, Set<AlignmentProblems>> map;
            FileInputStream input = (FileInputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = (Closeable)new ZipArchiveInputStream((InputStream)input);
            Throwable throwable2 = null;
            try {
                ZipArchiveInputStream zipInput = (ZipArchiveInputStream)closeable2;
                boolean bl2 = false;
                map = PageAlignUtilsKt.findElfFile16kAlignmentProblems(zipInput);
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        CloseableKt.closeFinally((Closeable)closeable2, throwable2);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            Map<String, Set<AlignmentProblems>> map2 = map;
            return map2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private static final boolean is16kAligned(long value) {
        return value % 16384L == 0L;
    }

    private static final void findElfFile16kAlignmentProblems$addProblem(Map<String, Set<AlignmentProblems>> problems, String name, AlignmentProblems problem) {
        Function1 function1 = findElfFile16kAlignmentProblems.addProblem.1.INSTANCE;
        problems.computeIfAbsent(name, new Function(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ Object apply(Object p0) {
                return this.function.invoke(p0);
            }
        }).add(problem);
    }
}

