/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.AdbHelper;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.InstallCreateReceiver;
import com.android.ddmlib.InstallException;
import com.android.ddmlib.InstallReceiver;
import com.android.ddmlib.Log;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.sdklib.AndroidVersion;
import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public abstract class SplitApkInstallerBase {
    private static final String LOG_TAG = "SplitApkInstallerBase";
    private static boolean abbExecAllowed = true;
    protected final IDevice mDevice;
    private final String mOptions;
    private final String mPrefix;
    private final AdbHelper.AdbService mService;
    private final AdbHelper.AdbService mServiceWrite;
    private static final CharMatcher UNSAFE_SHELL_SPLIT_NAME_CHARS = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.inRange((char)'0', (char)'9')).or(CharMatcher.anyOf((CharSequence)"_-.")).negate();

    protected SplitApkInstallerBase(IDevice device, String options) {
        this.mDevice = device;
        this.mOptions = options;
        if (this.mDevice.supportsFeature(IDevice.Feature.ABB_EXEC) && abbExecAllowed) {
            this.mPrefix = "package";
            this.mService = AdbHelper.AdbService.ABB_EXEC;
            this.mServiceWrite = AdbHelper.AdbService.ABB_EXEC;
        } else if (SplitApkInstallerBase.supportsCmd(device)) {
            this.mPrefix = "cmd package";
            this.mService = AdbHelper.AdbService.SHELL;
            this.mServiceWrite = AdbHelper.AdbService.EXEC;
        } else {
            this.mPrefix = "pm";
            this.mService = AdbHelper.AdbService.SHELL;
            this.mServiceWrite = AdbHelper.AdbService.EXEC;
        }
        Log.i(LOG_TAG, String.format("Install-Write Strategy '%s' over '%s'", this.mPrefix, this.mServiceWrite.name()));
    }

    private static boolean supportsCmd(IDevice device) {
        return device.getVersion().isGreaterOrEqualThan(AndroidVersion.BINDER_CMD_AVAILABLE.getApiLevel());
    }

    static void setAbbExecAllowed(boolean allowed) {
        abbExecAllowed = allowed;
    }

    protected String createMultiInstallSession(String options, long timeout, TimeUnit unit) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException, InstallException {
        InstallCreateReceiver receiver = new InstallCreateReceiver();
        String cmd = this.mPrefix + " install-create";
        if (!options.trim().isEmpty()) {
            cmd = cmd + " " + options;
        }
        this.mDevice.executeRemoteCommand(this.mService, cmd, receiver, 0L, timeout, unit, null);
        String sessionId = receiver.getSessionId();
        if (sessionId == null) {
            String message = String.format("'%s'", cmd);
            message = receiver.getErrorMessage() != null ? String.format("%s returns error '%s'", message, receiver.getErrorMessage()) : (receiver.getSuccessMessage() != null ? String.format("%s returns '%s' without session ID", message, receiver.getSuccessMessage()) : String.format("Failed to create install session with %s", message));
            Log.e(LOG_TAG, message);
            throw new InstallException(message);
        }
        Log.i(LOG_TAG, String.format("Created install session %s with options %s", sessionId, options));
        return sessionId;
    }

    static String sanitizeApkFilename(String filename) {
        return UNSAFE_SHELL_SPLIT_NAME_CHARS.replaceFrom((CharSequence)filename, '_');
    }

    protected void installCommit(String sessionId, long timeout, TimeUnit unit) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException, InstallException {
        String command = this.mPrefix + " install-commit " + sessionId;
        InstallReceiver receiver = new InstallReceiver();
        this.mDevice.executeRemoteCommand(this.mService, command, receiver, 0L, timeout, unit, null);
        if (!receiver.isSuccessfullyCompleted()) {
            Object message = String.format("Failed to commit install session %s with command %s.", sessionId, command);
            if (receiver.getErrorMessage() != null) {
                message = (String)message + String.format(" Error: %s", receiver.getErrorMessage());
            }
            Log.e(LOG_TAG, (String)message);
            throw new InstallException((String)message, receiver.getErrorCode());
        }
    }

    protected void installAbandon(String sessionId, long timeout, TimeUnit unit) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException, InstallException {
        String command = this.mPrefix + " install-abandon " + sessionId;
        InstallReceiver receiver = new InstallReceiver();
        this.mDevice.executeRemoteCommand(this.mService, command, receiver, 0L, timeout, unit, null);
        if (!receiver.isSuccessfullyCompleted()) {
            Log.e(LOG_TAG, String.format("Failed to abandon install session %s", sessionId));
        }
    }

    protected IDevice getDevice() {
        return this.mDevice;
    }

    protected String getPrefix() {
        return this.mPrefix;
    }

    protected String getOptions() {
        return this.mOptions;
    }

    protected AdbHelper.AdbService getService() {
        return this.mService;
    }

    protected AdbHelper.AdbService getServiceWrite() {
        return this.mServiceWrite;
    }

    protected static String getOptions(boolean reInstall, List<String> installOptions) {
        return SplitApkInstallerBase.getOptions(reInstall, false, null, installOptions);
    }

    protected static String getOptions(boolean reInstall, boolean partialInstall, String applicationId, List<String> installOptions) {
        StringBuilder sb = new StringBuilder();
        if (reInstall) {
            sb.append("-r");
        }
        if (partialInstall) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            if (applicationId == null) {
                throw new IllegalArgumentException("Cannot do a partial install without knowing the application id");
            }
            sb.append("-p ");
            sb.append(applicationId);
        }
        if (!installOptions.isEmpty()) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(Joiner.on((String)" ").join(installOptions));
        }
        return sb.toString();
    }

    protected static void validateApiLevel(IDevice device) {
        int apiWithSplitApk = AndroidVersion.ALLOW_SPLIT_APK_INSTALLATION.getApiLevel();
        if (!device.getVersion().isGreaterOrEqualThan(apiWithSplitApk)) {
            throw new IllegalArgumentException(String.format("Device %s API level=%d. Cannot install split APKs with API level < %d", device.getSerialNumber(), device.getVersion().getApiLevel(), apiWithSplitApk));
        }
    }
}

