/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.ClassLoaderConfiguratorKt;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.ModuleDependenciesDescriptor;
import com.intellij.ide.plugins.ModuleGraph;
import com.intellij.ide.plugins.ModuleGraphKt;
import com.intellij.ide.plugins.ModuleLoadingRule;
import com.intellij.ide.plugins.PluginContentDescriptor;
import com.intellij.ide.plugins.PluginLoadingError;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginSet;
import com.intellij.ide.plugins.PluginSetBuilderKt;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.util.Java11Shim;
import com.intellij.util.graph.DFSTBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0017\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007\u00a2\u0006\u0004\b\u0005\u0010\bJ!\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00170\u0016H\u0000\u00a2\u0006\u0002\b\u0018J\u0013\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u001aH\u0002\u00a2\u0006\u0002\u0010\u001bJ+\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0016\b\u0002\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020!\u0018\u00010 H\u0000\u00a2\u0006\u0002\b\"J\u0018\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u0004H\u0002J\u0006\u0010&\u001a\u00020'J\u001b\u0010(\u001a\u00020'2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007H\u0000\u00a2\u0006\u0002\b*JM\u0010+\u001a\u0004\u0018\u00010\u001e2\u0006\u0010,\u001a\u00020\u00042\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00040.2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00100\u00032\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u001e00H\u0000\u00a2\u0006\u0002\b1R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00040\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00040\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/intellij/ide/plugins/PluginSetBuilder;", "", "unsortedPlugins", "", "Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "<init>", "(Ljava/util/Set;)V", "", "(Ljava/util/Collection;)V", "_moduleGraph", "Lcom/intellij/ide/plugins/ModuleGraph;", "builder", "Lcom/intellij/util/graph/DFSTBuilder;", "moduleGraph", "enabledPluginIds", "Ljava/util/HashMap;", "Lcom/intellij/openapi/extensions/PluginId;", "enabledModuleV2Ids", "", "checkPluginCycles", "", "errors", "", "Ljava/util/function/Supplier;", "checkPluginCycles$intellij_platform_core_impl", "getSortedPlugins", "", "()[Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "computeEnabledModuleMap", "", "Lcom/intellij/ide/plugins/PluginLoadingError;", "disabler", "Lkotlin/Function1;", "", "computeEnabledModuleMap$intellij_platform_core_impl", "markModuleAsEnabled", "moduleName", "moduleDescriptor", "createPluginSetWithEnabledModulesMap", "Lcom/intellij/ide/plugins/PluginSet;", "createPluginSet", "incompletePlugins", "createPluginSet$intellij_platform_core_impl", "initEnableState", "descriptor", "idMap", "", "disabledPlugins", "", "initEnableState$intellij_platform_core_impl", "intellij.platform.core.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nPluginSetBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginSetBuilder.kt\ncom/intellij/ide/plugins/PluginSetBuilder\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,303:1\n1317#2:304\n1317#2,2:305\n1318#2:307\n183#2,2:312\n183#2,2:314\n37#3,2:308\n4344#4,2:310\n*S KotlinDebug\n*F\n+ 1 PluginSetBuilder.kt\ncom/intellij/ide/plugins/PluginSetBuilder\n*L\n50#1:304\n56#1:305,2\n50#1:307\n225#1:312,2\n233#1:314,2\n75#1:308,2\n189#1:310,2\n*E\n"})
public final class PluginSetBuilder {
    @JvmField
    @NotNull
    public final Set<IdeaPluginDescriptorImpl> unsortedPlugins;
    @NotNull
    private final ModuleGraph _moduleGraph;
    @NotNull
    private final DFSTBuilder<IdeaPluginDescriptorImpl> builder;
    @JvmField
    @NotNull
    public final ModuleGraph moduleGraph;
    @NotNull
    private final HashMap<PluginId, IdeaPluginDescriptorImpl> enabledPluginIds;
    @NotNull
    private final HashMap<String, IdeaPluginDescriptorImpl> enabledModuleV2Ids;

    public PluginSetBuilder(@NotNull Set<IdeaPluginDescriptorImpl> unsortedPlugins) {
        Intrinsics.checkNotNullParameter(unsortedPlugins, (String)"unsortedPlugins");
        this.unsortedPlugins = unsortedPlugins;
        this._moduleGraph = ModuleGraphKt.createModuleGraph((Collection<IdeaPluginDescriptorImpl>)this.unsortedPlugins);
        this.builder = this._moduleGraph.builder();
        this.moduleGraph = this._moduleGraph.sorted$intellij_platform_core_impl(this.builder);
        this.enabledPluginIds = new HashMap(this.unsortedPlugins.size());
        this.enabledModuleV2Ids = new HashMap(this.unsortedPlugins.size() * 2);
    }

    public PluginSetBuilder(@NotNull Collection<IdeaPluginDescriptorImpl> unsortedPlugins) {
        Intrinsics.checkNotNullParameter(unsortedPlugins, (String)"unsortedPlugins");
        this((Set<IdeaPluginDescriptorImpl>)new LinkedHashSet<IdeaPluginDescriptorImpl>(unsortedPlugins));
    }

    /*
     * WARNING - void declaration
     */
    public final void checkPluginCycles$intellij_platform_core_impl(@NotNull List<Supplier<String>> errors) {
        Intrinsics.checkNotNullParameter(errors, (String)"errors");
        if (this.builder.isAcyclic()) {
            return;
        }
        for (Collection<IdeaPluginDescriptorImpl> component : this.builder.getComponents()) {
            void $this$forEach$iv;
            if (component.size() < 2) continue;
            for (IdeaPluginDescriptorImpl ideaPluginDescriptorImpl : component) {
                ideaPluginDescriptorImpl.setEnabled(false);
            }
            Intrinsics.checkNotNull(component);
            String pluginString = CollectionsKt.joinToString$default((Iterable)component, (CharSequence)", ", null, null, (int)0, null, PluginSetBuilder::checkPluginCycles$lambda$0, (int)30, null);
            Object[] objectArray = new Object[]{pluginString};
            errors.add(PluginSetBuilderKt.access$message("plugin.loading.error.plugins.cannot.be.loaded.because.they.form.a.dependency.cycle", objectArray));
            StringBuilder stringBuilder = new StringBuilder();
            Function1 pluginToString = PluginSetBuilder::checkPluginCycles$lambda$1;
            stringBuilder.append("Detected plugin dependencies cycle details (only related dependencies are included):\n");
            Sequence sequence = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)component), arg_0 -> PluginSetBuilder.checkPluginCycles$lambda$2(pluginToString, arg_0));
            Comparator<Object> comparator = Comparator.comparing(arg_0 -> PluginSetBuilder.checkPluginCycles$lambda$4(PluginSetBuilder::checkPluginCycles$lambda$3, arg_0), StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
            Intrinsics.checkNotNullExpressionValue(comparator, (String)"comparing(...)");
            Sequence sequence2 = SequencesKt.sortedWith((Sequence)sequence, comparator);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$forEach$iv2;
                Pair it = (Pair)element$iv;
                boolean bl = false;
                stringBuilder.append("  ").append((String)it.getSecond()).append(" depends on:\n");
                Object object = it.getFirst();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-first>(...)");
                Sequence sequence3 = SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.moduleGraph.getDependencies((IdeaPluginDescriptorImpl)object)), arg_0 -> PluginSetBuilder.checkPluginCycles$lambda$7$lambda$5(component, arg_0)), (Function1)pluginToString);
                Comparator comparator2 = String.CASE_INSENSITIVE_ORDER;
                Intrinsics.checkNotNullExpressionValue((Object)comparator2, (String)"CASE_INSENSITIVE_ORDER");
                Sequence sequence4 = SequencesKt.sortedWith((Sequence)sequence3, (Comparator)comparator2);
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    String dep = (String)element$iv2;
                    boolean bl2 = false;
                    stringBuilder.append("    ").append(dep).append("\n");
                }
            }
            PluginManagerCore.getLogger().info(stringBuilder.toString());
        }
    }

    private final IdeaPluginDescriptorImpl[] getSortedPlugins() {
        Object2IntOpenHashMap<PluginId> pluginToNumber = new Object2IntOpenHashMap<PluginId>(this.unsortedPlugins.size());
        pluginToNumber.put(PluginManagerCore.CORE_ID, 0);
        int number = 0;
        for (IdeaPluginDescriptorImpl module : this.moduleGraph.getNodes()) {
            if (module.descriptorPath == null && !module.content.modules.isEmpty()) continue;
            pluginToNumber.putIfAbsent(module.getPluginId(), number++);
        }
        Collection $this$toTypedArray$iv = this.unsortedPlugins;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        IdeaPluginDescriptorImpl[] sorted = thisCollection$iv.toArray(new IdeaPluginDescriptorImpl[0]);
        Arrays.sort(sorted, (arg_0, arg_1) -> PluginSetBuilder.getSortedPlugins$lambda$8(pluginToNumber, arg_0, arg_1));
        return sorted;
    }

    @NotNull
    public final List<PluginLoadingError> computeEnabledModuleMap$intellij_platform_core_impl(@Nullable Function1<? super IdeaPluginDescriptorImpl, Boolean> disabler) {
        ArrayList<String> logMessages = new ArrayList<String>();
        ArrayList<PluginLoadingError> loadingErrors = new ArrayList<PluginLoadingError>();
        HashMap<String, IdeaPluginDescriptorImpl> enabledRequiredContentModules = new HashMap<String, IdeaPluginDescriptorImpl>();
        HashMap<String, PluginId> disabledModuleToProblematicPlugin = new HashMap<String, PluginId>();
        block0: for (IdeaPluginDescriptorImpl module : this.moduleGraph.getNodes()) {
            if (module.isUseIdeaClassLoader && !ClassLoaderConfiguratorKt.getCanExtendIdeaClassLoader()) {
                module.setEnabled(false);
                String string = module.moduleName;
                logMessages.add("Module " + (string != null ? (Comparable)((Object)string) : (Comparable)module.getPluginId()) + " is not enabled because it uses deprecated `use-idea-classloader` attribute but PathClassLoader is disabled");
                continue;
            }
            if (module.moduleName == null) {
                if (!Intrinsics.areEqual((Object)module.getPluginId(), (Object)PluginManagerCore.CORE_ID) && (!module.isEnabled() || disabler != null && ((Boolean)disabler.invoke((Object)module)).booleanValue())) {
                    continue;
                }
            } else if (module.moduleLoadingRule != ModuleLoadingRule.REQUIRED && !this.enabledPluginIds.containsKey(module.getPluginId())) {
                disabledModuleToProblematicPlugin.put(module.moduleName, module.getPluginId());
                continue;
            }
            for (ModuleDependenciesDescriptor.ModuleReference moduleReference : module.dependencies.modules) {
                if (this.enabledModuleV2Ids.containsKey(moduleReference.name)) continue;
                String string = module.moduleName;
                logMessages.add("Module " + (string != null ? (Comparable)((Object)string) : (Comparable)module.getPluginId()) + " is not enabled because dependency " + moduleReference.name + " is not available");
                if (module.moduleName == null) continue block0;
                String string2 = module.moduleName;
                PluginId pluginId = (PluginId)disabledModuleToProblematicPlugin.get(moduleReference.name);
                if (pluginId == null) {
                    PluginId pluginId2 = PluginId.getId(moduleReference.name);
                    pluginId = pluginId2;
                    Intrinsics.checkNotNullExpressionValue((Object)pluginId2, (String)"getId(...)");
                }
                disabledModuleToProblematicPlugin.put(string2, pluginId);
                continue block0;
            }
            for (ModuleDependenciesDescriptor.PluginReference pluginReference : module.dependencies.plugins) {
                if (this.enabledPluginIds.containsKey(pluginReference.id)) continue;
                String string = module.moduleName;
                logMessages.add("Module " + (string != null ? (Comparable)((Object)string) : (Comparable)module.getPluginId()) + " is not enabled because dependency " + pluginReference.id + " is not available");
                if (module.moduleName == null) continue block0;
                disabledModuleToProblematicPlugin.put(module.moduleName, pluginReference.id);
                continue block0;
            }
            if (module.moduleName == null) {
                for (PluginContentDescriptor.ModuleItem moduleItem : module.content.modules) {
                    if (moduleItem.loadingRule != ModuleLoadingRule.REQUIRED || enabledRequiredContentModules.containsKey(moduleItem.name)) continue;
                    module.setEnabled(false);
                    PluginId pluginId = (PluginId)disabledModuleToProblematicPlugin.get(moduleItem.name);
                    if (pluginId == null) {
                        PluginId pluginId3 = PluginId.getId(moduleItem.name);
                        pluginId = pluginId3;
                        Intrinsics.checkNotNullExpressionValue((Object)pluginId3, (String)"getId(...)");
                    }
                    loadingErrors.add(PluginSetBuilderKt.access$createCannotLoadError(module, pluginId, MapsKt.emptyMap(), !module.isImplementationDetail()));
                    continue block0;
                }
                this.enabledPluginIds.put(module.getPluginId(), module);
                for (PluginId pluginId : module.pluginAliases) {
                    this.enabledPluginIds.put(pluginId, module);
                }
                if (module.packagePrefix != null) {
                    this.enabledModuleV2Ids.put(module.getPluginId().getIdString(), module);
                }
                for (PluginContentDescriptor.ModuleItem moduleItem : module.content.modules) {
                    if (moduleItem.loadingRule != ModuleLoadingRule.REQUIRED) continue;
                    Object v = enabledRequiredContentModules.remove(moduleItem.name);
                    Intrinsics.checkNotNull(v);
                    IdeaPluginDescriptorImpl requiredContentModule = (IdeaPluginDescriptorImpl)v;
                    this.markModuleAsEnabled(moduleItem.name, requiredContentModule);
                }
                continue;
            }
            if (module.moduleLoadingRule == ModuleLoadingRule.REQUIRED) {
                enabledRequiredContentModules.put(module.moduleName, module);
                continue;
            }
            this.markModuleAsEnabled(module.moduleName, module);
        }
        if (!logMessages.isEmpty()) {
            PluginManagerCore.getLogger().info(CollectionsKt.joinToString$default((Iterable)logMessages, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        }
        return loadingErrors;
    }

    public static /* synthetic */ List computeEnabledModuleMap$intellij_platform_core_impl$default(PluginSetBuilder pluginSetBuilder, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = null;
        }
        return pluginSetBuilder.computeEnabledModuleMap$intellij_platform_core_impl((Function1<? super IdeaPluginDescriptorImpl, Boolean>)function1);
    }

    private final void markModuleAsEnabled(String moduleName, IdeaPluginDescriptorImpl moduleDescriptor) {
        this.enabledModuleV2Ids.put(moduleName, moduleDescriptor);
        for (PluginId pluginAlias : moduleDescriptor.pluginAliases) {
            this.enabledPluginIds.put(pluginAlias, moduleDescriptor);
        }
    }

    @NotNull
    public final PluginSet createPluginSetWithEnabledModulesMap() {
        PluginSetBuilder.computeEnabledModuleMap$intellij_platform_core_impl$default(this, null, 1, null);
        return this.createPluginSet$intellij_platform_core_impl(CollectionsKt.emptyList());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PluginSet createPluginSet$intellij_platform_core_impl(@NotNull Collection<IdeaPluginDescriptorImpl> incompletePlugins) {
        ArrayList arrayList;
        ArrayList destination$iv;
        void $this$filterTo$iv;
        Object[] objectArray;
        Intrinsics.checkNotNullParameter(incompletePlugins, (String)"incompletePlugins");
        Object[] sortedPlugins = this.getSortedPlugins();
        Object[] result2 = objectArray = new LinkedHashSet();
        boolean $i$a$-also-PluginSetBuilder$createPluginSet$allPlugins$22 = false;
        CollectionsKt.addAll((Collection)((Collection)result2), (Object[])sortedPlugins);
        result2.addAll(incompletePlugins);
        Object[] allPlugins = objectArray;
        Java11Shim java11Shim = Java11Shim.INSTANCE;
        result2 = sortedPlugins;
        Collection $i$a$-also-PluginSetBuilder$createPluginSet$allPlugins$22 = new ArrayList();
        Set set = (Set)allPlugins;
        ModuleGraph moduleGraph = this.moduleGraph;
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv;
            void it = element$iv = $this$filterTo$iv[i];
            boolean bl = false;
            if (!it.isEnabled()) continue;
            destination$iv.add(element$iv);
        }
        List list = destination$iv;
        destination$iv = arrayList = new ArrayList();
        Map<PluginId, IdeaPluginDescriptorImpl> map2 = java11Shim.copyOf((Map)this.enabledPluginIds);
        Map<String, IdeaPluginDescriptorImpl> map3 = java11Shim.copyOf((Map)this.enabledModuleV2Ids);
        list = list;
        boolean bl = false;
        for (IdeaPluginDescriptorImpl module : this.moduleGraph.getNodes()) {
            void result3;
            if (!(module.moduleName == null ? module.isEnabled() : this.enabledModuleV2Ids.containsKey(module.moduleName))) continue;
            result3.add(module);
        }
        Unit unit = Unit.INSTANCE;
        List list2 = arrayList;
        Map<PluginId, IdeaPluginDescriptorImpl> map4 = map2;
        Map<String, IdeaPluginDescriptorImpl> map5 = map3;
        List list3 = list;
        Set set2 = set;
        ModuleGraph moduleGraph2 = moduleGraph;
        return new PluginSet(moduleGraph2, set2, list3, map5, map4, list2);
    }

    @Nullable
    public final PluginLoadingError initEnableState$intellij_platform_core_impl(@NotNull IdeaPluginDescriptorImpl descriptor2, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idMap, @NotNull Set<PluginId> disabledPlugins, @NotNull Map<PluginId, PluginLoadingError> errors) {
        PluginLoadingError pluginLoadingError;
        Object v5;
        Object object;
        boolean isNotifyUser;
        block9: {
            boolean bl;
            Object it;
            boolean $i$f$firstOrNull;
            block10: {
                Object object2;
                block12: {
                    Object dependencyPluginId;
                    block11: {
                        Object v2;
                        block8: {
                            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                            Intrinsics.checkNotNullParameter(idMap, (String)"idMap");
                            Intrinsics.checkNotNullParameter(disabledPlugins, (String)"disabledPlugins");
                            Intrinsics.checkNotNullParameter(errors, (String)"errors");
                            isNotifyUser = !descriptor2.isImplementationDetail();
                            for (PluginId pluginId : descriptor2.incompatibilities) {
                                if (!this.enabledPluginIds.containsKey(pluginId) || disabledPlugins.contains(pluginId)) continue;
                                String string = pluginId.getIdString();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIdString(...)");
                                String presentableName = string;
                                Object[] objectArray = new Object[]{descriptor2.getName(), presentableName};
                                Supplier supplier = PluginSetBuilderKt.access$message("plugin.loading.error.long.ide.contains.conflicting.module", objectArray);
                                objectArray = new Object[]{presentableName};
                                return new PluginLoadingError(descriptor2, supplier, PluginSetBuilderKt.access$message("plugin.loading.error.short.ide.contains.conflicting.module", objectArray), isNotifyUser, null, 16, null);
                            }
                            Sequence sequence = PluginSetBuilderKt.access$getAllPluginDependencies(descriptor2);
                            $i$f$firstOrNull = false;
                            for (Object element$iv : sequence) {
                                it = (PluginId)element$iv;
                                bl = false;
                                if (!(!((Map)this.enabledPluginIds).containsKey(it))) continue;
                                v2 = element$iv;
                                break block8;
                            }
                            v2 = null;
                        }
                        object = v2;
                        if (object == null) break block10;
                        dependencyPluginId = object;
                        boolean bl2 = false;
                        object2 = idMap.get(dependencyPluginId);
                        if (object2 == null) break block11;
                        IdeaPluginDescriptorImpl it2 = object2;
                        boolean bl22 = false;
                        PluginLoadingError pluginLoadingError2 = PluginSetBuilderKt.access$createTransitivelyDisabledError(descriptor2, it2, isNotifyUser);
                        object2 = pluginLoadingError2;
                        if (pluginLoadingError2 != null) break block12;
                    }
                    object2 = PluginSetBuilderKt.access$createCannotLoadError(descriptor2, (PluginId)dependencyPluginId, errors, isNotifyUser);
                }
                return object2;
            }
            Sequence sequence = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)descriptor2.dependencies.modules), PluginSetBuilder::initEnableState$lambda$15);
            $i$f$firstOrNull = false;
            for (Object element$iv : sequence) {
                it = (String)element$iv;
                bl = false;
                if (!(!((Map)this.enabledModuleV2Ids).containsKey(it))) continue;
                v5 = element$iv;
                break block9;
            }
            v5 = null;
        }
        object = v5;
        if (object != null) {
            Object it = object;
            boolean bl = false;
            Object[] objectArray = new Object[]{descriptor2.getName(), it};
            Supplier supplier = PluginSetBuilderKt.access$message("plugin.loading.error.long.depends.on.not.installed.plugin", objectArray);
            objectArray = new Object[]{it};
            PluginLoadingError pluginLoadingError3 = new PluginLoadingError(descriptor2, supplier, PluginSetBuilderKt.access$message("plugin.loading.error.short.depends.on.not.installed.plugin", objectArray), isNotifyUser, null, 16, null);
            pluginLoadingError = pluginLoadingError3;
        } else {
            pluginLoadingError = null;
        }
        return pluginLoadingError;
    }

    private static final CharSequence checkPluginCycles$lambda$0(IdeaPluginDescriptorImpl it) {
        return '\'' + it.getName() + '\'';
    }

    private static final String checkPluginCycles$lambda$1(IdeaPluginDescriptorImpl it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "id = " + it.getPluginId().getIdString() + " (" + it.getName() + ')';
    }

    private static final Pair checkPluginCycles$lambda$2(Function1 $pluginToString, IdeaPluginDescriptorImpl it) {
        Intrinsics.checkNotNull((Object)it);
        return new Pair((Object)it, $pluginToString.invoke((Object)it));
    }

    private static final String checkPluginCycles$lambda$3(Pair it) {
        return (String)it.getSecond();
    }

    private static final String checkPluginCycles$lambda$4(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final boolean checkPluginCycles$lambda$7$lambda$5(Collection $component, IdeaPluginDescriptorImpl o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        return $component.contains(o);
    }

    private static final int getSortedPlugins$lambda$8(Object2IntOpenHashMap $pluginToNumber, IdeaPluginDescriptorImpl o1, IdeaPluginDescriptorImpl o2) {
        return $pluginToNumber.getInt(o1.getPluginId()) - $pluginToNumber.getInt(o2.getPluginId());
    }

    private static final String initEnableState$lambda$15(ModuleDependenciesDescriptor.ModuleReference it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.name;
    }
}

