/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.AndroidXConstants;
import com.android.tools.lint.checks.MotionLayoutIdDetectorKt;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.SdkInfo;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.DomExtensions;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/lint/checks/MotionLayoutIdDetector;", "Lcom/android/tools/lint/detector/api/LayoutDetector;", "<init>", "()V", "getApplicableElements", "", "", "kotlin.jvm.PlatformType", "visitElement", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "Companion", "lint-checks"})
public final class MotionLayoutIdDetector
extends LayoutDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final Issue MISSING_ID;

    @NotNull
    public List<String> getApplicableElements() {
        Object[] objectArray = new String[]{AndroidXConstants.MOTION_LAYOUT.oldName(), AndroidXConstants.MOTION_LAYOUT.newName()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        JavaEvaluator evaluator = context.getClient().getUastParser(context.getProject()).getEvaluator();
        SdkInfo sdkInfo = context.getSdkInfo();
        Iterator iterator = DomExtensions.iterator((Element)element);
        while (iterator.hasNext()) {
            Element child = (Element)iterator.next();
            String elementTagName = child.getTagName();
            if (Intrinsics.areEqual((Object)"include", (Object)elementTagName) || Intrinsics.areEqual((Object)"merge", (Object)elementTagName)) continue;
            Intrinsics.checkNotNull((Object)elementTagName);
            if (Lint.isLayoutMarkerTag((String)elementTagName) || !MotionLayoutIdDetectorKt.access$isView(elementTagName, evaluator, sdkInfo) || child.hasAttributeNS("http://schemas.android.com/apk/res/android", "id")) continue;
            String string = context.document.lookupPrefix("http://schemas.android.com/apk/res/android");
            if (string == null) {
                string = "android";
            }
            String prefix = string;
            context.report(MISSING_ID, (Node)child, context.getNameLocation((Node)child), "Views inside `MotionLayout` require an `" + prefix + ":id` attribute", LintFix.SetAttributeBuilder.todo$default((LintFix.SetAttributeBuilder)this.fix().set(), (String)"http://schemas.android.com/apk/res/android", (String)"id", (String)"@+id/", null, (int)8, null).build());
        }
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        Implementation implementation = new Implementation(MotionLayoutIdDetector.class, Scope.RESOURCE_FILE_SCOPE);
        MISSING_ID = Issue.Companion.create$default((Issue.Companion)companion, (String)"MotionLayoutMissingId", (String)"Views inside `MotionLayout` require an `android:id`", (String)"Views inside `MotionLayout` require an `android:id`.", (Implementation)implementation, null, (Category)category, (int)8, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/lint/checks/MotionLayoutIdDetector$Companion;", "", "<init>", "()V", "MISSING_ID", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

