/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.ProviderPermissionDetector;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.LocationType;
import com.android.tools.lint.detector.api.PartialResult;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtilsKt;
import com.android.utils.DomExtensions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.UThrowExpression;
import org.jetbrains.uast.UastUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 !2\u00020\u00012\u00020\u0002:\u0001!B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\f\u0010\u0018\u001a\u00020\u0019*\u00020\u001aH\u0002J\u000e\u0010\u001b\u001a\u00020\u0019*\u0004\u0018\u00010\u001cH\u0002J\u000e\u0010\u001d\u001a\u00020\u0019*\u0004\u0018\u00010\u001cH\u0002J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001c*\u0004\u0018\u00010\u001cH\u0002J\u000e\u0010\u001f\u001a\u00020\u0019*\u0004\u0018\u00010\u001cH\u0002J\f\u0010 \u001a\u00020\u0019*\u00020\u001aH\u0002\u00a8\u0006\""}, d2={"Lcom/android/tools/lint/checks/ProviderPermissionDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "applicableSuperClasses", "", "", "visitClass", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "declaration", "Lorg/jetbrains/uast/UClass;", "afterCheckRootProject", "Lcom/android/tools/lint/detector/api/Context;", "checkPartialResults", "partialResults", "Lcom/android/tools/lint/detector/api/PartialResult;", "reportIfProviderReadPermissionOnlyOccurs", "provider", "Lorg/w3c/dom/Element;", "providersMap", "Lcom/android/tools/lint/detector/api/LintMap;", "isImplemented", "", "Lorg/jetbrains/uast/UMethod;", "isThrowExpression", "Lorg/jetbrains/uast/UExpression;", "isReturnLiteral", "getInsideReturnOrThis", "isNeverReturningCall", "isProviderAbstractWriteMethod", "Companion", "lint-checks"})
@SourceDebugExtension(value={"SMAP\nProviderPermissionDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProviderPermissionDetector.kt\ncom/android/tools/lint/checks/ProviderPermissionDetector\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,230:1\n3829#2:231\n4344#2,2:232\n1863#3,2:234\n*S KotlinDebug\n*F\n+ 1 ProviderPermissionDetector.kt\ncom/android/tools/lint/checks/ProviderPermissionDetector\n*L\n70#1:231\n70#1:232,2\n101#1:234,2\n*E\n"})
public final class ProviderPermissionDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final Issue PROVIDER_READ_PERMISSION_ONLY;
    @NotNull
    public static final String KEY_LOCATION = "location";
    @NotNull
    public static final String KEY_IMPL_WRITE_METHODS = "implementedWriteMethods";

    @NotNull
    public List<String> applicableSuperClasses() {
        return CollectionsKt.listOf((Object)"android.content.ContentProvider");
    }

    /*
     * WARNING - void declaration
     */
    public void visitClass(@NotNull JavaContext context, @NotNull UClass declaration) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        String string = declaration.getQualifiedName();
        if (string == null) {
            return;
        }
        String providerName = string;
        UMethod[] $this$filter$iv = declaration.getMethods();
        boolean $i$f$filter = false;
        UMethod[] uMethodArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            if (!(this.isProviderAbstractWriteMethod((UMethod)it) && this.isImplemented((UMethod)it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List implWriteMethods = (List)destination$iv$iv;
        if (implWriteMethods.isEmpty()) {
            return;
        }
        String implementedWriteMethodNames2 = CollectionsKt.joinToString$default((Iterable)implWriteMethods, (CharSequence)", ", (CharSequence)"{", (CharSequence)"}", (int)0, null, (Function1)visitClass.implementedWriteMethodNames.1.INSTANCE, (int)24, null);
        LintMap providerMap = new LintMap();
        providerMap.put(KEY_LOCATION, context.getNameLocation(declaration));
        providerMap.put(KEY_IMPL_WRITE_METHODS, implementedWriteMethodNames2);
        context.getPartialResults(PROVIDER_READ_PERMISSION_ONLY).map().put(providerName, providerMap);
    }

    public void afterCheckRootProject(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.isGlobalAnalysis()) {
            this.checkPartialResults(context, context.getPartialResults(PROVIDER_READ_PERMISSION_ONLY));
        }
    }

    public void checkPartialResults(@NotNull Context context, @NotNull PartialResult partialResults) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)partialResults, (String)"partialResults");
        if (!context.getDriver().isIsolated() && context.getProject().isLibrary()) {
            return;
        }
        Document document = context.getMainProject().getMergedManifest();
        if (document == null) {
            return;
        }
        Document mergedManifest = document;
        Element element = mergedManifest.getDocumentElement();
        if (element == null) {
            return;
        }
        Element root = element;
        Element element2 = DomExtensions.subtag((Element)root, (String)"application");
        if (element2 == null) {
            return;
        }
        Element application = element2;
        Element provider = DomExtensions.subtag((Element)application, (String)"provider");
        LintMap combinedMap = new LintMap();
        Iterable $this$forEach$iv = partialResults.maps();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LintMap it = (LintMap)element$iv;
            boolean bl = false;
            combinedMap.putAll(it);
        }
        while (provider != null) {
            this.reportIfProviderReadPermissionOnlyOccurs(context, provider, combinedMap);
            provider = DomExtensions.next((Element)provider, (String)"provider");
        }
    }

    private final void reportIfProviderReadPermissionOnlyOccurs(Context context, Element provider, LintMap providersMap) {
        Attr attr = provider.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "readPermission");
        if (attr == null) {
            return;
        }
        Attr readPermission = attr;
        Attr attr2 = provider.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "writePermission");
        if (attr2 != null) {
            Attr it = attr2;
            boolean bl = false;
            return;
        }
        attr2 = provider.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "permission");
        if (attr2 != null) {
            Attr it = attr2;
            boolean bl = false;
            return;
        }
        String providerName = Lint.resolveManifestName((Element)provider, (Project)context.getProject());
        LintMap lintMap = providersMap.getMap(providerName);
        if (lintMap == null) {
            return;
        }
        LintMap providerMap = lintMap;
        Location location = providerMap.getLocation(KEY_LOCATION);
        if (location == null) {
            return;
        }
        Location classLocation = location;
        String string = LintMap.getString$default((LintMap)providerMap, (String)KEY_IMPL_WRITE_METHODS, null, (int)2, null);
        if (string == null) {
            return;
        }
        String implementedWriteMethods = string;
        Location manifestLocation = context.getLocation((Object)readPermission, LocationType.NAME);
        Location reportLocation = context.getDriver().isIsolated() ? classLocation : manifestLocation;
        context.report(new Incident(PROVIDER_READ_PERMISSION_ONLY, reportLocation, providerName + " implements " + implementedWriteMethods + " write APIs but does not protect them with a permission. Update the <provider> tag to use android:permission or android:writePermission", this.fix().replace().text("readPermission").with("permission").range(manifestLocation).build()));
    }

    private final boolean isImplemented(UMethod $this$isImplemented) {
        UExpression uExpression = $this$isImplemented.getUastBody();
        if (uExpression == null) {
            return false;
        }
        UExpression body = uExpression;
        List expressions = body instanceof UBlockExpression ? ((UBlockExpression)body).getExpressions() : CollectionsKt.listOf((Object)body);
        UExpression uExpression2 = (UExpression)CollectionsKt.firstOrNull((List)expressions);
        UExpression first = uExpression2 != null ? UastUtils.skipParenthesizedExprDown((UExpression)uExpression2) : null;
        return expressions.size() > 1 || !this.isThrowExpression(first) && !this.isReturnLiteral(first) && !this.isNeverReturningCall(first);
    }

    private final boolean isThrowExpression(UExpression $this$isThrowExpression) {
        return this.getInsideReturnOrThis($this$isThrowExpression) instanceof UThrowExpression;
    }

    private final boolean isReturnLiteral(UExpression $this$isReturnLiteral) {
        return $this$isReturnLiteral instanceof UReturnExpression && ((UReturnExpression)$this$isReturnLiteral).getReturnExpression() instanceof ULiteralExpression;
    }

    private final UExpression getInsideReturnOrThis(UExpression $this$getInsideReturnOrThis) {
        UReturnExpression uReturnExpression = $this$getInsideReturnOrThis instanceof UReturnExpression ? (UReturnExpression)$this$getInsideReturnOrThis : null;
        if (uReturnExpression == null || (uReturnExpression = uReturnExpression.getReturnExpression()) == null || (uReturnExpression = UastUtils.skipParenthesizedExprDown((UExpression)uReturnExpression)) == null) {
            uReturnExpression = $this$getInsideReturnOrThis;
        }
        return uReturnExpression;
    }

    private final boolean isNeverReturningCall(UExpression $this$isNeverReturningCall) {
        UExpression uExpression = this.getInsideReturnOrThis($this$isNeverReturningCall);
        UElement uElement = uExpression != null ? UastLintUtilsKt.findSelector((UElement)((UElement)uExpression)) : null;
        UCallExpression uCallExpression = uElement instanceof UCallExpression ? (UCallExpression)uElement : null;
        if (uCallExpression == null) {
            return false;
        }
        UCallExpression call = uCallExpression;
        return UastLintUtilsKt.callNeverReturns((UCallExpression)call);
    }

    private final boolean isProviderAbstractWriteMethod(UMethod $this$isProviderAbstractWriteMethod) {
        boolean bl;
        int paramSize = $this$isProviderAbstractWriteMethod.getUastParameters().size();
        switch ($this$isProviderAbstractWriteMethod.getName()) {
            case "insert": {
                if (paramSize == 2) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case "delete": {
                if (paramSize == 3) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case "update": {
                if (paramSize == 4) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.SECURITY;
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(ProviderPermissionDetector.class, Scope.JAVA_FILE_SCOPE);
        PROVIDER_READ_PERMISSION_ONLY = Issue.Companion.create$default((Issue.Companion)companion, (String)"ProviderReadPermissionOnly", (String)"Provider with readPermission only and implemented write APIs", (String)"\n                This check looks for Content Providers that only have the `readPermission` \\\n                attribute but implement write APIs.\n\n                If `android:readPermission` is specified and both `android:permission` and \\\n                `android:writePermission` are omitted, other apps can access any write operations \\\n                that this provider exposes with no permission check. For a quick fix, changing the \\\n                existing `android:readPermission` to `android:permission` will protect both read \\\n                and write access with the same permission. Alternatively, declaring a separate \\\n                `android:writePermission` can protect write access with a different permission.\n            ", (Implementation)implementation, null, (Category)category, (int)5, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/tools/lint/checks/ProviderPermissionDetector$Companion;", "", "<init>", "()V", "PROVIDER_READ_PERMISSION_ONLY", "Lcom/android/tools/lint/detector/api/Issue;", "KEY_LOCATION", "", "KEY_IMPL_WRITE_METHODS", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

