/*
 * Decompiled with CFR 0.152.
 */
package cz.eman.jsonrpc.shared;

import cz.eman.jsonrpc.shared.JsonTransformer;
import cz.eman.jsonrpc.shared.MessageFactory;
import cz.eman.jsonrpc.shared.ParameterNameUtil;
import cz.eman.jsonrpc.shared.ServiceDetailsWriter;
import cz.eman.jsonrpc.shared.bo.JsonRpcRequest;
import cz.eman.jsonrpc.shared.exception.RpcException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.node.ArrayNode;

public class RpcHandler {
    protected static Map<String, Class<?>> classMapping = new HashMap();
    protected static Map<Class<?>, Object> instances = new HashMap();
    protected static final Logger log = Logger.getLogger(RpcHandler.class);
    protected ServiceDetailsWriter writer = new ServiceDetailsWriter(classMapping);

    public static synchronized void registerClass(String url, Class<?> cl) {
        if (classMapping.containsKey(url)) {
            log.warn((Object)("overriding url: " + url + " with another value: " + cl));
        }
        classMapping.put(url, cl);
        log.debug((Object)("registered class: " + cl + " with url: " + url));
    }

    public String onCall(String url, String text) {
        log.debug((Object)("json text to parse: " + text));
        JsonRpcRequest msg = null;
        try {
            if (classMapping.containsKey(url)) {
                Class<?> clazz = classMapping.get(url);
                msg = MessageFactory.getMessageQuery(text);
                Object result = this.tryCall(clazz, msg);
                return JsonTransformer.toJson(MessageFactory.getMessageNormalResult(msg, result));
            }
            throw new RpcException("url contains no service");
        }
        catch (Throwable e) {
            log.error((Object)e, e);
            try {
                return JsonTransformer.toJson(MessageFactory.getMessageErrorResult(msg, e));
            }
            catch (Exception e1) {
                log.error((Object)e1, (Throwable)e1);
                return e.getMessage();
            }
        }
    }

    public String displayHelp() {
        return this.writer.displayHelp();
    }

    protected Object tryCall(Class<?> clazz, JsonRpcRequest msg) throws InstantiationException, IllegalAccessException, JsonParseException, JsonMappingException, IOException, Throwable {
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getName().equals(msg.getMethod()) && (m.getParameterTypes().length == 0 && msg.getParams() == null || m.getParameterTypes().length == msg.getParams().size())) {
                log.debug((Object)("method found: " + m));
                Object instance = this.getInstance(clazz);
                Object[] args = new Object[m.getParameterTypes().length];
                int index = 0;
                Iterator iterator = null;
                JsonNode objectNode = msg.getParams();
                if (!ParameterNameUtil.isMethodAnotatedByPName(m) && m.getParameterTypes().length > 0) {
                    iterator = msg.getParams().getElements();
                }
                Class<?>[] classArray = m.getParameterTypes();
                int n3 = classArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    JsonNode node;
                    Class<?> cl = classArray[n4];
                    if (ParameterNameUtil.isMethodAnotatedByPName(m)) {
                        node = objectNode.get(ParameterNameUtil.getPName(m, index).value());
                        if (node == null && objectNode instanceof ArrayNode) {
                            node = objectNode.get(index);
                        }
                    } else {
                        node = (JsonNode)iterator.next();
                    }
                    args[index] = this.getArgument(cl, node);
                    ++index;
                    ++n4;
                }
                try {
                    return m.invoke(instance, args);
                }
                catch (InvocationTargetException e) {
                    log.error((Object)e, (Throwable)e);
                    throw e.getCause();
                }
            }
            ++n2;
        }
        throw new RpcException("no method found");
    }

    protected Object getInstance(Class<?> cl) throws InstantiationException, IllegalAccessException {
        if (!instances.containsKey(cl)) {
            log.debug((Object)("instance of class " + cl + " not found, creating first time"));
            Object instance = cl.newInstance();
            instances.put(cl, instance);
        }
        return instances.get(cl);
    }

    protected Object getArgument(Class<?> cl, JsonNode node) throws JsonParseException, JsonMappingException, IOException {
        if (node.isValueNode()) {
            if (cl.equals(String.class)) {
                return node.getValueAsText();
            }
            if (cl.equals(Integer.TYPE) || cl.equals(Integer.class)) {
                return node.getIntValue();
            }
            if (cl.equals(Long.TYPE) || cl.equals(Long.class)) {
                return node.getLongValue();
            }
            if (cl.equals(Boolean.TYPE) || cl.equals(Boolean.class)) {
                return node.getBooleanValue();
            }
            if (cl.equals(Double.TYPE) || cl.equals(Double.class)) {
                return node.getDoubleValue();
            }
            throw new RpcException("unsupported value type (unimplemented)");
        }
        if (node.isContainerNode()) {
            return JsonTransformer.toObject(node.toString(), cl);
        }
        throw new RpcException("unsupported value type (unimplemented)");
    }
}

