package cz.eman.jsonrpc.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.URL;

import javax.net.ssl.SSLSocketFactory;

public class HttpJsonClient implements ClientProvider {

	protected URL url;

	public HttpJsonClient(URL url) {
		this.url = url;
	}

	public String sendContent(String content) throws IOException {
		PrintWriter writer = null;
		BufferedReader reader = null;

		Socket socket;
		if (url.getProtocol().equalsIgnoreCase("https")) {
			SSLSocketFactory factory = (SSLSocketFactory) SSLSocketFactory.getDefault();
			socket = factory.createSocket(url.getHost(), 443);
		} else {
			socket = new Socket(url.getHost(), 80);
		}

		writer = new PrintWriter(new OutputStreamWriter(socket.getOutputStream())) {

			@Override
			public void println(String arg0) {
				super.println(arg0);
				System.out.println(arg0);
			}

		};

		writer.println("POST " + url.getFile() + " HTTP/1.0");
		writer.println("Host: " + url.getHost());
		writer.println("User-Agent: Portal for android, made by veronnie, soon-to-be ruler of the world!");
		writer.println("Connection: close");
		writer.println("Content-Length: " + content.length());
		writer.println("");
		writer.println(content);
		writer.flush();

		System.out.println();

		reader = new BufferedReader(new InputStreamReader(socket.getInputStream(), "UTF-8"));
		String line = null;
		String lastLine = null;
		for (; (line = reader.readLine()) != null;) {
			System.out.println(line);
			lastLine = line;
		}

		System.out.println();

		return lastLine;
	}

}
