package cz.eman.jsonrpc.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;

import org.apache.log4j.Logger;

public class TcpJsonClient implements ClientProvider {

	protected static final Logger log = Logger.getLogger(TcpJsonClient.class);

	protected Socket socket;

	protected PrintWriter writer = null;
	protected BufferedReader reader = null;

	public TcpJsonClient(Socket socket) throws IOException {
		this.socket = socket;
		writer = new PrintWriter(new OutputStreamWriter(socket.getOutputStream()));
		reader = new BufferedReader(new InputStreamReader(socket.getInputStream(), "UTF-8"));

	}

	public String sendContent(String content) throws IOException {
		log.debug("Sending content: " + content);
		writer.println(content);
		writer.flush();
		String result = reader.readLine();
		log.debug("Result: " + result);
		return result;

	}
}
