package cz.eman.jsonrpc.client.example;

import java.io.IOException;
import java.net.Socket;
import java.net.URL;

import cz.eman.jsonrpc.client.AbstractClientProxy;
import cz.eman.jsonrpc.client.ClientProvider;
import cz.eman.jsonrpc.client.HttpJsonClient;
import cz.eman.jsonrpc.client.TcpJsonClient;
import cz.eman.jsonrpc.server.example.B;
import cz.eman.jsonrpc.server.example.IMyService;

public class WebServiceClientProxy extends AbstractClientProxy<IMyService> implements IMyService {

	public static void main(String[] args) throws Exception {
		WebServiceClientProxy proxy;
		proxy = new WebServiceClientProxy(new HttpJsonClient(new URL("http://localhost/json-rpc-testserver/jsonrpc/test1")));
		proxy = new WebServiceClientProxy(new TcpJsonClient(new Socket("localhost", 20000)));
		System.out.println(proxy.add(1, 2));
		System.out.println(proxy.echo(new B()));
	}

	public WebServiceClientProxy(ClientProvider clientProvider) {
		super(IMyService.class, clientProvider);
	}

	@Override
	public B echo(B b) throws IOException {
		return (B) super.callMethod("echo", b);
	}

	@Override
	public Integer add(Integer a, Integer b) throws IOException {
		return (Integer) super.callMethod("add", new Object[] { a, b });
	}

	@Override
	public Integer addWithException(Integer a, Integer b) throws IOException {
		return (Integer) super.callMethod("addWithException", new Object[] { a, b });
	}

	@Override
	public void touch() throws IOException {
		super.callMethod("touch");
	}

	@Override
	public void touchWithException() throws IOException {
		super.callMethod("touchWithException");
	}

}
