package cz.eman.jsonrpc.client.ui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.net.UnknownHostException;

import org.apache.log4j.Logger;

import cz.eman.jsonrpc.client.AbstractClientProxy;
import cz.eman.jsonrpc.client.ClientProvider;
import cz.eman.jsonrpc.client.TcpJsonClient;
import cz.eman.jsonrpc.shared.exception.RpcErrorException;

public class TextClient<T> {
	protected static final Logger log = Logger.getLogger(TextClient.class);

	protected AbstractClientProxy<T> proxy;

	public static void main(String[] args) {
		args = new String[] { "localhost", "20000" };
		try {
			TcpJsonClient client = new TcpJsonClient(new Socket(args[0], Integer.parseInt(args[1])));
			new TextClient(null, client);
		} catch (NumberFormatException e) {
			System.out.println("Port muset be number");
			displayUsage();
			log.error(e, e);
		} catch (UnknownHostException e) {
			System.out.println("Unknown host");
			displayUsage();
			log.error(e, e);
		} catch (IOException e) {
			System.out.println("IOException");
			displayUsage();
			log.error(e, e);
		} catch (Exception e) {
			System.out.println("Exception");
			displayUsage();
			log.error(e, e);
		}
	}

	protected static void displayUsage() {
		System.out.println("Usage: ");
		System.out.println("ip port");
	}

	public TextClient(Class<T> clazz, ClientProvider provider) {
		proxy = new AbstractClientProxy<T>(clazz, provider, false);

		BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
		String line;

		try {
			while ((line = reader.readLine()) != null) {
				parseLine(line);
			}
		} catch (IOException e) {
			log.error(e, e);
		}
	}

	public void parseLine(String line) {
		if (line.startsWith("call")) {
			String[] args = line.split(" ");
			Object[] os = new Object[args.length - 2];
			for (int i = 2; i < args.length; i++) {
				os[i - 2] = args[i];
			}
			try {
				System.out.println("result: " + proxy.callNativeMethod(args[1], os));
			} catch (RpcErrorException e) {
				log.debug(e, e);
			} catch (Exception e) {
				log.error(e, e);
			}
		} else if (line.equals("exit")) {
			System.out.println("bye...");
			System.exit(0);
		}
	}
}
