package cz.eman.jsonrpc.server.tcp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;

import org.apache.log4j.Logger;

import cz.eman.jsonrpc.server.RpcHandler;

public abstract class TcpJsonServer {
	protected static Logger log;

	protected Socket socket;

	protected PrintWriter writer = null;

	protected BufferedReader reader = null;

	protected RpcHandler handler;

	protected ServerSocket ss;

	protected Object implementation;

	protected IRpcCallListener listener;

	public TcpJsonServer(Object o, int port) throws IOException {
		this(o, port, null);
	}

	public TcpJsonServer(Object o, int port, IRpcCallListener listener) throws IOException {
		log = Logger.getLogger(this.getClass());
		this.implementation = o;
		this.listener = listener;
		handler = new RpcHandler();
		RpcHandler.registerInstance(o.getClass().getName(), o);
		ss = new ServerSocket(port);
		log.debug("listening at: " + ss);
	}

	protected void onConnect() {

	}

	protected void onException() {

	}

}
