package cz.eman.jsonrpc.server.tcp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;

import org.apache.log4j.Logger;

import cz.eman.jsonrpc.server.RpcHandler;

public class Worker implements Runnable, IRpcCallListener {
	protected static final Logger log = Logger.getLogger(Worker.class);

	public static final ThreadLocal<Socket> tlSocket = new ThreadLocal<Socket>();

	protected Socket socket;

	protected PrintWriter writer = null;

	protected BufferedReader reader = null;

	protected RpcHandler handler;

	protected String url;

	protected IRpcCallListener listener;

	public Worker(Socket socket, RpcHandler handler, String url, IRpcCallListener listener) throws IOException {
		this.listener = listener;
		this.socket = socket;
		this.url = url;
		this.handler = handler;
		writer = new PrintWriter(new OutputStreamWriter(socket.getOutputStream()));
		reader = new BufferedReader(new InputStreamReader(socket.getInputStream(), "UTF-8"));
	}

	@Override
	public void run() {
		tlSocket.set(socket);
		onConnect(socket);
		String line = null;
		try {
			while ((line = reader.readLine()) != null) {
				log.debug("received text: " + line);
				String result = handler.onCall(url, line);
				log.debug("sending result: " + result);
				writer.println(result);
				writer.flush();
			}
			log.debug("received null, existing");
			// onExit
			onExit(socket);
		} catch (Exception e) {
			log.error(e, e);
			onException(socket, e);
		}
	}

	@Override
	public void onConnect(Socket s) {
		if (listener != null) {
			listener.onConnect(s);
		}
	}

	@Override
	public void onException(Socket s, Exception e) {
		if (listener != null) {
			listener.onException(s, e);
		}
	}

	@Override
	public void onExit(Socket s) {
		if (listener != null) {
			listener.onExit(s);
		}

	}


}
