package cz.eman.jsonrpc.shared.bo;

import java.io.Serializable;

import org.codehaus.jackson.JsonNode;

/**
 * Error part of {@link JsonRpcErrorResponse} acording to json-rpc 2.0 <a
 * href="http://groups.google.com/group/json-rpc/web/json-rpc-2-0"
 * >specifications</a>
 * 
 * @author Karel Hovorka
 * 
 */
public class Error implements Serializable {
	protected int code;

	protected String message;

	protected JsonNode data;

	public Error() {

	}

	public int getCode() {
		return code;
	}

	public void setCode(int code) {
		this.code = code;
	}

	public String getMessage() {
		return message;
	}

	public void setMessage(String message) {
		this.message = message;
	}

	public JsonNode getData() {
		return data;
	}

	public void setData(JsonNode data) {
		this.data = data;
	}

	@Override
	public String toString() {
		final String TAB = "    ";
		String retValue = "";
		retValue = "Error ( " + "code = " + this.code + TAB + "message = " + this.message + TAB + "data = " + this.data + TAB + " )";
		return retValue;
	}

}
