* [做项目（多个C++、Java、Go、测开、前端项目）](https://www.programmercarl.com/other/kstar.html)
* [刷算法（两个月高强度学算法）](https://www.programmercarl.com/xunlian/xunlianying.html)
* [背八股（40天挑战高频面试题）](https://www.programmercarl.com/xunlian/bagu.html)



# 5.最长回文子串

[力扣题目链接](https://leetcode.cn/problems/longest-palindromic-substring/)

给你一个字符串 s，找到 s 中最长的回文子串。

示例 1：
* 输入：s = "babad"
* 输出："bab"
* 解释："aba" 同样是符合题意的答案。

示例 2：
* 输入：s = "cbbd"
* 输出："bb"

示例 3：
* 输入：s = "a"
* 输出："a"

示例 4：
* 输入：s = "ac"
* 输出："a"


## 思路

本题和[647.回文子串](https://programmercarl.com/0647.回文子串.html) 差不多是一样的，但647.回文子串更基本一点，建议可以先做647.回文子串

### 暴力解法

两层for循环，遍历区间起始位置和终止位置，然后判断这个区间是不是回文。

时间复杂度：O(n^3)

### 动态规划

动规五部曲：

1. 确定dp数组（dp table）以及下标的含义

布尔类型的dp[i][j]：表示区间范围[i,j] （注意是左闭右闭）的子串是否是回文子串，如果是dp[i][j]为true，否则为false。


2. 确定递推公式

在确定递推公式时，就要分析如下几种情况。

整体上是两种，就是s[i]与s[j]相等，s[i]与s[j]不相等这两种。

当s[i]与s[j]不相等，那没啥好说的了，dp[i][j]一定是false。

当s[i]与s[j]相等时，这就复杂一些了，有如下三种情况

* 情况一：下标i 与 j相同，同一个字符例如a，当然是回文子串
* 情况二：下标i 与 j相差为1，例如aa，也是文子串
* 情况三：下标：i 与 j相差大于1的时候，例如cabac，此时s[i]与s[j]已经相同了，我们看i到j区间是不是回文子串就看aba是不是回文就可以了，那么aba的区间就是 i+1 与 j-1区间，这个区间是不是回文就看dp[i + 1][j - 1]是否为true。

以上三种情况分析完了，那么递归公式如下：

```CPP
if (s[i] == s[j]) {
    if (j - i <= 1) { // 情况一 和 情况二
        dp[i][j] = true;
    } else if (dp[i + 1][j - 1]) { // 情况三
        dp[i][j] = true;
    }
}
```

注意这里我没有列出当s[i]与s[j]不相等的时候，因为在下面dp[i][j]初始化的时候，就初始为false。

在得到[i,j]区间是否是回文子串的时候，直接保存最长回文子串的左边界和右边界，代码如下：

```CPP
if (s[i] == s[j]) {
    if (j - i <= 1) { // 情况一 和 情况二
        dp[i][j] = true;
    } else if (dp[i + 1][j - 1]) { // 情况三
        dp[i][j] = true;
    }
}
if (dp[i][j] && j - i + 1 > maxlenth) {
    maxlenth = j - i + 1;
    left = i;
    right = j;
}
```

3. dp数组如何初始化

dp[i][j]可以初始化为true么？ 当然不行，怎能刚开始就全都匹配上了。

所以dp[i][j]初始化为false。

4. 确定遍历顺序

遍历顺序可有有点讲究了。

首先从递推公式中可以看出，情况三是根据dp[i + 1][j - 1]是否为true，在对dp[i][j]进行赋值true的。

dp[i + 1][j - 1] 在 dp[i][j]的左下角，如图：

![647.回文子串](https://file1.kamacoder.com/i/algo/20210121171032473.jpg)

如果这矩阵是从上到下，从左到右遍历，那么会用到没有计算过的dp[i + 1][j - 1]，也就是根据不确定是不是回文的区间[i+1,j-1]，来判断了[i,j]是不是回文，那结果一定是不对的。

**所以一定要从下到上，从左到右遍历，这样保证dp[i + 1][j - 1]都是经过计算的**。

有的代码实现是优先遍历列，然后遍历行，其实也是一个道理，都是为了保证dp[i + 1][j - 1]都是经过计算的。

代码如下：

```CPP
for (int i = s.size() - 1; i >= 0; i--) { // 注意遍历顺序
    for (int j = i; j < s.size(); j++) {
        if (s[i] == s[j]) {
            if (j - i <= 1) { // 情况一 和 情况二
                dp[i][j] = true;
            } else if (dp[i + 1][j - 1]) { // 情况三
                dp[i][j] = true;
            }
        }
        if (dp[i][j] && j - i + 1 > maxlenth) {
            maxlenth = j - i + 1;
            left = i;
            right = j;
        }
    }

}
```

5. 举例推导dp数组

举例，输入："aaa"，dp[i][j]状态如下：

![647.回文子串1](https://file1.kamacoder.com/i/algo/20210121171059951.jpg)

**注意因为dp[i][j]的定义，所以j一定是大于等于i的，那么在填充dp[i][j]的时候一定是只填充右上半部分**。

以上分析完毕，C++代码如下：

```CPP
class Solution {
public:
    string longestPalindrome(string s) {
        vector<vector<int>> dp(s.size(), vector<int>(s.size(), 0));
        int maxlenth = 0;
        int left = 0;
        int right = 0;
        for (int i = s.size() - 1; i >= 0; i--) {
            for (int j = i; j < s.size(); j++) {
                if (s[i] == s[j]) {
                    if (j - i <= 1) { // 情况一 和 情况二
                        dp[i][j] = true;
                    } else if (dp[i + 1][j - 1]) { // 情况三
                        dp[i][j] = true;
                    }
                }
                if (dp[i][j] && j - i + 1 > maxlenth) {
                    maxlenth = j - i + 1;
                    left = i;
                    right = j;
                }
            }

        }
        return s.substr(left, right - left + 1);
    }
};
```
以上代码是为了凸显情况一二三，当然是可以简洁一下的，如下：

```CPP
class Solution {
public:
    string longestPalindrome(string s) {
        vector<vector<int>> dp(s.size(), vector<int>(s.size(), 0));
        int maxlenth = 0;
        int left = 0;
        int right = 0;
        for (int i = s.size() - 1; i >= 0; i--) {
            for (int j = i; j < s.size(); j++) {
                if (s[i] == s[j] && (j - i <= 1 || dp[i + 1][j - 1])) {
                    dp[i][j] = true;
                }
                if (dp[i][j] && j - i + 1 > maxlenth) {
                    maxlenth = j - i + 1;
                    left = i;
                    right = j;
                }
            }
        }
        return s.substr(left, maxlenth);
    }
};

```

* 时间复杂度：O(n^2)
* 空间复杂度：O(n^2)

### 双指针

动态规划的空间复杂度是偏高的，我们再看一下双指针法。

首先确定回文串，就是找中心然后想两边扩散看是不是对称的就可以了。

**在遍历中心点的时候，要注意中心点有两种情况**。

一个元素可以作为中心点，两个元素也可以作为中心点。

那么有的同学问了，三个元素还可以做中心点呢。其实三个元素就可以由一个元素左右添加元素得到，四个元素则可以由两个元素左右添加元素得到。

所以我们在计算的时候，要注意一个元素为中心点和两个元素为中心点的情况。

**这两种情况可以放在一起计算，但分别计算思路更清晰，我倾向于分别计算**，代码如下：

```CPP
class Solution {
public:
    int left = 0;
    int right = 0;
    int maxLength = 0;
    string longestPalindrome(string s) {
        int result = 0;
        for (int i = 0; i < s.size(); i++) {
            extend(s, i, i, s.size()); // 以i为中心
            extend(s, i, i + 1, s.size()); // 以i和i+1为中心
        }
        return s.substr(left, maxLength);
    }
    void extend(const string& s, int i, int j, int n) {
        while (i >= 0 && j < n && s[i] == s[j]) {
            if (j - i + 1 > maxLength) {
                left = i;
                right = j;
                maxLength = j - i + 1;
            }
            i--;
            j++;
        }
    }
};

```

* 时间复杂度：O(n^2)
* 空间复杂度：O(1)

### Manacher 算法

Manacher 算法的关键在于高效利用回文的对称性，通过插入分隔符和维护中心、边界等信息，在线性时间内找到最长回文子串。这种方法避免了重复计算，是处理回文问题的最优解。

```c++
//Manacher 算法
class Solution {
public:
    string longestPalindrome(string s) {
        // 预处理字符串，在每个字符之间插入 '#'
        string t = "#";
        for (char c : s) {
            t += c; // 添加字符
            t += '#';// 添加分隔符
        }
        int n = t.size();// 新字符串的长度
        vector<int> p(n, 0);// p[i] 表示以 t[i] 为中心的回文半径
        int center = 0, right = 0;// 当前回文的中心和右边界
        

        // 遍历预处理后的字符串
        for (int i = 0; i < n; i++) {
             // 如果当前索引在右边界内，利用对称性初始化 p[i]
            if (i < right) {
                p[i] = min(right - i, p[2 * center - i]);
            }
             // 尝试扩展回文
            while (i - p[i] - 1 >= 0 && i + p[i] + 1 < n && t[i - p[i] - 1] == t[i + p[i] + 1]) {
                p[i]++;// 增加回文半径
            }
            // 如果当前回文扩展超出右边界，更新中心和右边界
            if (i + p[i] > right) {
                center = i;// 更新中心
                right = i + p[i];// 更新右边界
            }
        }
       // 找到最大回文半径和对应的中心
        int maxLen = 0, centerIndex = 0;
        for (int i = 0; i < n; i++) {
            if (p[i] > maxLen) {
                maxLen = p[i];// 更新最大回文长度
                centerIndex = i;// 更新中心索引
            }
        }
        // 计算原字符串中回文子串的起始位置并返回
        return s.substr((centerIndex - maxLen) / 2, maxLen);
    }
};
```



* 时间复杂度：O(n)
* 空间复杂度：O(n)

## 其他语言版本

### Java：

```java
// 双指针 动态规划
class Solution {
    public String longestPalindrome(String s) {
        if (s.length() == 0 || s.length() == 1) return s;
        int length = 1;
        int index = 0;
        boolean[][] palindrome = new boolean[s.length()][s.length()];
        for (int i = 0; i < s.length(); i++) {
            palindrome[i][i] = true;
        }

        for (int L = 2; L <= s.length(); L++) {
            for (int i = 0; i < s.length(); i++) {
                int j = i + L - 1;
                if (j >= s.length()) break;
                if (s.charAt(i) != s.charAt(j)) {
                    palindrome[i][j] = false;
                } else {
                    if (j - i < 3) {
                        palindrome[i][j] = true;
                    } else {
                        palindrome[i][j] = palindrome[i + 1][j - 1];
                    }
                }
                if (palindrome[i][j] && j - i + 1 > length) {
                    length = j - i + 1;
                    index = i;
                }
            }
        }
        return s.substring(index, index + length);
    }
}
```

```java
// 双指针 中心扩散法
class Solution {
    public String longestPalindrome(String s) {
        String s1 = "";
        String s2 = "";
        String res = "";
        for (int i = 0; i < s.length(); i++) {
            // 分两种情况：即一个元素作为中心点，两个元素作为中心点
            s1 = extend(s, i, i);  // 情况1
            res = s1.length() > res.length() ? s1 : res;
            s2 = extend(s, i, i + 1);  // 情况2
            res = s2.length() > res.length() ? s2 : res;
        }
        return res;  // 返回最长的
    }
    public String extend(String s, int start, int end){
        String tmp = "";
        while (start >= 0 && end < s.length() && s.charAt(start) == s.charAt(end)){
            tmp = s.substring(start, end + 1);  // Java中substring是左闭右开的，所以要+1
            // 向两边扩散
            start--;
            end++;
        }
        return tmp;
    }
}
```

### Python：

```python
class Solution:
    def longestPalindrome(self, s: str) -> str:
        dp = [[False] * len(s) for _ in range(len(s))]
        maxlenth = 0
        left = 0
        right = 0
        for i in range(len(s) - 1, -1, -1):
            for j in range(i, len(s)):
                if s[j] == s[i]:
                    if j - i <= 1 or dp[i + 1][j - 1]:
                        dp[i][j] = True
                if dp[i][j] and j - i + 1 > maxlenth:
                    maxlenth = j - i + 1
                    left = i
                    right = j
        return s[left:right + 1]

```
双指针：

```python
class Solution:
    def longestPalindrome(self, s: str) -> str:

        def find_point(i, j, s):
            while i >= 0 and j < len(s) and s[i] == s[j]:
                i -= 1
                j += 1
            return i + 1, j

        def compare(start, end, left, right):
            if right - left > end - start:
                return left, right
            else:
                return start, end

        start = 0
        end = 0
        for i in range(len(s)):
            left, right = find_point(i, i, s)
            start, end = compare(start, end, left, right)

            left, right = find_point(i, i + 1, s)
            start, end = compare(start, end, left, right)
        return s[start:end]

```
### Go：

```go
func longestPalindrome(s string) string {
    maxLen := 0
    left := 0
    length := 0
    dp := make([][]bool, len(s))
    for i := 0; i < len(s); i++ {
        dp[i] = make([]bool,len(s))
    }
    for i := len(s)-1; i >= 0; i-- {
        for j := i; j < len(s); j++ {
            if s[i] == s[j]{
                if j-i <= 1{ // 情况一和情况二
                    length = j-i
                    dp[i][j]=true
                }else if dp[i+1][j-1]{ // 情况三
                    length = j-i
                    dp[i][j] = true
                }
            }
        }
        if length > maxLen {
            maxLen = length
            left = i
        }
    }
    return s[left: left+maxLen+1]
}


```

### JavaScript：

```js
//动态规划解法
var longestPalindrome = function(s) {
    const len = s.length;
    // 布尔类型的dp[i][j]：表示区间范围[i,j] （注意是左闭右闭）的子串是否是回文子串，如果是dp[i][j]为true，否则为false
    let dp = new Array(len).fill(false).map(() => new Array(len).fill(false));
    // left起始位置  maxlenth回文串长度
    let left = 0, maxlenth = 0;
    for(let i = len - 1; i >= 0; i--){
        for(let j = i; j < len; j++){
            // 情况一：下标i 与 j相同，同一个字符例如a，当然是回文子串 j - i == 0
            // 情况二：下标i 与 j相差为1，例如aa，也是文子串 j - i == 1
            // 情况一和情况二 可以合并为 j - i <= 1
            // 情况三：下标：i 与 j相差大于1的时候，例如cabac，此时s[i]与s[j]已经相同了，我们看i到j区间是不是回文子串就看aba是不是回文就可以了，那么aba的区间就是 i+1 与 j-1区间，这个区间是不是回文就看dp[i + 1][j - 1]===true
            if(s[i] === s[j] && (j - i <= 1 || dp[i + 1][j - 1])){
                dp[i][j] = true;
            }
            // 只要 dp[i][j] == true 成立，就表示子串 s[i..j] 是回文，此时记录回文长度和起始位置
            if(dp[i][j] && j - i + 1 > maxlenth) {
                maxlenth = j - i + 1; // 回文串长度
                left = i; // 起始位置
            }
        }
    }
    return s.substr(left, maxlenth); // 找到子串
};

//双指针
var longestPalindrome = function(s) {
    let left = 0, right = 0, maxLength = 0;
    const extend = (s, i, j, n) => {// s为字符串 i,j为双指针 n为字符串长度
        while(i >= 0 && j < n && s[i] === s[j]){
            if(j - i + 1 > maxLength){
                left = i; // 更新开始位置
                right = j; // 更新结尾位置
                maxLength = j - i + 1; // 更新子串最大长度
            }
            // 指针移动
            i--;
            j++;
        }
    }
    for(let i = 0; i < s.length; i++){
        extend(s, i, i, s.length); // 以i为中心
        extend(s, i, i + 1, s.length); // 以i和i+1为中心
    }
    return s.substr(left, maxLength);
};

//Manacher算法
var longestPalindrome = function(s) {
    const len = s.length;
    if(len < 2) return s;
    let maxLength = 1, index = 0;
    //Manacher算法,利用回文对称的性质，根据i在上一个回文中心的臂长里的位置去判断i的回文性
    //需要知道上一个回文中心，以及其臂长
    let center = 0;
    //注意这里使用了maxRight的而不是真实的臂长length,因为之后需要判断i在臂长的什么位置
    //如果这里臂长用了length,之后还要 计算i - center 去和 length比较，太繁琐
    let maxRight = 0;
    //考虑到回文串的长度是偶数的情况,所以这里预处理一下字符串,每个字符间插入特殊字符,把可能性都化为奇数
    //这个处理把回文串长度的可能性都化为了奇数
    //#c#b#b#a#
    //#c#b#a#b#d#
    let ss = "";
    for(let i = 0; i < s.length; i++){
        ss += "#"+s[i];
    }
    ss += "#";
    //需要维护一个每个位置臂长的信息数组positionLength
    const pl = new Array(ss.length).fill(0);
    //这里需要注意参考的是i关于center对称的点i'的回文性
    //i' = 2*center - i;
    //所以列下情况:
    //1.i>maxRight,找不到i',无法参考，自己算自己的
    //2.i<=maxRight:
    //2.1 i<maxRight-pl[i'],pl[i']的臂长没有超过center的臂长,根据对称性,pl[i] = pl[i']
    //2.2 i=maxRight-pl[i'],pl[i']的臂长刚好等于center的臂长,根据对称性,pl[i] >= pl[i‘],大多少需要尝试扩散
    //2.3 i>maxRight-pl[i'],pl[i']的臂长超过了center的臂长,根据对称性,i中心扩散到MaxRight处,
    // s[2*i-maxRight] !== s[MaxRight]必不相等，所以pl[i] = maxRight-i;
    //总结就是pl[i] = Math.min(maxRight-i,pl[i']);提示i<maxRight-pl[i'] 也可写成 pl[i']<maxRight-i
    //0没有意义,从1开始计算
    for(let i = 1; i < ss.length; i++){
        if(i <= maxRight){//可以参考之前的
            pl[i] = Math.min(maxRight - i, pl[2 * center - i]);
            //尝试中心扩散
        }
        //注意到i<maxRight时都要尝试中心扩散,所以写else完全无意义,把中心扩散的代码写在下面
        // else{//i不在之前回文中心的臂长范围里,之前的信息就完全无法参考,只能从i中心扩散把，然后去维护maxRight和center的定义
        //尝试中心扩散
        //这里不要动center和maxRight
        // center = i;
        // maxRight = pl[i] + i + 1;
        let right = pl[i] + i + 1;
        let left = i - pl[i] - 1;
        while (left >= 0 && right<ss.length && ss[left] === ss[right]) {
            right++;
            left--;
            pl[i]++;
        }
        // }
        if(pl[i] + i > maxRight){
            center = i;
            maxRight = pl[i] + i;
        }
        if (pl[i] * 2 + 1 > maxLength){
            maxLength = pl[i]*2+1;
            index = i - pl[i];
        }
    }
    return ss.substr(index, maxLength).replace(/#/g,"");
};
```

### C：

动态规划：
```c
//初始化dp数组，全部初始为false
bool **initDP(int strLen) {
    bool **dp = (bool **)malloc(sizeof(bool *) * strLen);
    int i, j;
    for(i = 0; i < strLen; ++i) {
        dp[i] = (bool *)malloc(sizeof(bool) * strLen);
        for(j = 0; j < strLen; ++j)
            dp[i][j] = false;
    }
    return dp;
}

char * longestPalindrome(char * s){
    //求出字符串长度
    int strLen = strlen(s);
    //初始化dp数组，元素初始化为false
    bool **dp = initDP(strLen);
    int maxLength = 0, left = 0, right = 0;

    //从下到上，从左到右遍历
    int i, j;
    for(i = strLen - 1; i >= 0; --i) {
        for(j = i; j < strLen; ++j) {
            //若当前i与j所指字符一样
            if(s[i] == s[j]) {
                //若i、j指向相邻字符或同一字符，则为回文字符串
                if(j - i <= 1)
                    dp[i][j] = true;
                //若i+1与j-1所指字符串为回文字符串，则i、j所指字符串为回文字符串
                else if(dp[i + 1][j - 1])
                    dp[i][j] = true;
            }
            //若新的字符串的长度大于之前的最大长度，进行更新
            if(dp[i][j] && j - i + 1 > maxLength) {
                maxLength = j - i + 1;
                left = i;
                right = j;
            }
        }
    }
    //复制回文字符串，并返回
    char *ret = (char*)malloc(sizeof(char) * (maxLength + 1));
    memcpy(ret, s + left, maxLength);
    ret[maxLength] = 0;
    return ret;
}
```

双指针：
```c
int left, maxLength;
void extend(char *str, int i, int j, int size) {
    while(i >= 0 && j < size && str[i] == str[j]) {
        //若当前子字符串长度大于最长的字符串长度，进行更新
        if(j - i + 1 > maxLength) {
            maxLength = j - i + 1;
            left = i;
        }
        //左指针左移，右指针右移。扩大搜索范围
        ++j, --i;
    }
}

char * longestPalindrome(char * s){
    left = right = maxLength = 0;
    int size = strlen(s);

    int i;
    for(i = 0; i < size; ++i) {
        //长度为单数的子字符串
        extend(s, i, i, size);
        //长度为双数的子字符串
        extend(s, i, i + 1, size);
    }

    //复制子字符串
    char *subStr = (char *)malloc(sizeof(char) * (maxLength + 1));
    memcpy(subStr, s + left, maxLength);
    subStr[maxLength] = 0;

    return subStr;
}
```

### C#：

動態規則：
```csharp
public class Solution {
    
    public string LongestPalindrome(string s) {
        bool[,] dp = new bool[s.Length, s.Length];
        int maxlenth = 0;
        int left = 0;
        int right = 0;
        for(int i = s.Length-1 ; i>=0; i--){
            for(int j = i; j <s.Length;j++){
                if(s[i] == s[j]){
                    if(j - i <= 1){ // 情况一和情况二
                        dp[i, j] = true;
                    }else if( dp[i+1, j-1] ){ // 情况三
                        dp[i, j] = true;
                    }
                }
                if(dp[i, j] && j-i+1 > maxlenth){
                    maxlenth = j-i+1;
                    left = i;
                    right = j;
                }
            }
        }
        return s.Substring(left, maxlenth);
    }
}
```

雙指針：
```csharp
public class Solution {
    int maxlenth = 0;
    int left = 0;
    int right = 0;
    
    public string LongestPalindrome(string s) {
         int result = 0;
        for (int i = 0; i < s.Length; i++) {
            extend(s, i, i, s.Length); // 以i為中心
            extend(s, i, i + 1, s.Length); // 以i和i+1為中心
        }
        return s.Substring(left, maxlenth);
    }
    
    private void extend(string s, int i, int j, int n) {
        while (i >= 0 && j < n && s[i] == s[j]) {
            if (j - i + 1 > maxlenth) {
                left = i;
                right = j;
                maxlenth = j - i + 1;
            }
            i--;
            j++;
        }
    }
}
```



