* [做项目（多个C++、Java、Go、测开、前端项目）](https://www.programmercarl.com/other/kstar.html)
* [刷算法（两个月高强度学算法）](https://www.programmercarl.com/xunlian/xunlianying.html)
* [背八股（40天挑战高频面试题）](https://www.programmercarl.com/xunlian/bagu.html)



# 59.螺旋矩阵II

[力扣题目链接](https://leetcode.cn/problems/spiral-matrix-ii/)

给定一个正整数 n，生成一个包含 1 到 n^2 所有元素，且元素按顺时针顺序螺旋排列的正方形矩阵。

示例:

输入: 3
输出:
[
 [ 1, 2, 3 ],
 [ 8, 9, 4 ],
 [ 7, 6, 5 ]
]


## 算法公开课

**[《代码随想录》算法视频公开课](https://programmercarl.com/other/gongkaike.html)：[拿下螺旋矩阵！LeetCode：59.螺旋矩阵II](https://www.bilibili.com/video/BV1SL4y1N7mV)，相信结合视频再看本篇题解，更有助于大家对本题的理解**。

## 思路

这道题目可以说在面试中出现频率较高的题目，**本题并不涉及到什么算法，就是模拟过程，但却十分考察对代码的掌控能力。**

要如何画出这个螺旋排列的正方形矩阵呢？

相信很多同学刚开始做这种题目的时候，上来就是一波判断猛如虎。

结果运行的时候各种问题，然后开始各种修修补补，最后发现改了这里那里有问题，改了那里这里又跑不起来了。

大家还记得我们在这篇文章[数组：每次遇到二分法，都是一看就会，一写就废](https://programmercarl.com/0704.二分查找.html)中讲解了二分法，提到如果要写出正确的二分法一定要坚持**循环不变量原则**。

而求解本题依然是要坚持循环不变量原则。

模拟顺时针画矩阵的过程:

* 填充上行从左到右
* 填充右列从上到下
* 填充下行从右到左
* 填充左列从下到上

由外向内一圈一圈这么画下去。

可以发现这里的边界条件非常多，在一个循环中，如此多的边界条件，如果不按照固定规则来遍历，那就是**一进循环深似海，从此offer是路人**。

这里一圈下来，我们要画每四条边，这四条边怎么画，每画一条边都要坚持一致的左闭右开，或者左开右闭的原则，这样这一圈才能按照统一的规则画下来。

那么我按照左闭右开的原则，来画一圈，大家看一下：

![](https://file1.kamacoder.com/i/algo/20220922102236.png)

这里每一种颜色，代表一条边，我们遍历的长度，可以看出每一个拐角处的处理规则，拐角处让给新的一条边来继续画。

这也是坚持了每条边左闭右开的原则。

一些同学做这道题目之所以一直写不好，代码越写越乱。

就是因为在画每一条边的时候，一会左开右闭，一会左闭右闭，一会又来左闭右开，岂能不乱。

代码如下，已经详细注释了每一步的目的，可以看出while循环里判断的情况是很多的，代码里处理的原则也是统一的左闭右开。

整体C++代码如下：

```CPP
class Solution {
public:
    vector<vector<int>> generateMatrix(int n) {
        vector<vector<int>> res(n, vector<int>(n, 0)); // 使用vector定义一个二维数组
        int startx = 0, starty = 0; // 定义每循环一个圈的起始位置
        int loop = n / 2; // 每个圈循环几次，例如n为奇数3，那么loop = 1 只是循环一圈，矩阵中间的值需要单独处理
        int mid = n / 2; // 矩阵中间的位置，例如：n为3， 中间的位置就是(1，1)，n为5，中间位置为(2, 2)
        int count = 1; // 用来给矩阵中每一个空格赋值
        int offset = 1; // 需要控制每一条边遍历的长度，每次循环右边界收缩一位
        int i,j;
        while (loop --) {
            i = startx;
            j = starty;

            // 下面开始的四个for就是模拟转了一圈
            // 模拟填充上行从左到右(左闭右开)
            for (j; j < n - offset; j++) {
                res[i][j] = count++;
            }
            // 模拟填充右列从上到下(左闭右开)
            for (i; i < n - offset; i++) {
                res[i][j] = count++;
            }
            // 模拟填充下行从右到左(左闭右开)
            for (; j > starty; j--) {
                res[i][j] = count++;
            }
            // 模拟填充左列从下到上(左闭右开)
            for (; i > startx; i--) {
                res[i][j] = count++;
            }

            // 第二圈开始的时候，起始位置要各自加1， 例如：第一圈起始位置是(0, 0)，第二圈起始位置是(1, 1)
            startx++;
            starty++;

            // offset 控制每一圈里每一条边遍历的长度
            offset += 1;
        }

        // 如果n为奇数的话，需要单独给矩阵最中间的位置赋值
        if (n % 2) {
            res[mid][mid] = count;
        }
        return res;
    }
};
```

* 时间复杂度 O(n^2): 模拟遍历二维矩阵的时间
* 空间复杂度 O(1)

## 类似题目

* [54.螺旋矩阵](https://leetcode.cn/problems/spiral-matrix/)
* [剑指Offer 29.顺时针打印矩阵](https://leetcode.cn/problems/shun-shi-zhen-da-yin-ju-zhen-lcof/)




## 其他语言版本

### Java：

```Java
class Solution {
    public int[][] generateMatrix(int n) {
        int[][] nums = new int[n][n];
        int startX = 0, startY = 0;  // 每一圈的起始点
        int offset = 1;
        int count = 1;  // 矩阵中需要填写的数字
        int loop = 1; // 记录当前的圈数
        int i, j; // j 代表列, i 代表行;

        while (loop <= n / 2) {

            // 顶部
            // 左闭右开，所以判断循环结束时， j 不能等于 n - offset
            for (j = startY; j < n - offset; j++) {
                nums[startX][j] = count++;
            }

            // 右列
            // 左闭右开，所以判断循环结束时， i 不能等于 n - offset
            for (i = startX; i < n - offset; i++) {
                nums[i][j] = count++;
            }

            // 底部
            // 左闭右开，所以判断循环结束时， j != startY
            for (; j > startY; j--) {
                nums[i][j] = count++;
            }

            // 左列
            // 左闭右开，所以判断循环结束时， i != startX
            for (; i > startX; i--) {
                nums[i][j] = count++;
            }
            startX++;
            startY++;
            offset++;
            loop++;
        }
        if (n % 2 == 1) { // n 为奇数时，单独处理矩阵中心的值
            nums[startX][startY] = count;
        }
        return nums;
    }
}


```

### python3:

```python
class Solution:
    def generateMatrix(self, n: int) -> List[List[int]]:
        nums = [[0] * n for _ in range(n)]
        startx, starty = 0, 0               # 起始点
        loop, mid = n // 2, n // 2          # 迭代次数、n为奇数时，矩阵的中心点
        count = 1                           # 计数

        for offset in range(1, loop + 1) :      # 每循环一层偏移量加1，偏移量从1开始
            for i in range(starty, n - offset) :    # 从左至右，左闭右开
                nums[startx][i] = count
                count += 1
            for i in range(startx, n - offset) :    # 从上至下
                nums[i][n - offset] = count
                count += 1
            for i in range(n - offset, starty, -1) : # 从右至左
                nums[n - offset][i] = count
                count += 1
            for i in range(n - offset, startx, -1) : # 从下至上
                nums[i][starty] = count
                count += 1                
            startx += 1         # 更新起始点
            starty += 1

        if n % 2 != 0 :			# n为奇数时，填充中心点
            nums[mid][mid] = count 
        return nums
```

版本二：定义四个边界
```python
class Solution(object):
    def generateMatrix(self, n):
        if n <= 0:
            return []
        
        # 初始化 n x n 矩阵
        matrix = [[0]*n for _ in range(n)]

        # 初始化边界和起始值
        top, bottom, left, right = 0, n-1, 0, n-1
        num = 1

        while top <= bottom and left <= right:
            # 从左到右填充上边界
            for i in range(left, right + 1):
                matrix[top][i] = num
                num += 1
            top += 1

            # 从上到下填充右边界
            for i in range(top, bottom + 1):
                matrix[i][right] = num
                num += 1
            right -= 1

            # 从右到左填充下边界

            for i in range(right, left - 1, -1):
                matrix[bottom][i] = num
                num += 1
            bottom -= 1

            # 从下到上填充左边界

            for i in range(bottom, top - 1, -1):
                matrix[i][left] = num
                num += 1
            left += 1

        return matrix
```

### JavaScript:

```javascript

var generateMatrix = function(n) {
    let startX = startY = 0;   // 起始位置
    let loop = Math.floor(n/2);   // 旋转圈数
    let mid = Math.floor(n/2);    // 中间位置
    let offset = 1;    // 控制每一层填充元素个数
    let count = 1;     // 更新填充数字
    let res = new Array(n).fill(0).map(() => new Array(n).fill(0));

    while (loop--) {
        let row = startX, col = startY;
        // 上行从左到右（左闭右开）
        for (; col < n - offset; col++) {
            res[row][col] = count++;
        }
        // 右列从上到下（左闭右开）
        for (; row < n - offset; row++) {
            res[row][col] = count++;
        }
        // 下行从右到左（左闭右开）
        for (; col > startY; col--) {
            res[row][col] = count++;
        }
        // 左列做下到上（左闭右开）
        for (; row > startX; row--) {
            res[row][col] = count++;
        }

        // 更新起始位置
        startX++;
        startY++;

        // 更新offset
        offset += 1;
    }
    // 如果n为奇数的话，需要单独给矩阵最中间的位置赋值
    if (n % 2 === 1) {
        res[mid][mid] = count;
    }
    return res;
};

  

```

### TypeScript:

```typescript
function generateMatrix(n: number): number[][] {
    let loopNum: number = Math.floor(n / 2);
    const resArr: number[][] = new Array(n).fill(1).map(i => new Array(n));
    let chunkNum: number = n - 1;
    let startX: number = 0;
    let startY: number = 0;
    let value: number = 1;
    let x: number, y: number;
    while (loopNum--) {
        x = startX;
        y = startY;
        while (x < startX + chunkNum) {
            resArr[y][x] = value;
            x++;
            value++;
        }
        while (y < startY + chunkNum) {
            resArr[y][x] = value;
            y++;
            value++;
        }
        while (x > startX) {
            resArr[y][x] = value;
            x--;
            value++;
        }
        while (y > startY) {
            resArr[y][x] = value;
            y--;
            value++;
        }
        startX++;
        startY++;
        chunkNum -= 2;
    }
    if (n % 2 === 1) {
        resArr[startX][startY] = value;
    }
    return resArr;
};
```

### Go:

```go
package main

import "fmt"

func main() {
	n := 3
	fmt.Println(generateMatrix(n))
}

func generateMatrix(n int) [][]int {
	startx, starty := 0, 0
	var loop int = n / 2
	var center int = n / 2
	count := 1
	offset := 1
	res := make([][]int, n)
	for i := 0; i < n; i++ {
		res[i] = make([]int, n)
	}
	for loop > 0 {
		i, j := startx, starty

		//行数不变 列数在变
		for j = starty; j < n-offset; j++ {
			res[startx][j] = count
			count++
		}
		//列数不变是j 行数变
		for i = startx; i < n-offset; i++ {
			res[i][j] = count
			count++
		}
		//行数不变 i 列数变 j--
		for ; j > starty; j-- {
			res[i][j] = count
			count++
		}
		//列不变 行变
		for ; i > startx; i-- {
			res[i][j] = count
			count++
		}
		startx++
		starty++
		offset++
		loop--
	}
	if n%2 == 1 {
		res[center][center] = n * n
	}
	return res
}
```

```go
func generateMatrix(n int) [][]int {
    top, bottom := 0, n-1
    left, right := 0, n-1
    num := 1
    tar := n * n
    matrix := make([][]int, n)
    for i := 0; i < n; i++ {
        matrix[i] = make([]int, n)
    }
    for num <= tar {
        for i := left; i <= right; i++ {
            matrix[top][i] = num
            num++
        }
        top++
        for i := top; i <= bottom; i++ {
            matrix[i][right] = num
            num++
        }
        right--
        for i := right; i >= left; i-- {
            matrix[bottom][i] = num
            num++
        }
        bottom--
        for i := bottom; i >= top; i-- {
            matrix[i][left] = num
            num++
        }
        left++
    }
    return matrix
}
```

### Swift:

```swift
func generateMatrix(_ n: Int) -> [[Int]] {
    var result = [[Int]](repeating: [Int](repeating: 0, count: n), count: n)

    var startRow = 0
    var startColumn = 0
    var loopCount = n / 2
    let mid = n / 2
    var count = 1
    var offset = 1
    var row: Int
    var column: Int

    while loopCount > 0 {
        row = startRow
        column = startColumn

        for c in column ..< startColumn + n - offset {
            result[startRow][c] = count
            count += 1
            column += 1
        }

        for r in row ..< startRow + n - offset {
            result[r][column] = count
            count += 1
            row += 1
        }

        for _ in startColumn ..< column {
            result[row][column] = count
            count += 1
            column -= 1
        }

        for _ in startRow ..< row {
            result[row][column] = count
            count += 1
            row -= 1
        }

        startRow += 1
        startColumn += 1
        offset += 2
        loopCount -= 1
    }

    if (n % 2) != 0 {
        result[mid][mid] = count
    }
    return result
}
```

### Rust:

```rust
impl Solution {
    pub fn generate_matrix(n: i32) -> Vec<Vec<i32>> {
        let mut res = vec![vec![0; n as usize]; n as usize];
        let (mut startX, mut startY, mut offset): (usize, usize, usize) = (0, 0, 1);
        let mut loopIdx = n/2;
        let mid: usize = loopIdx as usize;
        let mut count = 1;
        let (mut i, mut j): (usize, usize) = (0, 0);
        while loopIdx > 0 {
            i = startX;
            j = startY;
            
            while j < (startY + (n as usize) - offset) {
                res[i][j] = count; 
                count += 1;
                j += 1;
            }
            
            while i < (startX + (n as usize) - offset) {
                res[i][j] = count; 
                count += 1;
                i += 1;
            }
            
            while j > startY {
                res[i][j] = count;
                count += 1;
                j -= 1;
            }
            
            while i > startX {
                res[i][j] = count;
                count += 1;
                i -= 1;
            }
            
            startX += 1;
            startY += 1;   
            offset += 2; 
            loopIdx -= 1;
        }
        
        if(n % 2 == 1) {
            res[mid][mid] = count;
        }
        res
    }
}
```

### PHP:

```php
class Solution {
    /**
     * @param Integer $n
     * @return Integer[][]
     */
    function generateMatrix($n) {
        // 初始化数组
        $res = array_fill(0, $n, array_fill(0, $n, 0));
        $mid = $loop = floor($n / 2);
        $startX = $startY = 0;
        $offset = 1;
        $count = 1;
        while ($loop > 0) {
            $i = $startX;
            $j = $startY;
            for (; $j < $startY + $n - $offset; $j++) {
                $res[$i][$j] = $count++;
            }
            for (; $i < $startX + $n - $offset; $i++) {
                $res[$i][$j] = $count++;
            }
            for (; $j > $startY; $j--) {
                $res[$i][$j] = $count++;
            }
            for (; $i > $startX; $i--) {
                $res[$i][$j] = $count++;
            }
            $startX += 1;
            $startY += 1;
            $offset += 2;
            $loop--;
        }
        if ($n % 2 == 1) {
            $res[$mid][$mid] = $count;
        }
        return $res;
    }
}
```

### C:

```c
int** generateMatrix(int n, int* returnSize, int** returnColumnSizes){
    //初始化返回的结果数组的大小
    *returnSize = n;
    *returnColumnSizes = (int*)malloc(sizeof(int) * n);
    //初始化返回结果数组ans
    int** ans = (int**)malloc(sizeof(int*) * n);
    int i;
    for(i = 0; i < n; i++) {
        ans[i] = (int*)malloc(sizeof(int) * n);
        (*returnColumnSizes)[i] = n;
    }

    //设置每次循环的起始位置
    int startX = 0;
    int startY = 0;
    //设置二维数组的中间值，若n为奇数。需要最后在中间填入数字
    int mid = n / 2;
    //循环圈数
    int loop = n / 2;
    //偏移数
    int offset = 1;
    //当前要添加的元素
    int count = 1;

    while(loop) {
        int i = startX;
        int j = startY;
        //模拟上侧从左到右
        for(; j < startY + n - offset; j++) {
            ans[startX][j] = count++;
        }
        //模拟右侧从上到下
        for(; i < startX + n - offset; i++) {
            ans[i][j] = count++;
        }
        //模拟下侧从右到左
        for(; j > startY; j--) {
            ans[i][j] = count++;
        }
        //模拟左侧从下到上
        for(; i > startX; i--) {
            ans[i][j] = count++;
        }
        //偏移值每次加2
        offset+=2;
        //遍历起始位置每次+1
        startX++;
        startY++;
        loop--;
    }
    //若n为奇数需要单独给矩阵中间赋值
    if(n%2)
        ans[mid][mid] = count;

    return ans;
}
```
### Scala:

```scala
object Solution {
  def generateMatrix(n: Int): Array[Array[Int]] = {
    var res = Array.ofDim[Int](n, n) // 定义一个n*n的二维矩阵
    var num = 1 // 标志当前到了哪个数字
    var i = 0 // 横坐标
    var j = 0 // 竖坐标

    while (num <= n * n) {
      // 向右：当j不越界，并且下一个要填的数字是空白时
      while (j < n && res(i)(j) == 0) {
        res(i)(j) = num // 当前坐标等于num
        num += 1 // num++
        j += 1 // 竖坐标+1
      }
      i += 1 // 下移一行
      j -= 1 // 左移一列

      // 剩下的都同上

      // 向下
      while (i < n && res(i)(j) == 0) {
        res(i)(j) = num
        num += 1
        i += 1
      }
      i -= 1
      j -= 1

      // 向左
      while (j >= 0 && res(i)(j) == 0) {
        res(i)(j) = num
        num += 1
        j -= 1
      }
      i -= 1
      j += 1

      // 向上
      while (i >= 0 && res(i)(j) == 0) {
        res(i)(j) = num
        num += 1
        i -= 1
      }
      i += 1
      j += 1
    }
    res
  }
}
```
### C#：

```csharp
public int[][] GenerateMatrix(int n)
{
    // 参考Carl的代码随想录里面C++的思路
    // https://www.programmercarl.com/0059.%E8%9E%BA%E6%97%8B%E7%9F%A9%E9%98%B5II.html#%E6%80%9D%E8%B7%AF
    int startX = 0, startY = 0; // 定义每循环一个圈的起始位置
    int loop = n / 2; // 每个圈循环几次，例如n为奇数3，那么loop = 1 只是循环一圈，矩阵中间的值需要单独处理
    int count = 1; // 用来给矩阵每个空格赋值
    int mid = n / 2; // 矩阵中间的位置，例如：n为3， 中间的位置就是(1，1)，n为5，中间位置为(2, 2)
    int offset = 1;// 需要控制每一条边遍历的长度，每次循环右边界收缩一位

    // 构建result二维数组
    int[][] result = new int[n][];
    for (int k = 0; k < n; k++)
    {
        result[k] = new int[n];
    }

    int i = 0, j = 0; // [i,j]
    while (loop > 0)
    {
        i = startX;
        j = startY;
        // 四个For循环模拟转一圈
        // 第一排，从左往右遍历，不取最右侧的值(左闭右开)
        for (; j < n - offset; j++)
        {
            result[i][j] = count++;
        }
        // 右侧的第一列，从上往下遍历，不取最下面的值(左闭右开)
        for (; i < n - offset; i++)
        {
            result[i][j] = count++;
        }

        // 最下面的第一行，从右往左遍历，不取最左侧的值(左闭右开)
        for (; j > startY; j--)
        {
            result[i][j] = count++;
        }

        // 左侧第一列，从下往上遍历，不取最左侧的值(左闭右开)
        for (; i > startX; i--)
        {
            result[i][j] = count++;
        }
        // 第二圈开始的时候，起始位置要各自加1， 例如：第一圈起始位置是(0, 0)，第二圈起始位置是(1, 1)
        startX++;
        startY++;

        // offset 控制每一圈里每一条边遍历的长度
        offset++;
        loop--;
    }
    if (n % 2 == 1)
    {
        // n 为奇数
        result[mid][mid] = count;
    }
    return result;
}
```

### Ruby:
```ruby
def generate_matrix(n)
  result = Array.new(n) { Array.new(n, 0) }
  #循环次数
  loop_times = 0
  #步长
  step = n - 1
  val = 1

 
  while loop_times < n / 2
    #模拟从左向右
    for i in 0..step - 1
      #行数不变，列数变
      result[loop_times][i+loop_times] = val
      val += 1
    end
    
    #模拟从上到下
    for i in 0..step - 1
      #列数不变，行数变
      result[i+loop_times][n-loop_times-1] = val
      val += 1
    end

    #模拟从右到左
    for i in 0..step - 1
      #行数不变，列数变
      result[n-loop_times-1][n-loop_times-i-1] = val
      val += 1
    end

    #模拟从下到上
    for i in 0..step - 1
      #列数不变，行数变
      result[n-loop_times-i-1][loop_times] = val
      val += 1
    end
    
    loop_times += 1
    step -= 2
  end
  
  #如果是奇数，则填充最后一个元素
  result[n/2][n/2] = n**2 if n % 2
  
  return result
  
end
```

