* [做项目（多个C++、Java、Go、测开、前端项目）](https://www.programmercarl.com/other/kstar.html)
* [刷算法（两个月高强度学算法）](https://www.programmercarl.com/xunlian/xunlianying.html)
* [背八股（40天挑战高频面试题）](https://www.programmercarl.com/xunlian/bagu.html)


# 205. 同构字符串

[力扣题目链接](https://leetcode.cn/problems/isomorphic-strings/)

给定两个字符串 s 和 t，判断它们是否是同构的。

如果 s 中的字符可以按某种映射关系替换得到 t ，那么这两个字符串是同构的。

每个出现的字符都应当映射到另一个字符，同时不改变字符的顺序。不同字符不能映射到同一个字符上，相同字符只能映射到同一个字符上，字符可以映射到自己本身。

示例 1:
* 输入：s = "egg", t = "add"
* 输出：true

示例 2：
* 输入：s = "foo", t = "bar"
* 输出：false

示例 3：
* 输入：s = "paper", t = "title"
* 输出：true

提示：可以假设 s 和 t 长度相同。

## 思路

字符串没有说都是小写字母之类的，所以用数组不合适了，用map来做映射。

使用两个map 保存 s[i] 到 t[j] 和 t[j] 到 s[i] 的映射关系，如果发现对应不上，立刻返回 false

C++代码 如下：

```CPP
class Solution {
public:
    bool isIsomorphic(string s, string t) {
        unordered_map<char, char> map1;
        unordered_map<char, char> map2;
        for (int i = 0, j = 0; i < s.size(); i++, j++) {
            if (map1.find(s[i]) == map1.end()) { // map1保存s[i] 到 t[j]的映射
                map1[s[i]] = t[j];
            }
            if (map2.find(t[j]) == map2.end()) { // map2保存t[j] 到 s[i]的映射
                map2[t[j]] = s[i];
            }
            // 发现映射 对应不上，立刻返回false
            if (map1[s[i]] != t[j] || map2[t[j]] != s[i]) {
                return false;
            }
        }
        return true;
    }
};
```


## 其他语言版本

### Java

```java
class Solution {
    public boolean isIsomorphic(String s, String t) {
        Map<Character, Character> map1 = new HashMap<>();
        Map<Character, Character> map2 = new HashMap<>();
        for (int i = 0, j = 0; i < s.length(); i++, j++) {
            if (!map1.containsKey(s.charAt(i))) {
                map1.put(s.charAt(i), t.charAt(j)); // map1保存 s[i] 到 t[j]的映射
            }
            if (!map2.containsKey(t.charAt(j))) {
                map2.put(t.charAt(j), s.charAt(i)); // map2保存 t[j] 到 s[i]的映射
            }
            // 无法映射，返回 false
            if (map1.get(s.charAt(i)) != t.charAt(j) || map2.get(t.charAt(j)) != s.charAt(i)) {
                return false;
            }
        }
        return true;
    }
}
```

### Python

```python
class Solution:
    def isIsomorphic(self, s: str, t: str) -> bool:
        default_dict1 = defaultdict(str)
        default_dict2 = defaultdict(str)
    
        if len(s) != len(t): return false

        for i in range(len(s)):
            if not default_dict1[s[i]]:
                default_dict1[s[i]] = t[i]
            
            if not default_dict2[t[i]]:
                default_dict2[t[i]] = s[i]

            if default_dict1[s[i]] != t[i] or default_dict2[t[i]] != s[i]:
                return False
            
        return True
```

### Go

```go
func isIsomorphic(s string, t string) bool {
	map1 := make(map[byte]byte)
	map2 := make(map[byte]byte)
	for i := range s {
		if _, ok := map1[s[i]]; !ok {
			map1[s[i]] = t[i] // map1保存 s[i] 到 t[j]的映射
		}
		if _, ok := map2[t[i]]; !ok {
			map2[t[i]] = s[i] // map2保存 t[i] 到 s[j]的映射
		}
		// 无法映射，返回 false
		if (map1[s[i]] != t[i]) || (map2[t[i]] != s[i]) {
			return false
		}
	}
	return true
}
```

### JavaScript

```js
var isIsomorphic = function(s, t) {
    let len = s.length;
    if(len === 0) return true;
    let maps = new Map();
    let mapt = new Map();
    for(let i = 0, j = 0; i < len; i++, j++){
        if(!maps.has(s[i])){
            maps.set(s[i],t[j]);// maps保存 s[i] 到 t[j]的映射
        } 
        if(!mapt.has(t[j])){
            mapt.set(t[j],s[i]);// mapt保存 t[j] 到 s[i]的映射
        }
        // 无法映射，返回 false
        if(maps.get(s[i]) !== t[j] || mapt.get(t[j]) !== s[i]){
            return false;
        }
    };
    return true;
};
```

### TypeScript

```typescript
function isIsomorphic(s: string, t: string): boolean {
    const helperMap1: Map<string, string> = new Map();
    const helperMap2: Map<string, string> = new Map();
    for (let i = 0, length = s.length; i < length; i++) {
        let temp1: string | undefined = helperMap1.get(s[i]);
        let temp2: string | undefined = helperMap2.get(t[i]);
        if (temp1 === undefined && temp2 === undefined) {
            helperMap1.set(s[i], t[i]);
            helperMap2.set(t[i], s[i]);
        } else if (temp1 !== t[i] || temp2 !== s[i]) {
            return false;
        }
    }
    return true;
};
```





