* [做项目（多个C++、Java、Go、测开、前端项目）](https://www.programmercarl.com/other/kstar.html)
* [刷算法（两个月高强度学算法）](https://www.programmercarl.com/xunlian/xunlianying.html)
* [背八股（40天挑战高频面试题）](https://www.programmercarl.com/xunlian/bagu.html)


# 724.寻找数组的中心下标

[力扣题目链接](https://leetcode.cn/problems/find-pivot-index/)

给你一个整数数组 nums ，请计算数组的 中心下标 。

数组 中心下标 是数组的一个下标，其左侧所有元素相加的和等于右侧所有元素相加的和。

如果中心下标位于数组最左端，那么左侧数之和视为 0 ，因为在下标的左侧不存在元素。这一点对于中心下标位于数组最右端同样适用。

如果数组有多个中心下标，应该返回 最靠近左边 的那一个。如果数组不存在中心下标，返回 -1 。

示例 1：
* 输入：nums = [1, 7, 3, 6, 5, 6]
* 输出：3
* 解释：中心下标是 3。左侧数之和 sum = nums[0] + nums[1] + nums[2] = 1 + 7 + 3 = 11 ，右侧数之和 sum = nums[4] + nums[5] = 5 + 6 = 11 ，二者相等。

示例 2：
* 输入：nums = [1, 2, 3]
* 输出：-1
* 解释：数组中不存在满足此条件的中心下标。

示例 3：
* 输入：nums = [2, 1, -1]
* 输出：0
* 解释：中心下标是 0。左侧数之和 sum = 0 ，（下标 0 左侧不存在元素），右侧数之和 sum = nums[1] + nums[2] = 1 + -1 = 0 。


## 思路

这道题目还是比较简单直接的  

1. 遍历一遍求出总和sum
2. 遍历第二遍求中心索引左半和leftSum
    * 同时根据sum和leftSum 计算中心索引右半和rightSum
    * 判断leftSum和rightSum是否相同

C++代码如下：
```CPP
class Solution {
public:
    int pivotIndex(vector<int>& nums) {
        int sum = 0;
        for (int num : nums) sum += num; // 求和
        int leftSum = 0;    // 中心索引左半和
        int rightSum = 0;   // 中心索引右半和
        for (int i = 0; i < nums.size(); i++) {
            leftSum += nums[i];
            rightSum = sum - leftSum + nums[i];
            if (leftSum == rightSum) return i;
        }
        return -1;
    }
};
```


## 其他语言版本

### Java

```java
class Solution {
    public int pivotIndex(int[] nums) {
        int sum = 0;
        for (int i = 0; i < nums.length; i++) {
            sum += nums[i]; // 总和
        }
        int leftSum = 0;
        int rightSum = 0;
        for (int i = 0; i < nums.length; i++) {
            leftSum += nums[i];
            rightSum = sum - leftSum + nums[i]; // leftSum 里面已经有 nums[i]，多减了一次，所以加上
            if (leftSum == rightSum) {
                return i;
            }
        }
        return -1; // 不存在
    }
}
```

### Python3

```python
class Solution:
    def pivotIndex(self, nums: List[int]) -> int:
        numSum = sum(nums) #数组总和
        leftSum = 0
        for i in range(len(nums)):
            if numSum - leftSum -nums[i] == leftSum: #左右和相等
                return i
            leftSum += nums[i]
        return -1
```

### Go

```go
func pivotIndex(nums []int) int {
	sum := 0
	for _, v := range nums {
		sum += v;
	}

	leftSum := 0    // 中心索引左半和
	rightSum := 0   // 中心索引右半和
	for i := 0; i < len(nums); i++ {
		leftSum += nums[i]
		rightSum = sum - leftSum + nums[i]
		if leftSum == rightSum{
			return i
		}
	}
	return -1
}

```

### JavaScript

```js
var pivotIndex = function(nums) {
    const sum = nums.reduce((a,b) => a + b);//求和
    // 中心索引左半和 中心索引右半和
    let leftSum = 0, rightSum = 0;
    for(let i = 0; i < nums.length; i++){
        leftSum += nums[i];
        rightSum = sum - leftSum + nums[i];// leftSum 里面已经有 nums[i]，多减了一次，所以加上
        if(leftSum === rightSum) return i;
    }
    return -1;
};
```

### TypeScript

```typescript
function pivotIndex(nums: number[]): number {
    const length: number = nums.length;
    const sum: number = nums.reduce((a, b) => a + b);
    let leftSum: number = 0;
    for (let i = 0; i < length; i++) {
        const rightSum: number = sum - leftSum - nums[i];
        if (leftSum === rightSum) return i;
        leftSum += nums[i];
    }
    return -1;
};
```




