* [做项目（多个C++、Java、Go、测开、前端项目）](https://www.programmercarl.com/other/kstar.html)
* [刷算法（两个月高强度学算法）](https://www.programmercarl.com/xunlian/xunlianying.html)
* [背八股（40天挑战高频面试题）](https://www.programmercarl.com/xunlian/bagu.html)


# 860.柠檬水找零

[力扣题目链接](https://leetcode.cn/problems/lemonade-change/)

在柠檬水摊上，每一杯柠檬水的售价为 5 美元。

顾客排队购买你的产品，（按账单 bills 支付的顺序）一次购买一杯。

每位顾客只买一杯柠檬水，然后向你付 5 美元、10 美元或 20 美元。你必须给每个顾客正确找零，也就是说净交易是每位顾客向你支付 5 美元。

注意，一开始你手头没有任何零钱。

如果你能给每位顾客正确找零，返回 true ，否则返回 false 。

示例 1：
* 输入：[5,5,5,10,20]
* 输出：true
* 解释：
    * 前 3 位顾客那里，我们按顺序收取 3 张 5 美元的钞票。
    * 第 4 位顾客那里，我们收取一张 10 美元的钞票，并返还 5 美元。
    * 第 5 位顾客那里，我们找还一张 10 美元的钞票和一张 5 美元的钞票。
    * 由于所有客户都得到了正确的找零，所以我们输出 true。

示例 2：
* 输入：[5,5,10]
* 输出：true

示例 3：
* 输入：[10,10]
* 输出：false

示例 4：
* 输入：[5,5,10,10,20]
* 输出：false
* 解释：
    * 前 2 位顾客那里，我们按顺序收取 2 张 5 美元的钞票。
    * 对于接下来的 2 位顾客，我们收取一张 10 美元的钞票，然后返还 5 美元。
    * 对于最后一位顾客，我们无法退回 15 美元，因为我们现在只有两张 10 美元的钞票。
    * 由于不是每位顾客都得到了正确的找零，所以答案是 false。

提示：

* 0 <= bills.length <= 10000
* bills[i] 不是 5 就是 10 或是 20 

## 算法公开课

**[《代码随想录》算法视频公开课](https://programmercarl.com/other/gongkaike.html)：[贪心算法，看上去复杂，其实逻辑都是固定的！LeetCode：860.柠檬水找零](https://www.bilibili.com/video/BV12x4y1j7DD)，相信结合视频在看本篇题解，更有助于大家对本题的理解**。

## 思路

这是前几天的leetcode每日一题，感觉不错，给大家讲一下。

这道题目刚一看，可能会有点懵，这要怎么找零才能保证完成全部账单的找零呢？

**但仔细一琢磨就会发现，可供我们做判断的空间非常少！**

只需要维护三种金额的数量，5，10和20。

有如下三种情况：

* 情况一：账单是5，直接收下。
* 情况二：账单是10，消耗一个5，增加一个10
* 情况三：账单是20，优先消耗一个10和一个5，如果不够，再消耗三个5

此时大家就发现 情况一，情况二，都是固定策略，都不用我们来做分析了，而唯一不确定的其实在情况三。

而情况三逻辑也不复杂甚至感觉纯模拟就可以了，其实情况三这里是有贪心的。

账单是20的情况，为什么要优先消耗一个10和一个5呢？

**因为美元10只能给账单20找零，而美元5可以给账单10和账单20找零，美元5更万能！**

所以局部最优：遇到账单20，优先消耗美元10，完成本次找零。全局最优：完成全部账单的找零。

局部最优可以推出全局最优，并找不出反例，那么就试试贪心算法！

C++代码如下：

```CPP
class Solution {
public:
    bool lemonadeChange(vector<int>& bills) {
        int five = 0, ten = 0, twenty = 0;
        for (int bill : bills) {
            // 情况一
            if (bill == 5) five++;
            // 情况二
            if (bill == 10) {
                if (five <= 0) return false;
                ten++;
                five--;
            }
            // 情况三
            if (bill == 20) {
                // 优先消耗10美元，因为5美元的找零用处更大，能多留着就多留着
                if (five > 0 && ten > 0) {
                    five--;
                    ten--;
                    twenty++; // 其实这行代码可以删了，因为记录20已经没有意义了，不会用20来找零
                } else if (five >= 3) {
                    five -= 3;
                    twenty++; // 同理，这行代码也可以删了
                } else return false;
            }
        }
        return true;
    }
};
```
* 时间复杂度: O(n)
* 空间复杂度: O(1)


## 总结

咋眼一看好像很复杂，分析清楚之后，会发现逻辑其实非常固定。

这道题目可以告诉大家，遇到感觉没有思路的题目，可以静下心来把能遇到的情况分析一下，只要分析到具体情况了，一下子就豁然开朗了。

如果一直陷入想从整体上寻找找零方案，就会把自己陷进去，各种情况一交叉，只会越想越复杂了。


## 其他语言版本


### Java 
```java
class Solution {
    public boolean lemonadeChange(int[] bills) {
        int five = 0;
        int ten = 0;

        for (int i = 0; i < bills.length; i++) {
            if (bills[i] == 5) {
                five++;
            } else if (bills[i] == 10) {
                five--;
                ten++;
            } else if (bills[i] == 20) {
                if (ten > 0) {
                    ten--;
                    five--;
                } else {
                    five -= 3;
                }
            }
            if (five < 0 || ten < 0) return false;
        }
        
        return true;
    }
}
```

### Python 
```python
class Solution:
    def lemonadeChange(self, bills: List[int]) -> bool:
        five = 0
        ten = 0
        twenty = 0
        
        for bill in bills:
            # 情况一：收到5美元
            if bill == 5:
                five += 1
            
            # 情况二：收到10美元
            if bill == 10:
                if five <= 0:
                    return False
                ten += 1
                five -= 1
            
            # 情况三：收到20美元
            if bill == 20:
                # 先尝试使用10美元和5美元找零
                if five > 0 and ten > 0:
                    five -= 1
                    ten -= 1
                    #twenty += 1
                # 如果无法使用10美元找零，则尝试使用三张5美元找零
                elif five >= 3:
                    five -= 3
                    #twenty += 1
                else:
                    return False
        
        return True


```

### Go 

```go
func lemonadeChange(bills []int) bool {
    ten, five := 0, 0
    for i := 0; i < len(bills); i++ {
        if bills[i] == 5 {
            five++
        } else if bills[i] == 10 {
            if five == 0 {
                return false
            }
            ten++; five--
        } else {
            if ten >= 1 && five >= 1 {
                ten--; five--
            } else if five >= 3 {
                five -= 3
            } else {
                return false
            }
        }
    }
    return true
}
```

### JavaScript 
```Javascript
var lemonadeChange = function(bills) {
    let fiveCount = 0
    let tenCount = 0

    for(let i = 0; i < bills.length; i++) {
        let bill = bills[i]
        if(bill === 5) {
            fiveCount += 1
        } else if (bill === 10) {
            if(fiveCount > 0) {
                fiveCount -=1
                tenCount += 1
            } else {
                return false
            }
        } else {
            if(tenCount > 0 && fiveCount > 0) {
                tenCount -= 1
                fiveCount -= 1 
            } else if(fiveCount >= 3) {
                fiveCount -= 3
            } else {
                return false
            }
        } 
    }
    return true
};

```

### Rust

```Rust
impl Solution {
    pub fn lemonade_change(bills: Vec<i32>) -> bool {
        let mut five = 0;
        let mut ten = 0;
        // let mut twenty = 0;
        for bill in bills {
            if bill == 5 { five += 1; }
            if bill == 10 {
                if five <= 0 { return false; }
                ten += 1;
                five -= 1;
            }
            if bill == 20 {
                if five > 0 && ten > 0 {
                    five -= 1;
                    ten -= 1;
                    // twenty += 1;
                } else if five >= 3 {
                    five -= 3;
                    // twenty += 1;
                } else { return false; }
            }
        }
        true
    }
}
```

### C
```c
bool lemonadeChange(int* bills, int billsSize){
    // 分别记录五元、十元的数量（二十元不用记录，因为不会用到20元找零）
    int fiveCount = 0; int tenCount = 0; 

    int i;
    for(i = 0; i < billsSize; ++i) {
        // 分情况讨论每位顾客的付款
        switch(bills[i]) {
            // 情况一：直接收款五元
            case 5:
                fiveCount++;
                break;
            // 情况二：收款十元
            case 10:
                // 若没有五元找零，返回false
                if(fiveCount == 0)
                    return false;
                // 收款十元并找零五元
                fiveCount--;
                tenCount++;
                break;
            // 情况三：收款二十元
            case 20:
                // 若可以，优先用十元和五元找零（因为十元只能找零20，所以需要尽量用掉。而5元能找零十元和二十元）
                if(fiveCount > 0 && tenCount > 0) {
                    fiveCount--;
                    tenCount--;
                } 
                // 若没有十元，但是有三张五元。用三张五元找零
                else if(fiveCount >= 3) 
                    fiveCount-=3;
                // 无法找开，返回false
                else
                    return false;
                break;
        }
    }
    // 全部可以找开，返回true
    return true;
}
```

### TypeScript

```typescript
function lemonadeChange(bills: number[]): boolean {
    let five: number = 0,
        ten: number = 0;
    for (let bill of bills) {
        switch (bill) {
            case 5:
                five++;
                break;
            case 10:
                if (five < 1) return false;
                five--;
                ten++
                break;
            case 20:
                if (ten > 0 && five > 0) {
                    five--;
                    ten--;
                } else if (five > 2) {
                    five -= 3;
                } else {
                    return false;
                }
                break;
        }
    }
    return true;
};
```


### Scala

```scala
object Solution {
  def lemonadeChange(bills: Array[Int]): Boolean = {
    var fiveNum = 0
    var tenNum = 0

    for (i <- bills) {
      if (i == 5) fiveNum += 1
      if (i == 10) {
        if (fiveNum <= 0) return false
        tenNum += 1
        fiveNum -= 1
      }
      if (i == 20) {
        if (fiveNum > 0 && tenNum > 0) {
          tenNum -= 1
          fiveNum -= 1
        } else if (fiveNum >= 3) {
          fiveNum -= 3
        } else {
          return false
        }
      }
    }
    true
  }
}
```
### C#
```csharp
public class Solution
{
    public bool LemonadeChange(int[] bills)
    {
        int five = 0, ten = 0, twenty = 0;
        foreach (var bill in bills)
        {
            if (bill == 5) five++;
            if (bill == 10)
            {
                if (five == 0) return false;
                five--;
                ten++;
            }
            if (bill == 20)
            {
                if (ten > 0 && five > 0)
                {
                    ten--;
                    five--;
                    twenty++;
                } 
                else if (five >= 3)
                {
                    five -= 3;
                    twenty++;
                }
                else
                {
                    return false;
                }

            }
        }
        return true;
    }
}
```



