
# 什么是核心代码模式，什么又是ACM模式？

很多录友刷了不少题了，到现在也没有搞清楚什么是 ACM模式，什么是核心代码模式。

平时大家在力扣上刷题，就是 核心代码模式，即给你一个函数，直接写函数实现，例如这样：

![](https://file1.kamacoder.com/i/algo/20231109193631.png)

而ACM模式，是程序头文件，main函数，数据的输入输出都要自己处理，例如这样：

![](https://file1.kamacoder.com/i/algo/20231109193743.png)

大家可以发现 右边代码框什么都没有，程序从头到尾都需要自己实现，本题如果写完代码是这样的： （细心的录友可以发现和力扣上刷题是不一样的）

![](https://file1.kamacoder.com/i/algo/20231109193931.png)


**如果大家从一开始学习算法就一直在力扣上的话，突然切到ACM模式会非常不适应**。

知识星球里也有很多录友，因为不熟悉ACM模式在面试的过程中吃了不少亏。


<div align="center"><img src='https://file1.kamacoder.com/i/algo/20230727163624.png' width=500 alt=''></img></div>

<div align="center"><img src='https://file1.kamacoder.com/i/algo/20230727163938.png' width=500 alt=''></img></div>

<div align="center"><img src='https://file1.kamacoder.com/i/algo/20230727164042.png' width=500 alt=''></img></div>

<div align="center"><img src='https://file1.kamacoder.com/i/algo/20230727164151.png' width=500 alt=''></img></div>

<div align="center"><img src='https://file1.kamacoder.com/i/algo/20230727164459.png' width=500 alt=''></img></div>

## 面试究竟怎么考？

笔试的话，基本都是 ACM模式。

面试的话，看情况，有的面试官会让你写一个函数实现就可以，此时就是核心代码模式。

有的面试官会 给你一个编辑器，让你写完代码运行一下看看输出结果，此时就是ACM模式。

有的录友想，那我平时在力扣刷题，写的是核心代码模式，我也可以运行，为啥一定要用ACM模式。

**大家在力扣刷题刷多了，已经忘了程序是如何运行的了**，力扣上写的代码，脱离力扣环境，那个函数，你怎么运行呢？

想让程序在本地运行起来，是不是需要补充 库函数，是不是要补充main函数，是不是要补充数据的输入和输出。 那不就是ACM模式了。

综合来看，** ACM模式更考察综合代码能力， 核心代码模式是更聚焦算法的实现逻辑**。

## 去哪练习ACM模式？

这里给大家推荐卡码网： [kamacoder.com](https://kamacoder.com/)

你只要能把卡码网首页的25道题目 都刷了 ，就把所有的ACM输入输出方式都练习到位了，不会有任何盲区。

![](https://file1.kamacoder.com/i/algo/20231109195056.png)

而且你不用担心，题目难度太大，直接给自己劝退，**卡码网的前25道题目都是我精心制作的，难度也是循序渐进的**，大家去刷一下就知道了。


