# 究竟什么时候用库函数，什么时候要自己实现

在[知识星球](https://programmercarl.com/other/kstar.html)里有录友问我，刷题究竟要不要用库函数？  刷题的时候总是禁不住库函数的诱惑，如果都不用库函数一些题目做起来还很麻烦。

估计不少录友都有这个困惑，我来说一说对于库函数的使用。

一些同学可能比较喜欢看力扣上直接调用库函数的评论和题解，**其实我感觉娱乐一下还是可以的，但千万别当真，别沉迷！**

例如：[字符串：151. 翻转字符串里的单词](https://programmercarl.com/0151.%E7%BF%BB%E8%BD%AC%E5%AD%97%E7%AC%A6%E4%B8%B2%E9%87%8C%E7%9A%84%E5%8D%95%E8%AF%8D.html)这道题目本身是综合考察同学们对字符串的处理能力，如果 split  + reverse的话，那就失去了题目的意义了。

有的同学可能不屑于实现这么简单的功能，直接调库函数完事，把字符串分成一个个单词，一想就是那么一回事，多简单。

相信我，很多面试题都是一想很简单，实现起来一堆问题。 所以刷力扣本来就是为面试，也为了提高自己的代码能力，扎实一点没坏处。

**那么平时写算法题目就全都不用库函数了么？**

当然也不是，这里我给大家提供一个标准。

**如果题目关键的部分直接用库函数就可以解决，建议不要使用库函数**。

**如果库函数仅仅是 解题过程中的一小部分，并且你已经很清楚这个库函数的内部实现原理的话，那么直接用库函数。**

使用库函数最大的忌讳就是不知道这个库函数怎么实现的，也不知道其时间复杂度，上来就用，这样写出来的算法，时间复杂度自己都掌握不好的。

例如for循环里套一个字符串的insert，erase之类的操作，你说时间复杂度是多少呢，很明显是O(n^2)的时间复杂度了。

在刷题的时候本着我说的标准来使用库函数，相信对大家会有所帮助！

