
# 程序员应该用什么用具来写文档？ 



Carl平时写东西，都是统一使用markdown，包括题解啊，笔记啊，所以这里给大家安利一波markdown对程序员的重要性！

程序员为什么要学习markdown呢？

**一个让你难以拒绝的理由：markdown可以让你养成了记录的习惯**。

自从使用了markdown之后，就喜欢了写文档无法自拔，包括记录工作日志，记录周会，记录季度计划，记录学习目标，写各种设计文档。

有一种写代码一样的舒爽，markdown 和vim 一起用，简直绝配！

那来说一说markdown的好处。

## 为什么需要markdown

大家可能想为什么要使用markdown来写文档，而不用各种可以点击鼠标点点的那种所见即所得的工具来记笔记，例如word，云笔记之类的。

首先有如下几点：

1. Markdown可以在任何地方使用

**可以使用它来创建网站，笔记，电子书，演讲稿，邮件信息和各种技术文档**

2.  Markdown很轻便

事实上，**包含Markdown格式文本的文件可以被任何一个应用打开**。

如果感觉不喜欢当前使用的Markdown渲染应用，可以使用其他渲染应用来打开。

而鲜明对比的就是Microsoft Word，必须要使用特定的软件才能打开 .doc 或者 .docx的文档 而且可能还是乱码或者格式乱位。

3. Markdown是独立的平台

**你可以创建Markdown格式文本的文件在任何一个可以运行的操作系统上**

4. Markdown已经无处不在

**程序员的世界到处都是Markdown**，像简书，GitChat， GitHub，csdn等等都支持Markdown文档，正宗的官方技术文档都是使用Markdown来写的。

使用Markdown不仅可以非常方便的记录笔记，而且可以直接导出对应的网站内容，导出可打印的文档

至于markdown的语法，真的非常简单，不需要花费很长的时间掌握！

而且一旦你掌握了它，你就可以在任何地方任何平台使用Markdown来记录笔记，文档甚至写书。

很多人使用Markdown来创建网站的内容，但是Markdown更加擅长于格式化的文本内容，**使用Markdown 根部不用担心格式问题，兼容问题**。

很多后台开发程序员的工作环境是linux，linux下写文档最佳选择也是markdown。

**我平时写代码，写文档都习惯在linux系统下进行（包括我的mac），所以我更喜欢vim + markdown**。

关于vim的话，后面我也可以单独介绍一波！

## Markdown常用语法

我这里就简单列举一些最基本的语法。

### 标题

使用'#' 可以展现1-6级别的标题

```
# 一级标题
## 二级标题
### 三级标题
```

### 列表

使用 `*` 或者 `+` 或者 `-` 或者 `1. ` `2. ` 来表示列表

例如：

```
* 列表1
* 列表2
* 列表3
```

效果:
* 列表1
* 列表2
* 列表3

### 链接

使用 `[名字](url)` 表示连接，例如`[Github地址](https://github.com/youngyangyang04/Markdown-Resume-Template)`


### 添加图片

添加图片`![名字](图片地址)`  例如`![Minion](https://octodex.github.com/images/minion.png)`

### html 标签

Markdown支持部分html，例如这样

```
<center><h1>XXX</h1> </center>
```

## Markdown 渲染

有如下几种方式渲染Markdown文档

* 使用github来渲染，也就是把自己的 .md 文件传到github上，就是有可视化的展现，大家会发现github上每个项目都有一个README.md
* 使用谷歌浏览器安装MarkDown Preview Plus插件，也可以打开markdown文件，但是渲染效果不太好
* mac下建议使用macdown来打开 markdown文件，然后就可以直接导出pdf来打印了
* window下可以使用Typora来打开markdown文件，同样也可以直接导出pdf来打印

## Markdown学习资料

我这里仅仅是介绍了几个常用的语法，刚开始学习Markdown的时候语法难免会忘。

所以建议把这个markdown demo：https://markdown-it.github.io/ 收藏一下，平时用到哪里了忘了就看一看。

就酱，后面我还会陆续给大家安利一些编程利器。

## 总结

如果还没有掌握markdown的你还在等啥，赶紧使用markdown记录起来吧




-----------------------
