* [做项目（多个C++、Java、Go、测开、前端项目）](https://www.programmercarl.com/other/kstar.html)
* [刷算法（两个月高强度学算法）](https://www.programmercarl.com/xunlian/xunlianying.html)
* [背八股（40天挑战高频面试题）](https://www.programmercarl.com/xunlian/bagu.html)
# 算法模板

## 算法模板

### 二分查找法 

```CPP
class Solution {
public:
    int searchInsert(vector<int>& nums, int target) {
        int n = nums.size();
        int left = 0;
        int right = n; // 我们定义target在左闭右开的区间里，[left, right)  
        while (left < right) { // 因为left == right的时候，在[left, right)是无效的空间
            int middle = left + ((right - left) >> 1);
            if (nums[middle] > target) {
                right = middle; // target 在左区间，因为是左闭右开的区间，nums[middle]一定不是我们的目标值，所以right = middle，在[left, middle)中继续寻找目标值
            } else if (nums[middle] < target) {
                left = middle + 1; // target 在右区间，在 [middle+1, right)中
            } else { // nums[middle] == target
                return middle; // 数组中找到目标值的情况，直接返回下标
            }
        }
        return right;
    }
};

```

### KMP

```CPP
void kmp(int* next, const string& s){
    next[0] = -1;
    int j = -1;
    for(int i = 1; i < s.size(); i++){
        while (j >= 0 && s[i] != s[j + 1]) {
            j = next[j];
        }
        if (s[i] == s[j + 1]) {
            j++;
        }
        next[i] = j;
    }
}
```

### 二叉树 

二叉树的定义：

```CPP
struct TreeNode {
    int val;
    TreeNode *left;
    TreeNode *right;
    TreeNode(int x) : val(x), left(NULL), right(NULL) {}
};
```

#### 深度优先遍历（递归） 

前序遍历（中左右）
```CPP
void traversal(TreeNode* cur, vector<int>& vec) {
    if (cur == NULL) return;
    vec.push_back(cur->val);    // 中 ，同时也是处理节点逻辑的地方
    traversal(cur->left, vec);  // 左
    traversal(cur->right, vec); // 右
}
```
中序遍历（左中右）
```CPP
void traversal(TreeNode* cur, vector<int>& vec) {
    if (cur == NULL) return;
    traversal(cur->left, vec);  // 左
    vec.push_back(cur->val);    // 中 ，同时也是处理节点逻辑的地方
    traversal(cur->right, vec); // 右
}
```
后序遍历（左右中）
```CPP
void traversal(TreeNode* cur, vector<int>& vec) {
    if (cur == NULL) return;
    traversal(cur->left, vec);  // 左
    traversal(cur->right, vec); // 右
    vec.push_back(cur->val);    // 中 ，同时也是处理节点逻辑的地方
}
```

#### 深度优先遍历（迭代法）

相关题解：[0094.二叉树的中序遍历](https://github.com/youngyangyang04/leetcode/blob/master/problems/0094.二叉树的中序遍历.md)

前序遍历（中左右）
```CPP
vector<int> preorderTraversal(TreeNode* root) {
    vector<int> result;
    stack<TreeNode*> st;
    if (root != NULL) st.push(root);
    while (!st.empty()) {
        TreeNode* node = st.top();
        if (node != NULL) {
            st.pop();
            if (node->right) st.push(node->right);  // 右
            if (node->left) st.push(node->left);    // 左
            st.push(node);                          // 中
            st.push(NULL);                          
        } else {
            st.pop();
            node = st.top();
            st.pop();
            result.push_back(node->val);            // 节点处理逻辑
        }
    }
    return result;
}

```

中序遍历（左中右）
```CPP
vector<int> inorderTraversal(TreeNode* root) {
    vector<int> result; // 存放中序遍历的元素
    stack<TreeNode*> st;
    if (root != NULL) st.push(root);
    while (!st.empty()) {
        TreeNode* node = st.top();
        if (node != NULL) {
            st.pop(); 
            if (node->right) st.push(node->right);  // 右
            st.push(node);                          // 中
            st.push(NULL); 
            if (node->left) st.push(node->left);    // 左
        } else {
            st.pop(); 
            node = st.top(); 
            st.pop();
            result.push_back(node->val);            // 节点处理逻辑
        }
    }
    return result;
}
```

后序遍历（左右中）
```CPP
vector<int> postorderTraversal(TreeNode* root) {
    vector<int> result;
    stack<TreeNode*> st;
    if (root != NULL) st.push(root);
    while (!st.empty()) {
        TreeNode* node = st.top();
        if (node != NULL) {
            st.pop();
            st.push(node);                          // 中
            st.push(NULL);
            if (node->right) st.push(node->right);  // 右
            if (node->left) st.push(node->left);    // 左

        } else {
            st.pop();
            node = st.top();
            st.pop();
            result.push_back(node->val);            // 节点处理逻辑
        }
    }
    return result;
}
```
#### 广度优先遍历（队列）

相关题解：[0102.二叉树的层序遍历](https://programmercarl.com/0102.二叉树的层序遍历.html)

```CPP
vector<vector<int>> levelOrder(TreeNode* root) {
    queue<TreeNode*> que;
    if (root != NULL) que.push(root);
    vector<vector<int>> result;
    while (!que.empty()) {
        int size = que.size();
        vector<int> vec;
        for (int i = 0; i < size; i++) {// 这里一定要使用固定大小size，不要使用que.size()
            TreeNode* node = que.front();
            que.pop();
            vec.push_back(node->val);   // 节点处理的逻辑
            if (node->left) que.push(node->left);
            if (node->right) que.push(node->right);
        }
        result.push_back(vec);
    }
    return result;
}

```



可以直接解决如下题目：

* [0102.二叉树的层序遍历](https://programmercarl.com/0102.二叉树的层序遍历.html)
* [0199.二叉树的右视图](https://github.com/youngyangyang04/leetcode/blob/master/problems/0199.二叉树的右视图.md)
* [0637.二叉树的层平均值](https://github.com/youngyangyang04/leetcode/blob/master/problems/0637.二叉树的层平均值.md) 
* [0104.二叉树的最大深度 （迭代法）](https://programmercarl.com/0104.二叉树的最大深度.html)

* [0111.二叉树的最小深度（迭代法）](https://programmercarl.com/0111.二叉树的最小深度.html)
* [0222.完全二叉树的节点个数（迭代法）](https://programmercarl.com/0222.完全二叉树的节点个数.html)

#### 二叉树深度

```CPP
int getDepth(TreeNode* node) {
    if (node == NULL) return 0;
    return 1 + max(getDepth(node->left), getDepth(node->right));
}
```

#### 二叉树节点数量

```CPP
int countNodes(TreeNode* root) {
    if (root == NULL) return 0;
    return 1 + countNodes(root->left) + countNodes(root->right);
}
```

### 回溯算法 
```CPP
void backtracking(参数) {
    if (终止条件) {
        存放结果;
        return;
    }

    for (选择：本层集合中元素（树中节点孩子的数量就是集合的大小）) {
        处理节点;
        backtracking(路径，选择列表); // 递归
        回溯，撤销处理结果
    }
}

```

### 并查集 

```CPP
    int n = 1005; // 根据题意而定 
    int father[1005];

    // 并查集初始化
    void init() {
        for (int i = 0; i < n; ++i) {
            father[i] = i;
        }
    }
    // 并查集里寻根的过程
    int find(int u) {
        return u == father[u] ? u : father[u] = find(father[u]);
    }
    // 将v->u 这条边加入并查集
    void join(int u, int v) {
        u = find(u);
        v = find(v);
        if (u == v) return ;
        father[v] = u;
    }
    // 判断 u 和 v是否找到同一个根
    bool same(int u, int v) {
        u = find(u);
        v = find(v);
        return u == v;
    }
```


（持续补充ing）
## 其他语言版本

### JavaScript：

#### 二分查找法

使用左闭右闭区间

```javascript
var search = function (nums, target) {
    let left = 0, right = nums.length - 1;
    // 使用左闭右闭区间
    while (left <= right) {
        let mid = left + Math.floor((right - left)/2);
        if (nums[mid] > target) {
            right = mid - 1;  // 去左面闭区间寻找
        } else if (nums[mid] < target) {
            left = mid + 1;   // 去右面闭区间寻找
        } else {
            return mid;
        }
    }
    return -1;
};
```

使用左闭右开区间

```javascript
var search = function (nums, target) {
    let left = 0, right = nums.length;
    // 使用左闭右开区间 [left, right)
    while (left < right) {
        let mid = left + Math.floor((right - left)/2);
        if (nums[mid] > target) {
            right = mid;  // 去左面闭区间寻找
        } else if (nums[mid] < target) {
            left = mid + 1;   // 去右面闭区间寻找
        } else {
            return mid;
        }
    }
    return -1;
};
```

#### KMP

```javascript
var kmp = function (next, s) {
    next[0] = -1;
    let j = -1;
    for(let i = 1; i < s.length; i++){
        while (j >= 0 && s[i] !== s[j + 1]) {
            j = next[j];
        }
        if (s[i] === s[j + 1]) {
            j++;
        }
        next[i] = j;
    }
}
```

#### 二叉树

##### 深度优先遍历（递归）

二叉树节点定义：

```javascript
function TreeNode (val, left, right) {
    this.val = (val === undefined ? 0 : val);
    this.left = (left === undefined ? null : left);
    this.right = (right === undefined ? null : right);
}
```

前序遍历（中左右）：

```javascript
var preorder = function (root, list) {
    if (root === null) return;
    list.push(root.val);        // 中
    preorder(root.left, list);  // 左
    preorder(root.right, list); // 右
}
```

中序遍历（左中右）：

```javascript
var inorder = function (root, list) {
    if (root === null) return;
    inorder(root.left, list);  // 左
    list.push(root.val);        // 中
    inorder(root.right, list); // 右
}
```

后序遍历（左右中）：

```javascript
var postorder = function (root, list) {
    if (root === null) return;
    postorder(root.left, list);  // 左
    postorder(root.right, list); // 右
    list.push(root.val);        // 中
}
```

##### 深度优先遍历（迭代）

前序遍历（中左右）：

```javascript
var preorderTraversal = function (root) {
    let res = [];
    if (root === null) return res;
    let stack = [root],
        cur = null;
    while (stack.length) {
        cur = stack.pop();
        res.push(cur.val);
        cur.right && stack.push(cur.right);
        cur.left && stack.push(cur.left);
    }
    return res;
};
```

中序遍历（左中右）：

```javascript
var inorderTraversal = function (root) {
    let res = [];
    if (root === null) return res;
    let stack = [];
    let cur = root;
    while (stack.length ！== 0 || cur !== null) {
        if (cur !== null) {
            stack.push(cur);
            cur = cur.left;
        } else {
            cur = stack.pop();
            res.push(cur.val);
            cur = cur.right;
        }
    }
    return res;
};
```

后序遍历（左右中）：

```javascript
var postorderTraversal = function (root) {
    let res = [];
    if (root === null) return res;
    let stack = [root];
    let cur = null;
    while (stack.length) {
        cur = stack.pop();
        res.push(cur.val);
        cur.left && stack.push(cur.left);
        cur.right && stack.push(cur.right);
    }
    return res.reverse()
};
```

##### 广度优先遍历（队列）

```javascript
var levelOrder = function (root) {
    let res = [];
    if (root === null) return res;
    let queue = [root];
    while (queue.length) {
        let n = queue.length;
        let temp = [];
        for (let i = 0; i < n; i++) {
            let node = queue.shift();
            temp.push(node.val);
            node.left && queue.push(node.left);
            node.right && queue.push(node.right);
        }
        res.push(temp);
    }
    return res;
};
```

##### 二叉树深度

```javascript
var getDepth = function (node) {
    if (node === null) return 0;
    return 1 + Math.max(getDepth(node.left), getDepth(node.right));
}
```

##### 二叉树节点数量

```javascript
var countNodes = function (root) {
    if (root === null) return 0;
    return 1 + countNodes(root.left) + countNodes(root.right);
}
```

#### 回溯算法 

```javascript
function backtracking(参数) {
    if (终止条件) {
        存放结果;
        return;
    }

    for (选择：本层集合中元素（树中节点孩子的数量就是集合的大小）) {
        处理节点;
        backtracking(路径，选择列表); // 递归
        回溯，撤销处理结果
    }
}

```

#### 并查集 

```javascript
    let n = 1005; // 根据题意而定 
    let father = new Array(n).fill(0);

    // 并查集初始化
    function init () {
        for (int i = 0; i < n; ++i) {
            father[i] = i;
        }
    }
    // 并查集里寻根的过程
    function find (u) {
        return u === father[u] ? u : father[u] = find(father[u]);
    }
    // 将v->u 这条边加入并查集
    function join(u, v) {
        u = find(u);
        v = find(v);
        if (u === v) return ;
        father[v] = u;
    }
    // 判断 u 和 v是否找到同一个根
    function same(u, v) {
        u = find(u);
        v = find(v);
        return u === v;
    }
```

### TypeScript：

#### 二分查找法

使用左闭右闭区间

```typescript
var search = function (nums: number[], target: number): number {
    let left: number = 0, right: number = nums.length - 1;
    // 使用左闭右闭区间
    while (left <= right) {
        let mid: number = left + Math.floor((right - left)/2);
        if (nums[mid] > target) {
            right = mid - 1;  // 去左面闭区间寻找
        } else if (nums[mid] < target) {
            left = mid + 1;   // 去右面闭区间寻找
        } else {
            return mid;
        }
    }
    return -1;
};
```

使用左闭右开区间

```typescript
var search = function (nums: number[], target: number): number {
    let left: number = 0, right: number = nums.length;
    // 使用左闭右开区间 [left, right)
    while (left < right) {
        let mid: number = left + Math.floor((right - left)/2);
        if (nums[mid] > target) {
            right = mid;  // 去左面闭区间寻找
        } else if (nums[mid] < target) {
            left = mid + 1;   // 去右面闭区间寻找
        } else {
            return mid;
        }
    }
    return -1;
};
```

#### KMP

```typescript
var kmp = function (next: number[], s: number): void {
    next[0] = -1;
    let j: number = -1;
    for(let i: number = 1; i < s.length; i++){
        while (j >= 0 && s[i] !== s[j + 1]) {
            j = next[j];
        }
        if (s[i] === s[j + 1]) {
            j++;
        }
        next[i] = j;
    }
}
```

#### 二叉树

##### 深度优先遍历（递归）

二叉树节点定义：

```typescript
class TreeNode {
    val: number
    left: TreeNode | null
    right: TreeNode | null
    constructor(val?: number, left?: TreeNode | null, right?: TreeNode | null) {
        this.val = (val===undefined ? 0 : val)
        this.left = (left===undefined ? null : left)
        this.right = (right===undefined ? null : right)
    }
}
```

前序遍历（中左右）：

```typescript
var preorder = function (root: TreeNode | null, list: number[]): void {
    if (root === null) return;
    list.push(root.val);        // 中
    preorder(root.left, list);  // 左
    preorder(root.right, list); // 右
}
```

中序遍历（左中右）：

```typescript
var inorder = function (root: TreeNode | null, list: number[]): void {
    if (root === null) return;
    inorder(root.left, list);  // 左
    list.push(root.val);        // 中
    inorder(root.right, list); // 右
}
```

后序遍历（左右中）：

```typescript
var postorder = function (root: TreeNode | null, list: number[]): void {
    if (root === null) return;
    postorder(root.left, list);  // 左
    postorder(root.right, list); // 右
    list.push(root.val);        // 中
}
```

##### 深度优先遍历（迭代）

前序遍历（中左右）：

```typescript
var preorderTraversal = function (root: TreeNode | null): number[] {
    let res: number[] = [];
    if (root === null) return res;
    let stack: TreeNode[] = [root],
        cur: TreeNode | null = null;
    while (stack.length) {
        cur = stack.pop();
        res.push(cur.val);
        cur.right && stack.push(cur.right);
        cur.left && stack.push(cur.left);
    }
    return res;
};
```

中序遍历（左中右）：

```typescript
var inorderTraversal = function (root: TreeNode | null): number[] {
    let res: number[] = [];
    if (root === null) return res;
    let stack: TreeNode[] = [];
    let cur: TreeNode | null = root;
    while (stack.length ！== 0 || cur !== null) {
        if (cur !== null) {
            stack.push(cur);
            cur = cur.left;
        } else {
            cur = stack.pop();
            res.push(cur.val);
            cur = cur.right;
        }
    }
    return res;
};
```

后序遍历（左右中）：

```typescript
var postorderTraversal = function (root: TreeNode | null): number[] {
    let res: number[] = [];
    if (root === null) return res;
    let stack: TreeNode[] = [root];
    let cur: TreeNode | null = null;
    while (stack.length) {
        cur = stack.pop();
        res.push(cur.val);
        cur.left && stack.push(cur.left);
        cur.right && stack.push(cur.right);
    }
    return res.reverse()
};
```

##### 广度优先遍历（队列）

```typescript
var levelOrder = function (root: TreeNode | null): number[] {
    let res: number[] = [];
    if (root === null) return res;
    let queue: TreeNode[] = [root];
    while (queue.length) {
        let n: number = queue.length;
        let temp: number[] = [];
        for (let i: number = 0; i < n; i++) {
            let node: TreeNode = queue.shift();
            temp.push(node.val);
            node.left && queue.push(node.left);
            node.right && queue.push(node.right);
        }
        res.push(temp);
    }
    return res;
};
```

##### 二叉树深度

```typescript
var getDepth = function (node: TreNode | null): number {
    if (node === null) return 0;
    return 1 + Math.max(getDepth(node.left), getDepth(node.right));
}
```

##### 二叉树节点数量

```typescript
var countNodes = function (root: TreeNode | null): number {
    if (root === null) return 0;
    return 1 + countNodes(root.left) + countNodes(root.right);
}
```

#### 回溯算法 

```typescript
function backtracking(参数) {
    if (终止条件) {
        存放结果;
        return;
    }

    for (选择：本层集合中元素（树中节点孩子的数量就是集合的大小）) {
        处理节点;
        backtracking(路径，选择列表); // 递归
        回溯，撤销处理结果
    }
}

```

#### 并查集 

```typescript
    let n: number = 1005; // 根据题意而定 
    let father: number[] = new Array(n).fill(0);

    // 并查集初始化
    function init () {
        for (int i: number = 0; i < n; ++i) {
            father[i] = i;
        }
    }
    // 并查集里寻根的过程
    function find (u: number): number {
        return u === father[u] ? u : father[u] = find(father[u]);
    }
    // 将v->u 这条边加入并查集
    function join(u: number, v: number) {
        u = find(u);
        v = find(v);
        if (u === v) return ;
        father[v] = u;
    }
    // 判断 u 和 v是否找到同一个根
    function same(u: number, v: number): boolean {
        u = find(u);
        v = find(v);
        return u === v;
    }
```

Java：

### Python：

#### 二分查找法 
```python 
def binarysearch(nums, target):
    low = 0
    high = len(nums) - 1
    while (low <= high):
        mid = (high + low)//2

        if (nums[mid] < target):
            low = mid + 1
            
        if (nums[mid] > target):
            high = mid - 1
            
        if (nums[mid] == target):
            return mid

    return -1
```

#### KMP

```python 
def kmp(self, a, s):
    # a: length of the array
    # s: string 
    
    next = [0]*a
    j = 0    
    next[0] = 0
 
    for i in range(1, len(s)):
        while j > 0 and s[j] != s[i]:
            j = next[j - 1]
            
        if s[j] == s[i]:
            j += 1
        next[i] = j
    return next 
```


Go：




