/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

final class ConstructorCache {
    Map map;
    static final Entry noCache = new NoCache();
    static /* synthetic */ Class class$php$java$bridge$PhpArray;

    private void init() {
        this.map = new HashMap();
    }

    public ConstructorCache() {
        this.init();
    }

    public Constructor get(Entry entry) {
        if (entry == noCache) {
            return null;
        }
        CachedConstructor cachedConstructor = (CachedConstructor)this.map.get(entry);
        if (cachedConstructor == null) {
            return null;
        }
        entry.setMethod(cachedConstructor);
        return cachedConstructor.get();
    }

    public void put(Entry entry, Constructor constructor) {
        if (entry != noCache) {
            CachedConstructor cachedConstructor = new CachedConstructor(constructor);
            entry.setMethod(cachedConstructor);
            this.map.put(entry, cachedConstructor);
        }
    }

    public Entry getEntry(String string, Object[] objectArray) {
        Class[] classArray = new Class[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            Class<?> clazz = objectArray[i] == null ? null : objectArray[i].getClass();
            if (clazz == (class$php$java$bridge$PhpArray == null ? ConstructorCache.class$("php.java.bridge.PhpArray") : class$php$java$bridge$PhpArray)) {
                return noCache;
            }
            classArray[i] = clazz;
        }
        return new Entry(string, classArray);
    }

    public void clear() {
        this.init();
    }

    private static final class NoCache
    extends Entry {
        private NoCache() {
        }

        public Class[] getParameterTypes(Constructor constructor) {
            return constructor.getParameterTypes();
        }
    }

    public static class Entry {
        String name;
        Class[] params;
        private boolean hasResult = false;
        private int result = 1;
        private CachedConstructor cache;

        protected Entry() {
        }

        protected Entry(String string, Class[] classArray) {
            this.name = string;
            this.params = classArray;
        }

        public int hashCode() {
            if (this.hasResult) {
                return this.result;
            }
            for (int i = 0; i < this.params.length; ++i) {
                this.result = this.result * 31 + (this.params[i] == null ? 0 : this.params[i].hashCode());
            }
            this.result = this.result * 31 + this.name.hashCode();
            this.hasResult = true;
            return this.result;
        }

        public boolean equals(Object object) {
            Entry entry = (Entry)object;
            if (this.params.length != entry.params.length) {
                return false;
            }
            if (!this.name.equals(entry.name)) {
                return false;
            }
            for (int i = 0; i < this.params.length; ++i) {
                if (this.params[i] == entry.params[i]) continue;
                return false;
            }
            return true;
        }

        public void setMethod(CachedConstructor cachedConstructor) {
            this.cache = cachedConstructor;
        }

        public Class[] getParameterTypes(Constructor constructor) {
            return this.cache.getParameterTypes();
        }
    }

    private static class CachedConstructor {
        private Constructor method;
        private Class[] typeCache;

        public CachedConstructor(Constructor constructor) {
            this.method = constructor;
        }

        public Constructor get() {
            return this.method;
        }

        public Class[] getParameterTypes() {
            if (this.typeCache != null) {
                return this.typeCache;
            }
            this.typeCache = this.method.getParameterTypes();
            return this.typeCache;
        }
    }
}

