/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge;

import java.io.IOException;
import java.net.Socket;
import php.java.bridge.ISocketFactory;
import php.java.bridge.JavaBridge;
import php.java.bridge.LocalSocket;
import php.java.bridge.Util;

class LocalServerSocket
implements ISocketFactory {
    public static final String DefaultSocketname = "/var/run/.php-java-bride_socket";
    private String name;
    private int peer;

    public static ISocketFactory create(int n, String string, int n2) throws IOException {
        if (string == null) {
            string = DefaultSocketname;
        }
        if (string.startsWith("INET:") || string.startsWith("INET_LOCAL:")) {
            return null;
        }
        return new LocalServerSocket(n, string == null ? DefaultSocketname : string, n2);
    }

    private LocalServerSocket(int n, String string, int n2) throws IOException {
        if (string.startsWith("LOCAL:")) {
            string = string.substring(6);
        }
        this.name = string;
        if (Util.IS_MONO || 0 == (this.peer = JavaBridge.startNative(n, n2, string))) {
            throw new IOException("Unix domain sockets not available.");
        }
    }

    public void close() throws IOException {
        JavaBridge.sclose(this.peer);
    }

    public Socket accept() throws IOException {
        int n = JavaBridge.accept(this.peer);
        return new LocalSocket(n);
    }

    public String getSocketName() {
        return this.name;
    }

    public String toString() {
        return "LOCAL:" + this.getSocketName();
    }
}

