/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import php.java.bridge.ISession;
import php.java.bridge.JavaBridge;
import php.java.bridge.JavaBridgeFactory;
import php.java.bridge.Session;
import php.java.bridge.SimpleJavaBridgeClassLoader;
import php.java.bridge.Util;
import php.java.bridge.http.IContext;

public class SessionFactory
extends JavaBridgeFactory {
    public static final long TIMER_DURATION = 600L;
    private static final SessionTimer timer = new SessionTimer();
    static /* synthetic */ Class class$php$java$bridge$SessionFactory;

    public SimpleJavaBridgeClassLoader getJavaBridgeClassLoader() {
        if (this.javaBridgeClassLoader != null) {
            return this.javaBridgeClassLoader;
        }
        this.javaBridgeClassLoader = new SimpleJavaBridgeClassLoader(this.getClassLoader());
        return this.javaBridgeClassLoader;
    }

    public ClassLoader getClassLoader() {
        return Util.getContextClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ISession session(String string, boolean bl, int n) {
        HashMap hashMap = JavaBridge.sessionHash;
        synchronized (hashMap) {
            Session session = null;
            if (!JavaBridge.sessionHash.containsKey(string)) {
                session = new Session(string);
                JavaBridge.sessionHash.put(string, session);
            } else {
                session = (Session)JavaBridge.sessionHash.get(string);
                if (bl) {
                    session.destroy();
                    session = new Session(string);
                    JavaBridge.sessionHash.put(string, session);
                } else {
                    session.isNew = false;
                }
            }
            session.setTimeout(n);
            return session;
        }
    }

    public ISession getSession(String string, boolean bl, int n) {
        string = string == null ? "PHPSESSION" : "@" + string;
        return this.session(string, bl, n);
    }

    public ISession getSession(boolean bl, int n) {
        String string = "INTERNAL_PHPSESSION";
        return this.session(string, bl, n);
    }

    public IContext getContext() {
        return null;
    }

    protected static final SessionTimer getTimer() {
        return timer;
    }

    public static final void destroyTimer() {
        SessionFactory.getTimer().interrupt();
    }

    protected static class SessionTimer
    implements Runnable {
        private List jobs = Collections.synchronizedList(new LinkedList());
        private Util.Thread thread = new Util.Thread(this, "JavaBridgeSessionTimer");

        public SessionTimer() {
            this.thread.start();
        }

        public void addJob(Runnable runnable) {
            this.jobs.add(runnable);
        }

        public void interrupt() {
            if (Util.logLevel > 5) {
                System.out.println("lifecycle: sending session timer interrupt " + System.identityHashCode(class$php$java$bridge$SessionFactory == null ? (class$php$java$bridge$SessionFactory = SessionFactory.class$("php.java.bridge.SessionFactory")) : class$php$java$bridge$SessionFactory));
            }
            this.thread.interrupt();
        }

        public void run() {
            block5: {
                try {
                    while (!Thread.interrupted()) {
                        Util.Thread.sleep(600L);
                        Session.expire();
                        Iterator iterator = this.jobs.iterator();
                        while (iterator.hasNext()) {
                            Runnable runnable = (Runnable)iterator.next();
                            runnable.run();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (Util.logLevel <= 5) break block5;
                    System.out.println("lifecycle: session timer got interrupt" + System.identityHashCode(class$php$java$bridge$SessionFactory == null ? (class$php$java$bridge$SessionFactory = SessionFactory.class$("php.java.bridge.SessionFactory")) : class$php$java$bridge$SessionFactory));
                }
            }
            if (Util.logLevel > 5) {
                System.out.println("lifecycle: session timer terminating" + System.identityHashCode(class$php$java$bridge$SessionFactory == null ? (class$php$java$bridge$SessionFactory = SessionFactory.class$("php.java.bridge.SessionFactory")) : class$php$java$bridge$SessionFactory));
            }
        }
    }
}

