/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge;

import java.io.IOException;
import php.java.bridge.DynamicJavaBridgeClassLoader;
import php.java.bridge.JarLibraryPath;
import php.java.bridge.JavaBridge;
import php.java.bridge.Util;

public class SimpleJavaBridgeClassLoader {
    protected DynamicJavaBridgeClassLoader cl = null;
    protected ClassLoader scl = null;
    protected JarLibraryPath cachedPath;

    public static final ClassLoader getContextClassLoader() {
        ClassLoader classLoader = null;
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (classLoader == null) {
            classLoader = JavaBridge.class.getClassLoader();
        }
        return classLoader;
    }

    private SimpleJavaBridgeClassLoader(DynamicJavaBridgeClassLoader dynamicJavaBridgeClassLoader, ClassLoader classLoader) {
        this.cl = dynamicJavaBridgeClassLoader;
        if (this.cl == null) {
            this.scl = classLoader;
        } else {
            this.cl.clear();
        }
    }

    public SimpleJavaBridgeClassLoader(ClassLoader classLoader) {
        this(null, classLoader);
    }

    protected boolean checkCl() {
        return this.cl != null;
    }

    protected void setClassLoader(DynamicJavaBridgeClassLoader dynamicJavaBridgeClassLoader) {
        if (dynamicJavaBridgeClassLoader == null) {
            this.cachedPath = null;
            this.cl = null;
            return;
        }
        if (this.cl != null) {
            throw new IllegalStateException("cl");
        }
        this.cl = dynamicJavaBridgeClassLoader;
        if (this.cachedPath != null) {
            this.cl.updateJarLibraryPath(this.cachedPath);
        }
    }

    public void updateJarLibraryPath(String string, String string2, String string3, String string4) throws IOException {
        if (!this.checkCl()) {
            DynamicJavaBridgeClassLoader dynamicJavaBridgeClassLoader = DynamicJavaBridgeClassLoader.newInstance(this.scl);
            this.setClassLoader(dynamicJavaBridgeClassLoader);
            try {
                Thread.currentThread().setContextClassLoader(this.getClassLoader());
            }
            catch (SecurityException securityException) {
                Util.printStackTrace(securityException);
            }
        }
        this.cl.updateJarLibraryPath(string, string2, string3, string4);
    }

    public ClassLoader getClassLoader() {
        if (this.checkCl()) {
            return this.cl;
        }
        return this.scl;
    }

    public ClassLoader getDefaultClassLoader() {
        return this.scl;
    }

    protected void doReset() {
        this.cl.reset();
        this.cl = this.cl.clearVMLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.cl);
        }
        catch (SecurityException securityException) {
            Util.printStackTrace(securityException);
        }
    }

    public void reset() {
        if (this.checkCl()) {
            this.doReset();
        }
    }

    public Class forName(String string) throws ClassNotFoundException {
        if (!this.checkCl()) {
            return Class.forName(string, false, this.scl);
        }
        return Class.forName(string, false, this.cl);
    }

    protected void doClear() {
        this.cl.clear();
    }

    public void clear() {
        if (this.checkCl()) {
            this.doClear();
        }
    }

    protected void recycle() {
        this.cl = null;
        this.cachedPath = null;
        try {
            Thread.currentThread().setContextClassLoader(this.scl);
        }
        catch (SecurityException securityException) {
            Util.printStackTrace(securityException);
        }
    }

    public void switcheThreadContextClassLoader() {
        throw new IllegalStateException("Use the JavaBridgeClassLoader instead");
    }
}

