/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import php.java.bridge.AppThreadPool;
import php.java.bridge.Util;
import php.java.bridge.http.AbstractChannel;
import php.java.bridge.http.AbstractChannelName;
import php.java.bridge.http.ContextFactory;
import php.java.bridge.http.ContextRunner;
import php.java.bridge.http.IContextServer;

public class PipeContextServer
implements IContextServer {
    protected AppThreadPool threadPool;
    protected ContextFactory.ICredentials contextServer;
    private boolean isAvailable = true;
    protected String contextName;
    private static final boolean pipeServer = !Util.JAVABRIDGE_PROMISCUOUS && PipeContextServer.checkTestTunnel("php.java.bridge.no_pipe_server");

    public PipeContextServer(ContextFactory.ICredentials iCredentials, AppThreadPool appThreadPool, String string) {
        this.contextServer = iCredentials;
        this.threadPool = appThreadPool;
        this.contextName = string;
    }

    public boolean start(AbstractChannelName abstractChannelName) {
        if (!this.isAvailable()) {
            return false;
        }
        try {
            ContextRunner contextRunner = new ContextRunner(this.contextServer, new Channel(abstractChannelName.getName()));
            if (this.threadPool != null) {
                this.threadPool.start(contextRunner);
            } else {
                Util.Thread thread = new Util.Thread(contextRunner, "JavaBridgeContextRunner(" + this.contextName + ")");
                thread.start();
            }
        }
        catch (SecurityException securityException) {
            ContextFactory.destroyAll();
            Util.printStackTrace(securityException);
            this.isAvailable = false;
            return false;
        }
        catch (Throwable throwable) {
            Util.printStackTrace(throwable);
            this.isAvailable = false;
            return false;
        }
        return true;
    }

    public void destroy() {
    }

    protected static boolean checkTestTunnel(String string) {
        try {
            return !"true".equals(System.getProperty(string));
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public boolean isAvailable() {
        return pipeServer && this.isAvailable;
    }

    protected static class Channel
    extends AbstractChannel {
        protected InputStream in = null;
        protected OutputStream out = null;
        private String channelName;
        protected ContextRunner runner;

        protected Channel(String string, InputStream inputStream, OutputStream outputStream) {
            this(string);
            this.in = inputStream;
            this.out = outputStream;
        }

        protected Channel(String string) {
            this.channelName = string;
        }

        public InputStream getInputStream() throws FileNotFoundException {
            if (this.in != null) {
                return this.in;
            }
            this.in = new FileInputStream(new File(this.channelName + ".o"));
            return this.in;
        }

        public OutputStream getOuptutStream() throws FileNotFoundException {
            if (this.out != null) {
                return this.out;
            }
            this.out = new FileOutputStream(new File(this.channelName + ".i"));
            return this.out;
        }

        protected static void shutdown(InputStream inputStream, OutputStream outputStream) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public void shutdown() {
            Channel.shutdown(this.in, this.out);
        }

        public String getName() {
            return this.channelName;
        }
    }
}

