/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Map;
import java.util.jar.JarFile;
import php.java.bridge.DynamicJarURLConnection;
import php.java.bridge.Util;

class DynamicHttpURLConnectionHandler
extends URLStreamHandler {
    private JarFile jarFile;
    private File baseFile;
    private Map headerFields;

    public DynamicHttpURLConnectionHandler() {
        if (Util.logLevel > 4) {
            Util.logDebug("tempfile create DynamicHttpURLConnectionHander " + this);
        }
    }

    protected URLConnection openConnection(URL uRL) throws IOException {
        return new DynamicJarURLConnection(uRL, this);
    }

    public void deleteTempFile() {
        if (Util.logLevel > 4) {
            Util.logDebug("classloader tempfile deleted: " + this.baseFile + " handler: " + this);
        }
        this.baseFile.delete();
    }

    public Map getHeaderFields() {
        return this.headerFields;
    }

    public JarFile getTempFile() {
        return this.jarFile;
    }

    public void setTempFile(JarFile jarFile, File file) {
        if (Util.logLevel > 4) {
            Util.logDebug("classloader tempfile created: " + file + " handler" + this);
        }
        this.jarFile = jarFile;
        this.baseFile = file;
    }

    public void setHeaderFields(Map map) {
        this.headerFields = map;
    }
}

