/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge;

import java.security.Permission;
import php.java.bridge.AppThreadPool;

public class JavaBridgeSecurityManager
extends SecurityManager {
    protected static final Permission MODIFY_THREADGROUP_PERMISSION = new RuntimePermission("modifyThreadGroup");
    protected static final Permission MODIFY_THREAD_PERMISSION = new RuntimePermission("modifyThread");

    public void checkAccess(ThreadGroup threadGroup) {
        if (threadGroup == null) {
            throw new NullPointerException("thread group can't be null");
        }
        if (threadGroup instanceof AppThreadPool.Group && ((AppThreadPool.Group)threadGroup).isLocked) {
            this.checkPermission(MODIFY_THREADGROUP_PERMISSION);
        } else if (threadGroup instanceof AppThreadPool.AppGroup) {
            this.checkPermission(MODIFY_THREADGROUP_PERMISSION);
        }
    }

    public ThreadGroup getThreadGroup() {
        try {
            AppThreadPool.Delegate delegate = (AppThreadPool.Delegate)Thread.currentThread();
            return delegate.getAppGroup();
        }
        catch (ClassCastException classCastException) {
            return super.getThreadGroup();
        }
    }

    public void checkExit(int n) {
        throw new SecurityException("exitVM disabled by JavaBridgeSecurityManager.java");
    }
}

