/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

final class MethodCache {
    Map map;
    static final Entry noCache = new NoCache();
    static /* synthetic */ Class class$php$java$bridge$PhpArray;

    private void init() {
        this.map = new HashMap();
    }

    public MethodCache() {
        this.init();
    }

    public Method get(Entry entry) {
        if (entry == noCache) {
            return null;
        }
        CachedMethod cachedMethod = (CachedMethod)this.map.get(entry);
        if (cachedMethod == null) {
            return null;
        }
        entry.setMethod(cachedMethod);
        return cachedMethod.get();
    }

    public void put(Entry entry, Method method) {
        if (entry != noCache) {
            CachedMethod cachedMethod = new CachedMethod(method);
            entry.setMethod(cachedMethod);
            this.map.put(entry, cachedMethod);
        }
    }

    public Entry getEntry(String string, Object object, Object[] objectArray) {
        Class[] classArray = new Class[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            Class<?> clazz = objectArray[i] == null ? null : objectArray[i].getClass();
            if (clazz == (class$php$java$bridge$PhpArray == null ? MethodCache.class$("php.java.bridge.PhpArray") : class$php$java$bridge$PhpArray)) {
                return noCache;
            }
            classArray[i] = clazz;
        }
        return new Entry(string, object, classArray);
    }

    public void clear() {
        this.init();
    }

    private static final class NoCache
    extends Entry {
        private NoCache() {
        }

        public Class[] getParameterTypes(Method method) {
            return method.getParameterTypes();
        }
    }

    public static class Entry {
        boolean isStatic;
        String name;
        Class clazz;
        Class[] params;
        private boolean hasResult = false;
        private int result = 1;
        private CachedMethod cache;

        protected Entry() {
        }

        protected Entry(String string, Object object, Class[] classArray) {
            this.name = string;
            boolean bl = object instanceof Class;
            this.clazz = bl ? (Class<?>)object : object.getClass();
            this.isStatic = bl;
            this.params = classArray;
        }

        public int hashCode() {
            if (this.hasResult) {
                return this.result;
            }
            for (int i = 0; i < this.params.length; ++i) {
                this.result = this.result * 31 + (this.params[i] == null ? 0 : this.params[i].hashCode());
            }
            this.result = this.result * 31 + this.clazz.hashCode();
            this.result = this.result * 31 + this.name.hashCode();
            this.result = this.result * 31 + (this.isStatic ? 1231 : 1237);
            this.hasResult = true;
            return this.result;
        }

        public boolean equals(Object object) {
            Entry entry = (Entry)object;
            if (this.clazz != entry.clazz) {
                return false;
            }
            if (this.isStatic != entry.isStatic) {
                return false;
            }
            if (this.params.length != entry.params.length) {
                return false;
            }
            if (!this.name.equals(entry.name)) {
                return false;
            }
            for (int i = 0; i < this.params.length; ++i) {
                if (this.params[i] == entry.params[i]) continue;
                return false;
            }
            return true;
        }

        public void setMethod(CachedMethod cachedMethod) {
            this.cache = cachedMethod;
        }

        public Class[] getParameterTypes(Method method) {
            return this.cache.getParameterTypes();
        }
    }

    private static class CachedMethod {
        private Method method;
        private Class[] typeCache;

        public CachedMethod(Method method) {
            this.method = method;
        }

        public Method get() {
            return this.method;
        }

        public Class[] getParameterTypes() {
            if (this.typeCache != null) {
                return this.typeCache;
            }
            this.typeCache = this.method.getParameterTypes();
            return this.typeCache;
        }
    }
}

