/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge;

import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import php.java.bridge.DefaultOptions;
import php.java.bridge.IDocHandler;
import php.java.bridge.JavaBridge;
import php.java.bridge.Options;
import php.java.bridge.ParserString;
import php.java.bridge.ParserTag;
import php.java.bridge.Util;

class Parser {
    static final int RECV_SIZE = 8192;
    static final int MAX_ARGS = 100;
    static final int SLEN = 256;
    static final short OK = 0;
    static final short PING = 1;
    static final short EOF = 2;
    static final short IO_ERROR = 3;
    IDocHandler handler;
    JavaBridge bridge;
    private boolean response = true;
    private ParserTag[] tag = null;
    private byte[] buf = new byte[8192];
    private int len = 256;
    private byte[] s = new byte[this.len];
    private byte ch;
    private static final short BEGIN = 0;
    private static final short KEY = 1;
    private static final short VAL = 2;
    private static final short ENTITY = 3;
    private static final short VOJD = 5;
    private static final short END = 6;
    short type = (short)5;
    private short level = 0;
    private short eof = 0;
    private short eor = 0;
    boolean in_dquote;
    boolean eot = false;
    private int clen = 0;
    private int c = 0;
    private int i = 0;
    private int i0 = 0;
    private int e;

    Parser(JavaBridge javaBridge, IDocHandler iDocHandler) {
        this.bridge = javaBridge;
        this.handler = iDocHandler;
        this.tag = new ParserTag[]{new ParserTag(1), new ParserTag(100), new ParserTag(100)};
    }

    void initOptions(byte by) {
        this.bridge.options = new Options();
        if ((by & 0x40) != 0) {
            this.bridge.options.updateOptions((byte)(by & 3));
        }
        if ((by & 0x80) != 0) {
            if (this.bridge.logLevel > 3 && this.bridge.logLevel != (by >> 2 & 7)) {
                this.bridge.logDebug("Client changed its request log level to: " + (by >> 2 & 7));
            }
            this.bridge.logLevel = by >> 2 & 7;
        }
    }

    short initOptions(InputStream inputStream) throws IOException {
        this.clen = Parser.read(inputStream, this.buf, 0, 8192);
        if (this.clen > 0) {
            this.ch = this.buf[this.c];
            switch (this.ch) {
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 32: 
                case 60: {
                    this.bridge.options = new DefaultOptions();
                    break;
                }
                case 0: {
                    return 1;
                }
                default: {
                    if (this.ch == 127) {
                        if (++this.c == this.clen) {
                            this.clen = Parser.read(inputStream, this.buf, 0, 8192);
                            if (this.clen <= 0) {
                                throw new IllegalArgumentException("Illegal header length");
                            }
                            this.c = 0;
                            this.ch = this.buf[0];
                        } else {
                            this.ch = this.buf[this.c];
                        }
                    } else {
                        throw new IllegalArgumentException("Illegal header.");
                    }
                    this.initOptions(this.ch);
                    ++this.c;
                    break;
                }
            }
        } else {
            return 2;
        }
        return 0;
    }

    private static int read(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        try {
            return inputStream.read(byArray, n, n2);
        }
        catch (SocketException socketException) {
            if (Util.logLevel > 5) {
                Util.printStackTrace(socketException);
            }
            return -1;
        }
    }

    void RESET() {
        this.type = (short)5;
        this.level = 0;
        this.eor = 0;
        this.in_dquote = false;
        this.i = 0;
        this.i0 = 0;
    }

    void APPEND(byte by) {
        if (this.i >= this.len - 1) {
            int n = this.len * 2;
            byte[] byArray = new byte[n];
            System.arraycopy(this.s, 0, byArray, 0, this.len);
            this.len = n;
            this.s = byArray;
        }
        this.s[this.i++] = by;
    }

    void CALL_BEGIN() {
        if (this.bridge.logLevel >= 4) {
            StringBuffer stringBuffer = new StringBuffer("--> <");
            stringBuffer.append(this.tag[0].strings[0].getUTF8StringValue());
            stringBuffer.append(" ");
            for (int i = 0; i < this.tag[1].n; ++i) {
                stringBuffer.append(this.tag[1].strings[i].getUTF8StringValue());
                stringBuffer.append("=\"");
                stringBuffer.append(this.tag[2].strings[i].getUTF8StringValue());
                stringBuffer.append("\" ");
            }
            stringBuffer.append(this.eot ? "/>" : ">");
            this.eot = false;
            this.bridge.logDebug(stringBuffer.toString());
        }
        this.response = this.handler.begin(this.tag);
    }

    void CALL_END() {
        if (this.bridge.logLevel >= 4) {
            StringBuffer stringBuffer = new StringBuffer("--> </");
            stringBuffer.append(this.tag[0].strings[0].getUTF8StringValue());
            stringBuffer.append(">");
            this.bridge.logDebug(stringBuffer.toString());
        }
        this.handler.end(this.tag[0].strings);
    }

    void PUSH(int n) {
        ParserString[] parserStringArray = this.tag[n].strings;
        short s = this.tag[n].n;
        this.s[this.i] = 0;
        if (parserStringArray[s] == null) {
            parserStringArray[s] = this.createParserString();
        }
        parserStringArray[s].string = this.s;
        parserStringArray[s].off = this.i0;
        parserStringArray[s].length = this.i - this.i0;
        this.tag[n].n = (short)(this.tag[n].n + 1);
        this.APPEND((byte)0);
        this.i0 = this.i;
    }

    short parse(InputStream inputStream) throws IOException {
        if (this.eof != 0) {
            return 2;
        }
        while (this.eor == 0) {
            if (this.c == this.clen) {
                this.clen = Parser.read(inputStream, this.buf, 0, 8192);
                if (this.clen <= 0) {
                    this.eof = 2;
                    return 2;
                }
                this.c = 0;
            }
            this.ch = this.buf[this.c];
            switch (this.ch) {
                case 60: {
                    if (this.in_dquote) {
                        this.APPEND(this.ch);
                        break;
                    }
                    this.level = (short)(this.level + 1);
                    this.type = 0;
                    break;
                }
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 32: {
                    if (this.in_dquote) {
                        this.APPEND(this.ch);
                        break;
                    }
                    if (this.type != 0) break;
                    this.PUSH(this.type);
                    this.type = 1;
                    break;
                }
                case 61: {
                    if (this.in_dquote) {
                        this.APPEND(this.ch);
                        break;
                    }
                    this.PUSH(this.type);
                    this.type = (short)2;
                    break;
                }
                case 47: {
                    if (this.in_dquote) {
                        this.APPEND(this.ch);
                        break;
                    }
                    if (this.type == 0) {
                        this.type = (short)6;
                        this.level = (short)(this.level - 1);
                    }
                    this.level = (short)(this.level - 1);
                    this.eot = true;
                    break;
                }
                case 62: {
                    if (this.in_dquote) {
                        this.APPEND(this.ch);
                        break;
                    }
                    if (this.type == 6) {
                        this.PUSH(0);
                        this.CALL_END();
                    } else {
                        if (this.type == 2) {
                            this.PUSH(this.type);
                        }
                        this.CALL_BEGIN();
                    }
                    this.tag[2].n = 0;
                    this.tag[1].n = 0;
                    this.tag[0].n = 0;
                    this.i = 0;
                    this.i0 = 0;
                    this.type = (short)5;
                    if (this.level != 0 || !this.response) break;
                    this.eor = 1;
                    break;
                }
                case 59: {
                    if (this.type == 3) {
                        switch (this.s[this.e + 1]) {
                            case 108: {
                                this.s[this.e] = 60;
                                this.i = this.e + 1;
                                break;
                            }
                            case 103: {
                                this.s[this.e] = 62;
                                this.i = this.e + 1;
                                break;
                            }
                            case 97: {
                                this.s[this.e] = (byte)(this.s[this.e + 2] == 109 ? 38 : 39);
                                this.i = this.e + 1;
                                break;
                            }
                            case 113: {
                                this.s[this.e] = 34;
                                this.i = this.e + 1;
                                break;
                            }
                            default: {
                                this.APPEND(this.ch);
                            }
                        }
                        this.type = (short)2;
                        break;
                    }
                    this.APPEND(this.ch);
                    break;
                }
                case 38: {
                    this.type = (short)3;
                    this.e = this.i;
                    this.APPEND(this.ch);
                    break;
                }
                case 34: {
                    boolean bl = this.in_dquote = !this.in_dquote;
                    if (this.in_dquote || this.type != 2) break;
                    this.PUSH(this.type);
                    this.type = 1;
                    break;
                }
                case 127: {
                    if (this.in_dquote) {
                        this.APPEND(this.ch);
                        break;
                    }
                    this.c = this.handler.parseHeader(this.buf, this.c);
                    break;
                }
                default: {
                    this.APPEND(this.ch);
                }
            }
            ++this.c;
        }
        this.RESET();
        return 0;
    }

    public void reset() {
        this.eof = 0;
        this.clen = 0;
        this.c = 0;
        this.len = 256;
        this.s = new byte[this.len];
    }

    public void setBridge(JavaBridge javaBridge) {
        this.bridge = javaBridge;
    }

    private ParserString createParserString() {
        return new ParserString(this.bridge);
    }
}

