/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import php.java.bridge.JavaBridge;
import php.java.bridge.Response;
import php.java.bridge.Util;

class HexOutputBuffer
extends ByteArrayOutputStream {
    private final JavaBridge bridge;
    private byte[] buf = new byte[16];

    HexOutputBuffer(JavaBridge bridge) {
        this.bridge = bridge;
    }

    protected byte[] getFirstBytes() {
        byte[] append;
        int c = this.count;
        byte[] byArray = append = c > 256 ? Response.append_for_OutBuf_getFirstBytes : Response.append_none_for_OutBuf_getFirstBytes;
        if (c > 256) {
            c = 256;
        }
        byte[] ret = new byte[c + append.length];
        System.arraycopy(((ByteArrayOutputStream)this).buf, 0, ret, 0, c);
        System.arraycopy(append, 0, ret, ret.length - append.length, append.length);
        return ret;
    }

    protected void append(byte[] s) {
        try {
            this.write(s);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void appendQuoted(byte[] s) {
        block4: for (int i = 0; i < s.length; ++i) {
            byte ch = s[i];
            switch (ch) {
                case 38: {
                    this.append(Response.amp);
                    continue block4;
                }
                case 34: {
                    this.append(Response.quote);
                    continue block4;
                }
                default: {
                    this.write(ch);
                }
            }
        }
    }

    protected void appendQuoted(String s) {
        this.appendQuoted(this.bridge.options.getBytes(s));
    }

    protected void append(long i) {
        int pos = 16;
        do {
            this.buf[--pos] = Util.HEX_DIGITS[(int)(i & 0xFL)];
        } while ((i >>>= 4) != 0L);
        this.write(this.buf, pos, 16 - pos);
    }

    protected void append(double d) {
        this.append(Double.toString(d).getBytes());
    }

    protected void appendLong(long l) {
        this.append(Response.L);
        if (l < 0L) {
            this.append(-l);
            this.append(Response.pa);
        } else {
            this.append(l);
            this.append(Response.po);
        }
    }

    protected void appendString(byte[] s) {
        this.append(Response.S);
        this.appendQuoted(s);
    }
}

