/*
 * Decompiled with CFR 0.152.
 */
package php.java.script;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import php.java.bridge.ILogger;
import php.java.bridge.Util;
import php.java.bridge.http.FCGIConnectException;
import php.java.bridge.http.FCGIConnection;
import php.java.bridge.http.FCGIConnectionFactory;
import php.java.bridge.http.FCGIConnectionPool;
import php.java.bridge.http.FCGIIOFactory;
import php.java.bridge.http.FCGIInputStream;
import php.java.bridge.http.FCGIOutputStream;
import php.java.bridge.http.FCGIUtil;
import php.java.bridge.http.HeaderParser;
import php.java.bridge.http.IFCGIProcess;
import php.java.bridge.http.IFCGIProcessFactory;
import php.java.bridge.http.OutputStreamFactory;
import php.java.script.Continuation;
import php.java.script.FCGIProcess;
import php.java.script.ResultProxy;

public class FastCGIProxy
extends Continuation
implements IFCGIProcessFactory {
    private static final String PROCESSES = Util.THREAD_POOL_MAX_SIZE;
    private static final String MAX_REQUESTS = "5000";
    private static final String CGI_DIR = Util.TMPDIR.getAbsolutePath();
    private static final boolean PHP_INCLUDE_JAVA = false;
    private FCGIConnectionFactory channelName;
    static final HashMap PROCESS_ENVIRONMENT = FastCGIProxy.getProcessEnvironment();
    private final FCGIIOFactory defaultPoolFactory = new FCGIIOFactory(){

        public InputStream createInputStream() {
            return new FCGIInputStream((IFCGIProcessFactory)FastCGIProxy.this);
        }

        public OutputStream createOutputStream() {
            return new FCGIOutputStream();
        }

        public FCGIConnection connect(FCGIConnectionFactory name) throws FCGIConnectException {
            return name.connect();
        }
    };
    private static final Object globalCtxLock = new Object();
    private static FCGIConnectionPool fcgiConnectionPool = null;

    public FastCGIProxy(Reader reader, Map env, OutputStream out, OutputStream err, HeaderParser headerParser, ResultProxy resultProxy, ILogger logger) {
        super(env, out, err, headerParser, resultProxy);
    }

    private static HashMap getProcessEnvironment() {
        HashMap map = new HashMap(Util.COMMON_ENVIRONMENT);
        return map;
    }

    private FCGIConnectionPool createConnectionPool(int children) throws FCGIConnectException {
        this.channelName = FCGIConnectionFactory.createChannelFactory((IFCGIProcessFactory)this, (boolean)false);
        this.channelName.findFreePort(true);
        this.channelName.initialize();
        File cgiOsDir = Util.TMPDIR;
        File javaIncFile = new File(cgiOsDir, "launcher.sh");
        if (Util.USE_SH_WRAPPER) {
            try {
                if (!javaIncFile.exists()) {
                    Field f = Util.LAUNCHER_UNIX.getField("bytes");
                    byte[] buf = (byte[])f.get(Util.LAUNCHER_UNIX);
                    FileOutputStream out = new FileOutputStream(javaIncFile);
                    ((OutputStream)out).write(buf);
                    ((OutputStream)out).close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        File javaProxyFile = new File(cgiOsDir, "launcher.exe");
        if (!Util.USE_SH_WRAPPER) {
            try {
                if (!javaProxyFile.exists()) {
                    Field f = Util.LAUNCHER_WINDOWS.getField("bytes");
                    Field f2 = Util.LAUNCHER_WINDOWS2.getField("bytes");
                    Field f3 = Util.LAUNCHER_WINDOWS3.getField("bytes");
                    Field f4 = Util.LAUNCHER_WINDOWS4.getField("bytes");
                    byte[] buf = (byte[])f.get(Util.LAUNCHER_WINDOWS);
                    byte[] buf2 = (byte[])f2.get(Util.LAUNCHER_WINDOWS2);
                    byte[] buf3 = (byte[])f3.get(Util.LAUNCHER_WINDOWS3);
                    byte[] buf4 = (byte[])f4.get(Util.LAUNCHER_WINDOWS4);
                    FileOutputStream out = new FileOutputStream(javaProxyFile);
                    ((OutputStream)out).write(buf);
                    ((OutputStream)out).write(buf2);
                    ((OutputStream)out).write(buf3);
                    ((OutputStream)out).write(buf4);
                    ((OutputStream)out).close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Map map = (Map)PROCESS_ENVIRONMENT.clone();
        map.put("PHP_FCGI_CHILDREN", PROCESSES);
        map.put("PHP_FCGI_MAX_REQUESTS", MAX_REQUESTS);
        this.channelName.startServer(Util.getLogger());
        return new FCGIConnectionPool(this.channelName, children, Integer.parseInt(MAX_REQUESTS), this.defaultPoolFactory, (long)Integer.parseInt("-1"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupFastCGIServer() throws FCGIConnectException {
        Object object = globalCtxLock;
        synchronized (object) {
            if (null == fcgiConnectionPool) {
                Util.fcgiConnectionPool = fcgiConnectionPool = this.createConnectionPool(Integer.parseInt(PROCESSES));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRun() throws IOException, Util.Process.PhpException {
        byte[] buf = new byte[65535];
        this.setupFastCGIServer();
        FCGIInputStream natIn = null;
        FCGIOutputStream natOut = null;
        FCGIConnectionPool.Connection connection = null;
        try {
            connection = fcgiConnectionPool.openConnection();
            natOut = (FCGIOutputStream)connection.getOutputStream();
            natIn = (FCGIInputStream)connection.getInputStream();
            natOut.writeBegin();
            natOut.writeParams(this.env);
            natOut.write(5, FCGIUtil.FCGI_EMPTY_RECORD);
            natOut.close();
            natOut = null;
            HeaderParser.parseBody((byte[])buf, (InputStream)natIn, (OutputStreamFactory)new OutputStreamFactory(){

                public OutputStream getOutputStream() throws IOException {
                    return FastCGIProxy.this.out;
                }
            }, (HeaderParser)this.headerParser);
            natIn.close();
            natIn = null;
            connection = null;
        }
        catch (InterruptedException e) {
        }
        catch (Throwable t) {
            Util.printStackTrace((Throwable)t);
        }
        finally {
            if (connection != null) {
                connection.setIsClosed();
            }
            if (natIn != null) {
                try {
                    natIn.close();
                }
                catch (IOException e) {}
            }
            if (natOut != null) {
                try {
                    natOut.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public IFCGIProcess createFCGIProcess(String[] args, boolean includeJava, File home, Map env) throws IOException {
        return new FCGIProcess(args, includeJava, this.getCgiDir(), this.getPearDir(), this.getWebInfDir(), home, env, this.getCgiDir(), true, true);
    }

    public boolean canStartFCGI() {
        return true;
    }

    public String getCgiDir() {
        return CGI_DIR;
    }

    public HashMap getEnvironment() {
        return FastCGIProxy.getProcessEnvironment();
    }

    public String getPearDir() {
        return CGI_DIR;
    }

    public String getPhp() {
        return null;
    }

    public String getPhpConnectionPoolSize() {
        return PROCESSES;
    }

    public boolean getPhpIncludeJava() {
        return false;
    }

    public String getPhpMaxRequests() {
        return MAX_REQUESTS;
    }

    public String getWebInfDir() {
        return CGI_DIR;
    }

    public void log(String msg) {
        Util.logMessage((String)msg);
    }
}

