/*
 * Decompiled with CFR 0.152.
 */
package php.java.script;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Proxy;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.script.Bindings;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import php.java.bridge.PhpProcedure;
import php.java.bridge.Request;
import php.java.bridge.Util;
import php.java.bridge.http.IContext;
import php.java.script.AbstractPhpScriptEngine;
import php.java.script.PhpScriptEngineFactory;
import php.java.script.PhpScriptException;
import php.java.script.URLReader;

public class InvocablePhpScriptEngine
extends AbstractPhpScriptEngine
implements Invocable {
    private static final String X_JAVABRIDGE_INCLUDE = "X_JAVABRIDGE_INCLUDE";
    private static final String PHP_JAVA_CONTEXT_CALL_JAVA_CLOSURE = "<?php java_context()->call(java_closure()); ?>";
    protected static final Object EMPTY_INCLUDE = "@";
    private static boolean registeredHook = false;
    private static final List engines = new LinkedList();
    private static final String PHP_EMPTY_SCRIPT = "<?php ?>";

    public InvocablePhpScriptEngine() {
        this(new PhpScriptEngineFactory());
    }

    public InvocablePhpScriptEngine(PhpScriptEngineFactory factory) {
        super(factory);
    }

    public InvocablePhpScriptEngine(Bindings n) {
        this();
        this.setBindings(n, 100);
    }

    protected Object invoke(String methodName, Object[] args) throws ScriptException, NoSuchMethodException {
        if (methodName == null) {
            this.release();
            return null;
        }
        if (this.scriptClosure == null) {
            if (Util.logLevel > 4) {
                Util.warn((String)"Evaluating an empty script either because eval() has not been called or release() has been called.");
            }
            this.eval(PHP_EMPTY_SCRIPT);
        }
        try {
            return this.invoke(this.scriptClosure, methodName, args);
        }
        catch (Request.AbortException e) {
            this.release();
            throw new ScriptException((Exception)((Object)e));
        }
        catch (NoSuchMethodError e) {
            throw new NoSuchMethodException(String.valueOf(e.getMessage()));
        }
    }

    public Object invokeFunction(String methodName, Object[] args) throws ScriptException, NoSuchMethodException {
        return this.invoke(methodName, args);
    }

    private void checkPhpClosure(Object thiz) {
        if (thiz == null) {
            throw new IllegalStateException("PHP script did not pass its continuation to us!. Please check if the previous call to eval() reported any errors. Or else check if it called OUR continuation.");
        }
    }

    protected Object invoke(Object thiz, String methodName, Object[] args) throws ScriptException, NoSuchMethodException {
        this.checkPhpClosure(thiz);
        PhpProcedure proc = (PhpProcedure)Proxy.getInvocationHandler(thiz);
        try {
            return proc.invoke(this.script, methodName, args);
        }
        catch (ScriptException e) {
            throw e;
        }
        catch (NoSuchMethodException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (NoSuchMethodError e) {
            throw new NoSuchMethodException(String.valueOf(e.getMessage()));
        }
        catch (Error er) {
            throw er;
        }
        catch (Throwable e) {
            throw new PhpScriptException("Invocation threw exception ", e);
        }
    }

    public Object invokeMethod(Object thiz, String methodName, Object[] args) throws ScriptException, NoSuchMethodException {
        return this.invoke(thiz, methodName, args);
    }

    public Object getInterface(Class clasz) {
        this.checkPhpClosure(this.script);
        return this.getInterface(this.script, clasz);
    }

    public Object getInterface(Object thiz, Class clasz) {
        Class[] classArray;
        this.checkPhpClosure(thiz);
        if (clasz == null) {
            classArray = Util.ZERO_PARAM;
        } else {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = clasz;
        }
        Class[] interfaces = classArray;
        return PhpProcedure.createProxy((Class[])interfaces, (PhpProcedure)((PhpProcedure)Proxy.getInvocationHandler(thiz)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Reader getLocalReader(Reader reader, boolean embedJavaInc) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OutputStreamWriter w = new OutputStreamWriter(out);
        String stdHeader = embedJavaInc ? null : ((IContext)this.getContext()).getRedirectURL("/JavaBridge");
        Reader localReader = new StringReader(this.getStandardHeader(stdHeader));
        char[] buf = new char[8192];
        try {
            int c;
            while ((c = localReader.read(buf)) > 0) {
                ((Writer)w).write(buf, 0, c);
            }
            ((Reader)localReader).close();
            localReader = null;
            while ((c = reader.read(buf)) > 0) {
                ((Writer)w).write(buf, 0, c);
            }
            localReader = new StringReader(PHP_JAVA_CONTEXT_CALL_JAVA_CLOSURE);
            while ((c = localReader.read(buf)) > 0) {
                ((Writer)w).write(buf, 0, c);
            }
            ((Reader)localReader).close();
            localReader = null;
            ((Writer)w).close();
            w = null;
            Reader reader2 = localReader = new InputStreamReader(new ByteArrayInputStream(out.toByteArray()));
            return reader2;
        }
        finally {
            if (w != null) {
                try {
                    ((Writer)w).close();
                }
                catch (IOException e) {}
            }
        }
    }

    protected Object doEvalPhp(Reader reader, ScriptContext context) throws ScriptException {
        if (reader instanceof URLReader) {
            return this.eval((URLReader)reader, context);
        }
        if (this.continuation != null || reader == null) {
            this.release();
        }
        if (reader == null) {
            return null;
        }
        this.setNewContextFactory();
        this.env.put(X_JAVABRIDGE_INCLUDE, EMPTY_INCLUDE);
        Reader localReader = null;
        try {
            localReader = this.getLocalReader(reader, false);
            this.script = this.doEval(localReader, context);
            if (this.script != null) {
                this.scriptClosure = this.script;
            }
        }
        catch (Exception e) {
            Util.printStackTrace((Throwable)e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof ScriptException) {
                throw (ScriptException)e;
            }
            throw new ScriptException(e);
        }
        finally {
            if (localReader != null) {
                try {
                    localReader.close();
                }
                catch (IOException e) {}
            }
            this.handleRelease();
        }
        return this.resultProxy;
    }

    protected Object doEvalCompiledPhp(Reader reader, ScriptContext context) throws ScriptException {
        if (this.continuation != null || reader == null) {
            this.release();
        }
        if (reader == null) {
            return null;
        }
        this.setNewContextFactory();
        this.env.put(X_JAVABRIDGE_INCLUDE, EMPTY_INCLUDE);
        try {
            this.script = this.doEval(reader, context);
            if (this.script != null) {
                this.scriptClosure = this.script;
            }
        }
        catch (Exception e) {
            Util.printStackTrace((Throwable)e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof ScriptException) {
                throw (ScriptException)e;
            }
            throw new ScriptException(e);
        }
        finally {
            this.handleRelease();
        }
        return this.resultProxy;
    }

    protected Object eval(URLReader reader, ScriptContext context) throws ScriptException {
        if (this.continuation != null || reader == null) {
            this.release();
        }
        if (reader == null) {
            return null;
        }
        this.setNewContextFactory();
        this.env.put(X_JAVABRIDGE_INCLUDE, EMPTY_INCLUDE);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OutputStreamWriter w = new OutputStreamWriter(out);
        try {
            this.script = this.doEval(reader, context);
            if (this.script != null) {
                this.scriptClosure = this.script;
            }
        }
        catch (Exception e) {
            Util.printStackTrace((Throwable)e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof ScriptException) {
                throw (ScriptException)e;
            }
            throw new ScriptException(e);
        }
        finally {
            if (w != null) {
                try {
                    ((Writer)w).close();
                }
                catch (IOException e) {}
            }
            this.handleRelease();
        }
        return this.resultProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleRelease() {
        List list = engines;
        synchronized (list) {
            if (!registeredHook) {
                registeredHook = true;
                try {
                    Runtime.getRuntime().addShutdownHook((Thread)new Util.Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            if (engines == null) {
                                return;
                            }
                            List list = engines;
                            synchronized (list) {
                                Iterator ii = engines.iterator();
                                while (ii.hasNext()) {
                                    InvocablePhpScriptEngine e = (InvocablePhpScriptEngine)ii.next();
                                    e.releaseInternal();
                                    ii.remove();
                                }
                            }
                        }
                    });
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            engines.add(this);
        }
    }

    private void releaseInternal() {
        super.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        List list = engines;
        synchronized (list) {
            this.releaseInternal();
            engines.remove(this);
        }
    }
}

