/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

final class MethodCache {
    Map map;
    static final Entry noCache = new NoCache();
    static /* synthetic */ Class class$php$java$bridge$PhpArray;

    private void init() {
        this.map = new HashMap();
    }

    public MethodCache() {
        this.init();
    }

    public Method get(Entry entry) {
        if (entry == noCache) {
            return null;
        }
        CachedMethod cache = (CachedMethod)this.map.get(entry);
        if (cache == null) {
            return null;
        }
        entry.setMethod(cache);
        return cache.get();
    }

    public void put(Entry entry, Method method) {
        if (entry != noCache) {
            CachedMethod cache = new CachedMethod(method);
            entry.setMethod(cache);
            this.map.put(entry, cache);
        }
    }

    public Entry getEntry(String name, Object obj, Object[] args) {
        Class[] params = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            Class<?> c = args[i] == null ? null : args[i].getClass();
            if (c == (class$php$java$bridge$PhpArray == null ? MethodCache.class$("php.java.bridge.PhpArray") : class$php$java$bridge$PhpArray)) {
                return noCache;
            }
            params[i] = c;
        }
        return new Entry(name, obj, params);
    }

    public void clear() {
        this.init();
    }

    private static final class NoCache
    extends Entry {
        private NoCache() {
        }

        public Class[] getParameterTypes(Method method) {
            return method.getParameterTypes();
        }
    }

    public static class Entry {
        boolean isStatic;
        String name;
        Class clazz;
        Class[] params;
        private boolean hasResult = false;
        private int result = 1;
        private CachedMethod cache;

        protected Entry() {
        }

        protected Entry(String name, Object obj, Class[] params) {
            this.name = name;
            boolean isStatic = obj instanceof Class;
            this.clazz = isStatic ? (Class<?>)obj : obj.getClass();
            this.isStatic = isStatic;
            this.params = params;
        }

        public int hashCode() {
            if (this.hasResult) {
                return this.result;
            }
            for (int i = 0; i < this.params.length; ++i) {
                this.result = this.result * 31 + (this.params[i] == null ? 0 : this.params[i].hashCode());
            }
            this.result = this.result * 31 + this.clazz.hashCode();
            this.result = this.result * 31 + this.name.hashCode();
            this.result = this.result * 31 + (this.isStatic ? 1231 : 1237);
            this.hasResult = true;
            return this.result;
        }

        public boolean equals(Object o) {
            Entry that = (Entry)o;
            if (this.clazz != that.clazz) {
                return false;
            }
            if (this.isStatic != that.isStatic) {
                return false;
            }
            if (this.params.length != that.params.length) {
                return false;
            }
            if (!this.name.equals(that.name)) {
                return false;
            }
            for (int i = 0; i < this.params.length; ++i) {
                if (this.params[i] == that.params[i]) continue;
                return false;
            }
            return true;
        }

        public void setMethod(CachedMethod cache) {
            this.cache = cache;
        }

        public Class[] getParameterTypes(Method method) {
            return this.cache.getParameterTypes();
        }
    }

    private static class CachedMethod {
        private Method method;
        private Class[] typeCache;

        public CachedMethod(Method method) {
            this.method = method;
        }

        public Method get() {
            return this.method;
        }

        public Class[] getParameterTypes() {
            if (this.typeCache != null) {
                return this.typeCache;
            }
            this.typeCache = this.method.getParameterTypes();
            return this.typeCache;
        }
    }
}

