/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import php.java.bridge.ISession;
import php.java.bridge.JavaBridge;
import php.java.bridge.JavaBridgeFactory;
import php.java.bridge.Session;
import php.java.bridge.Util;
import php.java.bridge.http.IContext;

public class SessionFactory
extends JavaBridgeFactory {
    public static final long TIMER_DURATION = 36000000L;
    private static final SessionTimer timer = SessionFactory.getSessionTimer();
    static /* synthetic */ Class class$php$java$bridge$SessionFactory;

    private static SessionTimer getSessionTimer() {
        try {
            return new SessionTimer();
        }
        catch (Throwable e) {
            Util.printStackTrace(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ISession session(String name, short clientIsNew, int timeout) {
        HashMap hashMap = JavaBridge.sessionHash;
        synchronized (hashMap) {
            Session ref = null;
            if (!JavaBridge.sessionHash.containsKey(name)) {
                ref = new Session(name);
                JavaBridge.sessionHash.put(name, ref);
            } else {
                ref = (Session)JavaBridge.sessionHash.get(name);
                if (clientIsNew == 1) {
                    ref.destroy();
                    ref = new Session(name);
                    JavaBridge.sessionHash.put(name, ref);
                } else {
                    ref.isNew = false;
                }
            }
            ref.setTimeout(timeout);
            return ref;
        }
    }

    public ISession getSession(String name, short clientIsNew, int timeout) {
        name = name == null ? "PHPSESSION" : "@" + name;
        return this.session(name, clientIsNew, timeout);
    }

    public IContext getContext() {
        return null;
    }

    protected static final SessionTimer getTimer() {
        return timer;
    }

    public static final void destroyTimer() {
        SessionFactory.getTimer().interrupt();
    }

    public void flushBuffer() throws IOException {
        this.bridge.out.flush();
    }

    public void invalidate() {
    }

    protected static class SessionTimer
    implements Runnable {
        private List jobs = Collections.synchronizedList(new LinkedList());
        private Util.Thread thread = new Util.Thread(this, "JavaBridgeSessionTimer");

        public SessionTimer() {
            this.thread.start();
        }

        public void addJob(Runnable r) {
            this.jobs.add(r);
        }

        public void interrupt() {
            if (Util.logLevel > 5) {
                System.out.println("lifecycle: sending session timer interrupt " + System.identityHashCode(class$php$java$bridge$SessionFactory == null ? (class$php$java$bridge$SessionFactory = SessionFactory.class$("php.java.bridge.SessionFactory")) : class$php$java$bridge$SessionFactory));
            }
            this.thread.interrupt();
        }

        public void run() {
            block5: {
                try {
                    while (!Thread.interrupted()) {
                        Util.Thread.sleep(36000000L);
                        Session.expire();
                        Iterator ii = this.jobs.iterator();
                        while (ii.hasNext()) {
                            Runnable job = (Runnable)ii.next();
                            job.run();
                        }
                    }
                }
                catch (InterruptedException e) {
                    if (Util.logLevel <= 5) break block5;
                    System.out.println("lifecycle: session timer got interrupt" + System.identityHashCode(class$php$java$bridge$SessionFactory == null ? (class$php$java$bridge$SessionFactory = SessionFactory.class$("php.java.bridge.SessionFactory")) : class$php$java$bridge$SessionFactory));
                }
            }
            if (Util.logLevel > 5) {
                System.out.println("lifecycle: session timer terminating" + System.identityHashCode(class$php$java$bridge$SessionFactory == null ? (class$php$java$bridge$SessionFactory = SessionFactory.class$("php.java.bridge.SessionFactory")) : class$php$java$bridge$SessionFactory));
            }
        }
    }
}

