/*
 * Decompiled with CFR 0.152.
 */
package php.java.script;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import php.java.bridge.Util;
import php.java.bridge.http.HeaderParser;
import php.java.script.IContinuation;
import php.java.script.ResultProxy;

public abstract class Continuation
implements IContinuation,
Runnable {
    protected Map env;
    protected OutputStream out;
    protected OutputStream err;
    protected HeaderParser headerParser;
    protected ResultProxy resultProxy;
    private ScriptLock scriptLock = new ScriptLock();
    private Lock phpScript = new Lock();
    private Object lockObject = new Object();

    protected Continuation(Map env, OutputStream out, OutputStream err, HeaderParser headerParser, ResultProxy resultProxy) {
        this.env = env;
        this.out = out;
        this.err = err;
        this.headerParser = headerParser;
        this.resultProxy = resultProxy;
    }

    public void run() {
        try {
            this.doRun();
        }
        catch (IOException e) {
            this.phpScript.val = e;
        }
        catch (Util.Process.PhpException e1) {
            this.phpScript.val = (Object)e1;
        }
        catch (Exception ex) {
            this.phpScript.val = ex;
            Util.printStackTrace((Throwable)ex);
        }
        finally {
            this.phpScript.finish();
            this.scriptLock.finish();
        }
    }

    protected abstract void doRun() throws IOException, Util.Process.PhpException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void call(Object script) throws InterruptedException {
        Object object = this.lockObject;
        synchronized (object) {
            this.phpScript.setVal(script);
            this.lockObject.wait();
        }
    }

    public Object getPhpScript() throws Exception {
        Object val = this.phpScript.getVal();
        if (val instanceof Exception) {
            throw (Exception)val;
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() throws InterruptedException {
        Object object = this.lockObject;
        synchronized (object) {
            this.lockObject.notifyAll();
        }
        this.scriptLock.waitForRunner();
    }

    protected class Lock {
        private Object val = null;
        private boolean finish = false;

        protected Lock() {
        }

        public synchronized Object getVal() {
            if (!this.finish && this.val == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            return this.val;
        }

        public synchronized void setVal(Object val) {
            this.val = val;
            this.notify();
        }

        public synchronized void finish() {
            this.finish = true;
            this.notify();
        }
    }

    private static class ScriptLock {
        private boolean running = true;

        private ScriptLock() {
        }

        public synchronized void waitForRunner() throws InterruptedException {
            if (this.running) {
                this.wait();
            }
        }

        public synchronized void finish() {
            this.running = false;
            this.notify();
        }
    }
}

