/*
 * Decompiled with CFR 0.152.
 */
package php.java.script;

import java.util.Arrays;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import php.java.bridge.Util;
import php.java.script.CloseablePhpScriptEngine;
import php.java.script.PhpScriptEngine;

public class PhpScriptEngineFactory
implements ScriptEngineFactory {
    protected Factory factory;
    private static final String ENGINE_NAME = Util.EXTENSION_NAME + " php script engine for Java";
    List names;

    public PhpScriptEngineFactory() {
        try {
            Class.forName("java.io.Closeable");
            this.factory = new Factory(true);
        }
        catch (ClassNotFoundException e) {
            this.factory = new Factory(false);
        }
    }

    public String getEngineName() {
        return ENGINE_NAME;
    }

    public String getEngineVersion() {
        return Util.VERSION;
    }

    public String getLanguageName() {
        return "php";
    }

    public String getLanguageVersion() {
        return "6";
    }

    public List getExtensions() {
        return this.getNames();
    }

    public List getMimeTypes() {
        return Arrays.asList(new String[0]);
    }

    public List getNames() {
        if (this.names == null) {
            this.names = Arrays.asList(this.getLanguageName(), "phtml", "php4", "php5", "php6");
        }
        return this.names;
    }

    public ScriptEngine getScriptEngine() {
        return this.factory.create();
    }

    public Object getParameter(String key) {
        if (key.equals("javax.script.name")) {
            return this.getLanguageName();
        }
        if (key.equals("javax.script.engine")) {
            return this.getEngineName();
        }
        if (key.equals("javax.script.engine_version")) {
            return this.getEngineVersion();
        }
        if (key.equals("javax.script.language")) {
            return this.getLanguageName();
        }
        if (key.equals("javax.script.language_version")) {
            return this.getLanguageVersion();
        }
        if (key.equals("THREADING")) {
            return "STATELESS";
        }
        throw new IllegalArgumentException("key");
    }

    public String getMethodCallSyntax(String obj, String m, String[] args) {
        int i;
        StringBuffer b = new StringBuffer();
        b.append("$");
        b.append(obj);
        b.append("->");
        b.append(m);
        b.append("(");
        for (i = 0; i < args.length - 1; ++i) {
            b.append(args[i]);
            b.append(",");
        }
        b.append(args[i]);
        b.append(")");
        return b.toString();
    }

    public String getOutputStatement(String toDisplay) {
        return "echo(" + toDisplay + ")";
    }

    public String getProgram(String[] statements) {
        int i = 0;
        StringBuffer b = new StringBuffer("<?php ");
        for (i = 0; i < statements.length; ++i) {
            b.append(statements[i]);
            b.append(";");
        }
        b.append("?>");
        return b.toString();
    }

    protected class Factory {
        protected boolean hasCloseable;

        public Factory(boolean hasCloseable) {
            this.hasCloseable = hasCloseable;
        }

        public ScriptEngine create() {
            if (this.hasCloseable) {
                return new CloseablePhpScriptEngine(PhpScriptEngineFactory.this);
            }
            return new PhpScriptEngine(PhpScriptEngineFactory.this);
        }
    }
}

