/*
 * Decompiled with CFR 0.152.
 */
package php.java.servlet;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import javax.servlet.ServletContext;
import php.java.bridge.Util;
import php.java.bridge.util.Logger;
import php.java.fastcgi.FCGIHelper;
import php.java.servlet.ServletUtil;

public class FCGIServletHelper
extends FCGIHelper {
    public static final String PEAR_DIR = "/WEB-INF/pear";
    public static final String CGI_DIR = "/WEB-INF/cgi";
    public static final String WEB_INF_DIR = "/WEB-INF";
    private HashMap processEnvironment = new HashMap(Util.COMMON_ENVIRONMENT);

    public FCGIServletHelper() {
        this.php = null;
    }

    private String getRealPath(Object context, String str) {
        return ServletUtil.getRealPath((ServletContext)context, str);
    }

    public void createPhpFiles(Object context) {
        File readme;
        FileOutputStream out;
        byte[] data;
        File phpCgi;
        String javaDir = this.getRealPath(context, "java");
        if (javaDir != null) {
            File javaDirFile = new File(javaDir);
            try {
                if (!javaDirFile.exists()) {
                    javaDirFile.mkdir();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            File javaIncFile = new File(javaDir, "Java.inc");
            try {
                if (!javaIncFile.exists()) {
                    Field f = Util.JAVA_INC.getField("bytes");
                    byte[] buf = (byte[])f.get(Util.JAVA_INC);
                    FileOutputStream out2 = new FileOutputStream(javaIncFile);
                    ((OutputStream)out2).write(buf);
                    ((OutputStream)out2).close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            File phpDebuggerFile = new File(javaDir, "PHPDebugger.php");
            try {
                if (!phpDebuggerFile.exists()) {
                    Field f = Util.PHPDEBUGGER_PHP.getField("bytes");
                    byte[] buf = (byte[])f.get(Util.PHPDEBUGGER_PHP);
                    FileOutputStream out3 = new FileOutputStream(phpDebuggerFile);
                    ((OutputStream)out3).write(buf);
                    ((OutputStream)out3).close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.webInfDir = this.getRealPath(context, WEB_INF_DIR);
        this.pearDir = this.getRealPath(context, PEAR_DIR);
        if (this.pearDir != null) {
            File pearDirFile = new File(this.pearDir);
            try {
                if (!pearDirFile.exists()) {
                    pearDirFile.mkdir();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.cgiDir = this.getRealPath(context, CGI_DIR);
        File cgiOsDir = new File(this.getCgiDir(), Util.osArch + "-" + Util.osName);
        File conf = new File(cgiOsDir, "conf.d");
        File ext = new File(cgiOsDir, "ext");
        File cgiDirFile = new File(this.getCgiDir());
        try {
            if (!cgiDirFile.exists()) {
                cgiDirFile.mkdirs();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (!conf.exists()) {
                conf.mkdirs();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (!ext.exists()) {
                ext.mkdir();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.createLauncher(cgiOsDir.getParentFile());
        boolean exeExists = true;
        if (Util.USE_SH_WRAPPER) {
            try {
                phpCgi = new File(cgiOsDir, "php-cgi");
                if (!this.useSystemPhp(phpCgi)) {
                    File ini;
                    this.updateProcessEnvironment(conf);
                    File wrapper = new File(cgiOsDir, "php-cgi.sh");
                    if (!wrapper.exists()) {
                        data = "#!/bin/sh\nchmod +x ./php-cgi\nexec ./php-cgi \"$@\"".getBytes();
                        out = new FileOutputStream(wrapper);
                        ((OutputStream)out).write(data);
                        ((OutputStream)out).close();
                    }
                    if (!(ini = new File(cgiOsDir, "php-cgi.ini")).exists()) {
                        byte[] data2 = (";; -*- mode: Scheme; tab-width:4 -*-\n;; A simple php.ini\n;; DO NOT EDIT THIS FILE!\n;; Add your configuration files to the " + conf + " instead.\n;; PHP extensions go to " + ext + ". Please see phpinfo() for ABI version details.\nextension_dir=\"" + ext + "\"\ninclude_path=\"" + this.pearDir + ":/usr/share/pear:.\"\n").getBytes();
                        FileOutputStream out4 = new FileOutputStream(ini);
                        ((OutputStream)out4).write(data2);
                        ((OutputStream)out4).close();
                    }
                } else if (!phpCgi.exists()) {
                    exeExists = false;
                    readme = new File(cgiOsDir, "php-cgi.MISSING.README.txt");
                    if (!readme.exists()) {
                        data = "You can add \"php-cgi\" to this directory and re-deploy your web application.\n".getBytes();
                        out = new FileOutputStream(readme);
                        ((OutputStream)out).write(data);
                        ((OutputStream)out).close();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                phpCgi = new File(cgiOsDir, "php-cgi.exe");
                if (!this.useSystemPhp(phpCgi)) {
                    this.updateProcessEnvironment(conf);
                    File ini = new File(cgiOsDir, "php.ini");
                    if (!ini.exists()) {
                        data = (";; -*- mode: Scheme; tab-width:4 -*-\r\n;; A simple php.ini\r\n;; DO NOT EDIT THIS FILE!\r\n;; Add your configuration files to the " + conf + " instead.\r\n;; PHP extensions go to " + ext + ". Please see phpinfo() for ABI version details.\r\nextension_dir=\"" + ext + "\"\r\ninclude_path=\"" + this.pearDir + ";.\"\r\n").getBytes();
                        out = new FileOutputStream(ini);
                        ((OutputStream)out).write(data);
                        ((OutputStream)out).close();
                    }
                } else if (!phpCgi.exists()) {
                    exeExists = false;
                    readme = new File(cgiOsDir, "php-cgi.exe.MISSING.README.txt");
                    if (!readme.exists()) {
                        data = "You can add \"php-cgi.exe\" to this directory and re-deploy your web application.\r\n".getBytes();
                        out = new FileOutputStream(readme);
                        ((OutputStream)out).write(data);
                        ((OutputStream)out).close();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        File tmpl = new File(conf, "mysql.ini");
        if (exeExists && !tmpl.exists()) {
            String str = Util.USE_SH_WRAPPER ? ";; -*- mode: Scheme; tab-width:4 -*-\n;; Example extension.ini file: mysql.ini.\n;; Copy the correct version (see phpinfo()) of the PHP extension \"mysql.so\" to the ./../ext directory and uncomment the following line\n; extension = mysql.so\n" : ";; -*- mode: Scheme; tab-width:4 -*-\r\n;; Example extension.ini file: mysql.ini.\r\n;; Copy the correct version (see phpinfo()) of the PHP extension \"php_mysql.dll\" to the .\\..\\ext directory and uncomment the following line\r\n; extension = php_mysql.dll\r\n";
            data = str.getBytes();
            try {
                out = new FileOutputStream(tmpl);
                ((OutputStream)out).write(data);
                ((OutputStream)out).close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void updateProcessEnvironment(File conf) {
        try {
            this.processEnvironment.put("PHP_INI_SCAN_DIR", conf.getCanonicalPath());
        }
        catch (IOException e) {
            e.printStackTrace();
            this.processEnvironment.put("PHP_INI_SCAN_DIR", conf.getAbsolutePath());
        }
    }

    private boolean useSystemPhp(File f) {
        if (!this.phpTryOtherLocations) {
            return true;
        }
        if (!f.exists()) {
            return true;
        }
        if (!this.preferSystemPhp) {
            return false;
        }
        for (int i = 0; i < Util.DEFAULT_CGI_LOCATIONS.length; ++i) {
            File location = new File(Util.DEFAULT_CGI_LOCATIONS[i]);
            if (!location.exists()) continue;
            return true;
        }
        return false;
    }

    private void checkCgiBinary(ServletContext context) {
        if (this.php == null) {
            try {
                File f;
                String value = context.getInitParameter("php_exec");
                if (value == null || value.trim().length() == 0) {
                    value = "php-cgi";
                    this.phpTryOtherLocations = true;
                }
                if (!(f = new File(value)).isAbsolute()) {
                    value = ServletUtil.getRealPath(context, CGI_DIR) + File.separator + value;
                }
                this.php = value;
            }
            catch (Throwable t) {
                Logger.printStackTrace((Throwable)t);
            }
        }
    }

    public int getPhpFcgiConnectionPoolSize() {
        return this.phpFcgiConnectionPoolSize;
    }

    public void init(ServletContext context) {
        String value;
        try {
            value = context.getInitParameter("prefer_system_php_exec");
            if (value == null) {
                value = System.getProperty("php.java.bridge.prefer_system_php_exec");
            }
            if (value == null) {
                value = "";
            }
            value = value.trim();
            if ((value = value.toLowerCase()).equals("off") || value.equals("false")) {
                this.preferSystemPhp = false;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        String val = null;
        try {
            val = context.getInitParameter("php_fcgi_children");
            if (val == null) {
                val = context.getInitParameter("PHP_FCGI_CHILDREN");
            }
            if (val == null) {
                val = System.getProperty("php.java.bridge.php_fcgi_children");
            }
            if (val == null) {
                val = context.getInitParameter("php_fcgi_connection_pool_size");
            }
            if (val == null) {
                val = System.getProperty("php.java.bridge.php_fcgi_connection_pool_size");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (val == null) {
            val = "5";
        }
        this.phpFcgiConnectionPoolSize = Integer.parseInt(val);
        val = null;
        try {
            val = context.getInitParameter("php_fcgi_external_socket_pool");
            if (val == null) {
                val = context.getInitParameter("PHP_FCGI_EXTERNAL_SOCKET_POOL");
            }
            if (val == null) {
                val = System.getProperty("php.java.bridge.php_fcgi_external_socket_pool");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.socketPort = val;
        val = null;
        try {
            val = context.getInitParameter("php_fcgi_connection_pool_timeout");
            if (val == null) {
                val = System.getProperty("php.java.bridge.php_fcgi_connection_pool_timeout");
            }
            if (val != null) {
                this.phpFcgiConnectionPoolTimeout = Integer.parseInt(val);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (val == null) {
            val = "-1";
        }
        this.phpFcgiConnectionPoolTimeout = Integer.parseInt(val);
        val = null;
        this.phpIncludeJava = false;
        try {
            val = context.getInitParameter("php_include_java");
            if (val == null) {
                val = context.getInitParameter("PHP_INCLUDE_JAVA");
            }
            if (val == null) {
                val = System.getProperty("php.java.bridge.php_include_java");
            }
            if (val != null && (val.equalsIgnoreCase("on") || val.equalsIgnoreCase("true"))) {
                this.phpIncludeJava = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        val = null;
        this.phpIncludeDebugger = true;
        try {
            val = context.getInitParameter("php_include_debugger");
            if (val == null) {
                val = context.getInitParameter("PHP_INCLUDE_DEBUGGER");
            }
            if (val == null) {
                val = System.getProperty("php.java.bridge.php_include_debugger");
            }
            if (val != null && (val.equalsIgnoreCase("off") || val.equalsIgnoreCase("false"))) {
                this.phpIncludeDebugger = false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        val = null;
        try {
            val = context.getInitParameter("php_fcgi_max_requests");
            if (val == null) {
                val = System.getProperty("php.java.bridge.php_fcgi_max_requests");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (val == null) {
            val = "500";
        }
        this.phpFcgiMaxRequests = Integer.parseInt(val);
        this.promiscuous = true;
        value = null;
        try {
            value = context.getInitParameter("promiscuous");
            if (value == null) {
                value = "";
            }
            value = value.trim();
            if ((value = value.toLowerCase()).equals("off") || value.equals("false")) {
                this.promiscuous = false;
            }
        }
        catch (Exception t) {
            t.printStackTrace();
        }
        this.checkCgiBinary(context);
        this.createPhpFiles(context);
    }
}

