/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.Attribute;
import gnu.bytecode.ClassTypeWriter;
import gnu.bytecode.CodeAttr;
import java.io.DataOutputStream;
import java.io.IOException;

public class LineNumbersAttr
extends Attribute {
    short[] linenumber_table;
    int linenumber_count;

    public LineNumbersAttr(CodeAttr codeAttr) {
        super("LineNumberTable");
        this.addToFrontOf(codeAttr);
        codeAttr.lines = this;
    }

    public LineNumbersAttr(short[] sArray, CodeAttr codeAttr) {
        this(codeAttr);
        this.linenumber_table = sArray;
        this.linenumber_count = sArray.length >> 1;
    }

    public void put(int n, int n2) {
        if (this.linenumber_table == null) {
            this.linenumber_table = new short[32];
        } else if (2 * this.linenumber_count >= this.linenumber_table.length) {
            short[] sArray = new short[2 * this.linenumber_table.length];
            System.arraycopy(this.linenumber_table, 0, sArray, 0, 2 * this.linenumber_count);
            this.linenumber_table = sArray;
        }
        this.linenumber_table[2 * this.linenumber_count] = (short)n2;
        this.linenumber_table[2 * this.linenumber_count + 1] = (short)n;
        ++this.linenumber_count;
    }

    public final int getLength() {
        return 2 + 4 * this.linenumber_count;
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.linenumber_count);
        int n = 2 * this.linenumber_count;
        int n2 = 0;
        while (n2 < n) {
            dataOutputStream.writeShort(this.linenumber_table[n2]);
            ++n2;
        }
    }

    public void print(ClassTypeWriter classTypeWriter) {
        classTypeWriter.print("Attribute \"");
        classTypeWriter.print(this.getName());
        classTypeWriter.print("\", length:");
        classTypeWriter.print(this.getLength());
        classTypeWriter.print(", count: ");
        classTypeWriter.println(this.linenumber_count);
        int n = 0;
        while (n < this.linenumber_count) {
            classTypeWriter.print("  line: ");
            classTypeWriter.print(this.linenumber_table[2 * n + 1] & 0xFFFF);
            classTypeWriter.print(" at pc: ");
            classTypeWriter.println(this.linenumber_table[2 * n] & 0xFFFF);
            ++n;
        }
    }
}

