/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Type;
import gnu.bytecode.VarEnumerator;
import gnu.bytecode.Variable;

public class Scope {
    Scope parent;
    Scope nextSibling;
    Scope firstChild;
    Scope lastChild;
    int start_pc;
    int end_pc;
    Variable vars;
    Variable last_var;

    public final Variable firstVar() {
        return this.vars;
    }

    public VarEnumerator allVars() {
        return new VarEnumerator(this);
    }

    public void linkChild(Scope scope) {
        this.parent = scope;
        if (scope == null) {
            return;
        }
        if (scope.lastChild == null) {
            scope.firstChild = this;
        } else {
            scope.lastChild.nextSibling = this;
        }
        scope.lastChild = this;
    }

    public Variable addVariable(CodeAttr codeAttr, Type type, String string) {
        Variable variable = new Variable(string, type);
        this.addVariable(codeAttr, variable);
        return variable;
    }

    public void addVariable(Variable variable) {
        if (this.last_var == null) {
            this.vars = variable;
        } else {
            this.last_var.next = variable;
        }
        this.last_var = variable;
    }

    public void addVariableAfter(Variable variable, Variable variable2) {
        if (variable == null) {
            variable2.next = this.vars;
            this.vars = variable2;
        } else {
            variable2.next = variable.next;
            variable.next = variable2;
        }
        if (this.last_var == variable) {
            this.last_var = variable2;
        }
        if (variable2.next == variable2) {
            throw new Error("cycle");
        }
    }

    public void addVariable(CodeAttr codeAttr, Variable variable) {
        variable.start_pc = codeAttr == null ? 0 : codeAttr.PC;
        this.addVariable(variable);
        if (variable.isSimple() && codeAttr != null) {
            variable.allocateLocal(codeAttr);
        }
    }

    Variable find_var(int n) {
        Variable variable = this.vars;
        while (--n >= 0) {
            variable = variable.next;
        }
        return variable;
    }

    static boolean equals(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        if (byArray == byArray2) {
            return true;
        }
        int n = byArray.length;
        while (--n >= 0) {
            if (byArray[n] == byArray2[n]) continue;
            return false;
        }
        return true;
    }

    public void setStartPC(int n) {
        this.start_pc = n;
        Variable variable = this.firstVar();
        while (variable != null) {
            variable.start_pc = n;
            variable = variable.nextVar();
        }
    }

    Variable lookup(String string) {
        Variable variable = this.vars;
        while (variable != null) {
            if (string.equals(variable.name)) {
                return variable;
            }
            variable = variable.next;
        }
        return null;
    }
}

