/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.functions;

import gnu.lists.CharSequence;
import gnu.lists.Consumable;
import gnu.lists.Consumer;
import gnu.lists.FString;
import gnu.lists.FormatToConsumer;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.lists.SimpleVector;
import gnu.lists.Strings;
import gnu.mapping.Binding;
import gnu.mapping.OutPort;
import gnu.mapping.Printable;
import gnu.mapping.Procedure1or2;
import gnu.mapping.Values;
import gnu.text.Char;
import java.io.PrintWriter;

public class DisplayFormat
extends Procedure1or2
implements FormatToConsumer {
    boolean readable;
    char language;

    public DisplayFormat(boolean bl, char c) {
        this.readable = bl;
        this.language = c;
    }

    public boolean getReadableOutput() {
        return this.readable;
    }

    protected void write(String string, Consumer consumer) {
        if (consumer instanceof OutPort) {
            ((OutPort)consumer).write(string);
        } else {
            consumer.writeChars(string);
        }
    }

    public void writeBoolean(boolean bl, Consumer consumer) {
        this.write(this.language == 'S' ? (bl ? "#t" : "#f") : (bl ? "t" : "nil"), consumer);
    }

    public void writeChar(int n, Consumer consumer) {
        if (!this.getReadableOutput()) {
            consumer.writeChar(n);
        } else {
            this.write(Char.toScmReadableString(n), consumer);
        }
    }

    public void writeList(LList lList, OutPort outPort) {
        Object object2 = lList;
        outPort.startLogicalBlock("(", false, ")");
        while (object2 instanceof Pair) {
            if (object2 != lList) {
                outPort.writeSpaceFill();
            }
            Pair pair = (Pair)object2;
            outPort.writeObject(pair.car);
            object2 = pair.cdr;
        }
        if (object2 != LList.Empty) {
            outPort.writeSpaceFill();
            outPort.writeChars(". ");
            outPort.writeObject(object2);
        }
        outPort.endLogicalBlock(")");
    }

    public void writeObject(Object object2, Consumer consumer) {
        if (object2 instanceof Boolean) {
            this.writeBoolean((Boolean)object2, consumer);
        } else if (object2 instanceof Char) {
            this.writeChar(((Char)object2).charValue(), consumer);
        } else if (object2 instanceof Character) {
            this.writeChar(((Character)object2).charValue(), consumer);
        } else if (object2 instanceof Binding) {
            this.writeObject(object2.toString(), consumer);
        } else if (object2 instanceof CharSequence) {
            CharSequence charSequence = (CharSequence)object2;
            if (this.getReadableOutput() && consumer instanceof PrintWriter) {
                Strings.printQuoted(charSequence, (PrintWriter)((Object)consumer), 0);
            } else if (object2 instanceof FString) {
                FString fString = (FString)object2;
                consumer.write(fString.data, 0, fString.size());
            } else {
                charSequence.consume(0, charSequence.size(), consumer);
            }
        } else if (object2 instanceof LList && consumer instanceof OutPort) {
            this.writeList((LList)object2, (OutPort)consumer);
        } else if (object2 instanceof SimpleVector) {
            String string;
            String string2;
            SimpleVector simpleVector = (SimpleVector)object2;
            String string3 = simpleVector.getTag();
            if (this.language == 'E') {
                string2 = "[";
                string = "]";
            } else {
                string2 = string3 == null ? "#(" : "#" + string3 + "(";
                string = ")";
            }
            if (consumer instanceof OutPort) {
                ((OutPort)consumer).startLogicalBlock(string2, false, string);
            } else {
                this.write(string2, consumer);
            }
            int n = simpleVector.size() << 1;
            int n2 = 0;
            while (n2 < n) {
                if (n2 > 0 && consumer instanceof OutPort) {
                    ((OutPort)consumer).writeSpaceFill();
                }
                if (!simpleVector.consumeNext(n2, null, consumer)) break;
                n2 += 2;
            }
            if (consumer instanceof OutPort) {
                ((OutPort)consumer).endLogicalBlock(string);
            } else {
                this.write(string, consumer);
            }
        } else if (object2 instanceof Consumable) {
            ((Consumable)object2).consume(consumer);
        } else if (object2 instanceof Printable && consumer instanceof PrintWriter) {
            ((Printable)object2).print((PrintWriter)((Object)consumer));
        } else if (object2 == null) {
            this.write("#!null", consumer);
        } else {
            this.write(object2.toString(), consumer);
        }
    }

    public Object apply1(Object object2) {
        this.format(object2, OutPort.outDefault());
        return Values.empty;
    }

    public Object apply2(Object object2, Object object3) {
        this.format(object2, (Consumer)object3);
        return Values.empty;
    }

    public void format(Object object2, Consumer consumer) {
        if (consumer instanceof OutPort) {
            OutPort outPort = (OutPort)consumer;
            FormatToConsumer formatToConsumer = outPort.objectFormat;
            try {
                outPort.objectFormat = this;
                consumer.writeObject(object2);
                Object var6_5 = null;
                outPort.objectFormat = formatToConsumer;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                outPort.objectFormat = formatToConsumer;
                throw throwable;
            }
        } else {
            consumer.writeObject(object2);
        }
    }
}

