/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.reflect;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.Inlineable;
import gnu.expr.Interpreter;
import gnu.expr.Target;
import gnu.kawa.reflect.ClassMethods;
import gnu.kawa.reflect.SlotGet;
import gnu.mapping.Procedure;
import gnu.mapping.Procedure3;
import gnu.mapping.Values;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import kawa.standard.Scheme;

public class SlotSet
extends Procedure3
implements Inlineable {
    static boolean isStatic;

    public static void apply(Object object2, String string, Object object3) {
        Interpreter interpreter = Interpreter.defaultInterpreter;
        boolean bl = false;
        string = Compilation.mangleName(string);
        Class<?> clazz = isStatic ? SlotGet.coerceToClass(object2) : object2.getClass();
        try {
            Field field = clazz.getField(string);
            field.set(object2, interpreter.coerceFromObject(field.getType(), object3));
            return;
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            bl = true;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 3);
        stringBuffer.append("get");
        stringBuffer.append(Character.toTitleCase(string.charAt(0)));
        stringBuffer.append(string.substring(1));
        try {
            java.lang.reflect.Method method = clazz.getMethod(stringBuffer.toString(), SlotGet.noClasses);
            stringBuffer.setCharAt(0, 's');
            Class[] classArray = new Class[]{method.getReturnType()};
            java.lang.reflect.Method method2 = clazz.getMethod(stringBuffer.toString(), classArray);
            Object[] objectArray = new Object[]{interpreter.coerceFromObject(classArray[0], object3)};
            method2.invoke(object2, objectArray);
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new RuntimeException(throwable.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            bl = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (bl) {
            throw new RuntimeException("illegal access for field " + string);
        }
        throw new RuntimeException("no such field " + string + " in " + clazz.getName());
    }

    public Object apply3(Object object2, Object object3, Object object4) {
        SlotSet.apply(object2, (String)object3, object4);
        return Values.empty;
    }

    static Object getField(Type type, String string) {
        if (type instanceof ClassType && string != null) {
            ClassType classType = (ClassType)type;
            gnu.bytecode.Field field = classType.getField(string);
            if (field != null) {
                return field;
            }
            StringBuffer stringBuffer = new StringBuffer(string.length() + 3);
            stringBuffer.append("get");
            stringBuffer.append(Character.toTitleCase(string.charAt(0)));
            stringBuffer.append(string.substring(1));
            Method method = classType.getMethod(stringBuffer.toString(), Type.typeArray0);
            if (method == null) {
                return null;
            }
            Type type2 = method.getReturnType();
            stringBuffer.setCharAt(0, 's');
            Type[] typeArray = new Type[]{type2};
            method = classType.getMethod(stringBuffer.toString(), typeArray);
            return method;
        }
        return null;
    }

    static void compileSet(Procedure procedure, ClassType classType, Expression expression, Object object2, Compilation compilation) {
        CodeAttr codeAttr = compilation.getCode();
        if (object2 instanceof gnu.bytecode.Field) {
            gnu.bytecode.Field field = (gnu.bytecode.Field)object2;
            boolean bl = field.getStaticFlag();
            if (isStatic && !bl) {
                compilation.error('e', "cannot access non-static field `" + field.getName() + "' using `" + procedure.getName() + '\'');
            }
            expression.compile(compilation, Target.pushValue(field.getType()));
            if (bl) {
                codeAttr.emitPutStatic(field);
            } else {
                codeAttr.emitPutField(field);
            }
            return;
        }
        if (object2 instanceof Method) {
            Method method = (Method)object2;
            boolean bl = method.getStaticFlag();
            if (isStatic && !bl) {
                compilation.error('e', "cannot call non-static getter method `" + method.getName() + "' using `" + procedure.getName() + '\'');
            }
            Type[] typeArray = method.getParameterTypes();
            expression.compile(compilation, Target.pushValue(typeArray[0]));
            if (bl) {
                codeAttr.emitInvokeStatic(method);
            } else if (classType.isInterface()) {
                codeAttr.emitInvokeInterface(method);
            } else {
                codeAttr.emitInvokeVirtual(method);
            }
            return;
        }
    }

    public void compile(ApplyExp applyExp, Compilation compilation, Target target) {
        Expression[] expressionArray = applyExp.getArgs();
        int n = expressionArray.length;
        if (n != 3) {
            String string = n < 3 ? "too few" : "too many";
            compilation.error('e', string + " arguments to `" + this.getName() + '\'');
            compilation.compileConstant(null, target);
            return;
        }
        Expression expression = expressionArray[0];
        Expression expression2 = expressionArray[1];
        Expression expression3 = expressionArray[2];
        Type type = isStatic ? Scheme.exp2Type(expression) : expression.getType();
        String string = ClassMethods.checkName(expression2);
        if (type instanceof ClassType && string != null) {
            ClassType classType = (ClassType)type;
            Object object2 = SlotSet.getField(classType, string);
            if (object2 != null) {
                boolean bl = object2 instanceof gnu.bytecode.Field ? ((gnu.bytecode.Field)object2).getStaticFlag() : ((Method)object2).getStaticFlag();
                expressionArray[0].compile(compilation, bl ? Target.Ignore : Target.pushValue(classType));
                SlotSet.compileSet(this, classType, expressionArray[2], object2, compilation);
                compilation.compileConstant(Values.empty, target);
                return;
            }
            if (type != Type.pointer_type) {
                compilation.error('e', "no slot `" + string + "' in " + classType.getName());
            }
        }
        ApplyExp.compile(applyExp, compilation, target);
    }

    public Type getReturnType(Expression[] expressionArray) {
        return Type.void_type;
    }
}

