/*
 * Decompiled with CFR 0.152.
 */
package kawa.standard;

import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.ModuleExp;
import gnu.expr.ScopeExp;
import gnu.expr.SetExp;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.mapping.Printable;
import java.util.Vector;
import kawa.lang.Syntax;
import kawa.lang.Translator;

public class define_variable
extends Syntax
implements Printable {
    public boolean scanForDefinitions(Pair pair, Vector vector, ScopeExp scopeExp, Translator translator) {
        if (!(pair.cdr instanceof Pair)) {
            return super.scanForDefinitions(pair, vector, scopeExp, translator);
        }
        Pair pair2 = (Pair)pair.cdr;
        if (pair2.car instanceof String) {
            String string = (String)pair2.car;
            Declaration declaration = scopeExp.lookup(string);
            if (declaration == null) {
                declaration = new Declaration(string);
                scopeExp.addDeclaration(declaration);
            } else {
                translator.error('w', "duplicate declaration for `" + string + "'");
            }
            pair2 = Translator.makePair(pair2, declaration, pair2.cdr);
            pair = Translator.makePair(pair, this, pair2);
            if (scopeExp instanceof ModuleExp) {
                declaration.setCanRead(true);
                declaration.setCanWrite(true);
            }
        }
        vector.addElement(pair);
        return true;
    }

    public Expression rewriteForm(Pair pair, Translator translator) {
        Object object2;
        Object object3 = pair.cdr;
        String string = null;
        Expression expression = null;
        Declaration declaration = null;
        if (object3 instanceof Pair) {
            object2 = (Pair)object3;
            if (((Pair)object2).car instanceof String && ((Pair)object2).cdr instanceof Pair) {
                Pair pair2 = (Pair)((Pair)object2).cdr;
                if (pair2.cdr == LList.Empty) {
                    string = (String)((Pair)object2).car;
                    expression = translator.rewrite(pair2.car);
                }
            } else if (((Pair)object2).car instanceof Declaration && ((Pair)object2).cdr instanceof Pair) {
                Pair pair3 = (Pair)((Pair)object2).cdr;
                if (pair3.cdr == LList.Empty) {
                    declaration = (Declaration)((Pair)object2).car;
                    string = declaration.getName();
                    expression = translator.rewrite(pair3.car);
                }
            }
        }
        if (string == null) {
            return translator.syntaxError("invalid syntax for " + this.getName());
        }
        object2 = new SetExp(string, expression);
        ((SetExp)object2).setDefining(true);
        ((SetExp)object2).setSetIfUnbound(true);
        if (declaration != null) {
            ((SetExp)object2).binding = declaration;
            if (declaration.context instanceof ModuleExp && declaration.getCanWrite()) {
                expression = null;
            }
            declaration.noteValue(expression);
        }
        return object2;
    }
}

