/*
 * Decompiled with CFR 0.152.
 */
package kawa.standard;

import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.LetExp;
import gnu.expr.QuoteExp;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.mapping.Printable;
import kawa.lang.Macro;
import kawa.lang.Syntax;
import kawa.lang.Translator;

public class let_syntax
extends Syntax
implements Printable {
    boolean recursive;

    public let_syntax(boolean bl) {
        this.recursive = bl;
    }

    public Expression rewrite(Object object2, Translator translator) {
        Object object3;
        if (!(object2 instanceof Pair)) {
            return translator.syntaxError("missing let-syntax arguments");
        }
        Pair pair = (Pair)object2;
        Object object4 = pair.car;
        Object object5 = pair.cdr;
        int n = LList.length(object4);
        Expression[] expressionArray = new Expression[n];
        Declaration[] declarationArray = new Declaration[n];
        Macro[] macroArray = new Macro[n];
        Object[] objectArray = new Object[n];
        LetExp letExp = new LetExp(expressionArray);
        int n2 = 0;
        while (n2 < n) {
            Pair pair2 = (Pair)object4;
            if (!(pair2.car instanceof Pair)) {
                return translator.syntaxError("let binding is not a pair");
            }
            object3 = (Pair)pair2.car;
            if (!(((Pair)object3).car instanceof String)) {
                return translator.syntaxError("variable in let binding is not a symbol");
            }
            String string = (String)((Pair)object3).car;
            if (!(((Pair)object3).cdr instanceof Pair)) {
                return translator.syntaxError("let has no value for `" + string + "'");
            }
            object3 = (Pair)((Pair)object3).cdr;
            if (((Pair)object3).cdr != LList.Empty) {
                return translator.syntaxError("let binding for `" + string + "' is improper list");
            }
            macroArray[n2] = new Macro(string);
            declarationArray[n2] = new Declaration(string);
            macroArray[n2].bind(declarationArray[n2]);
            objectArray[n2] = ((Pair)object3).car;
            letExp.addDeclaration(declarationArray[n2]);
            expressionArray[n2] = QuoteExp.nullExp;
            object4 = pair2.cdr;
            ++n2;
        }
        if (this.recursive) {
            translator.push(letExp);
        }
        int n3 = 0;
        while (n3 < n) {
            expressionArray[n3] = translator.rewrite(objectArray[n3]);
            macroArray[n3].expander = expressionArray[n3];
            ++n3;
        }
        if (!this.recursive) {
            translator.push(letExp);
        }
        object3 = translator.rewrite_body(object5);
        translator.pop(letExp);
        return object3;
    }
}

